/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.service;

import cn.com.duiba.bigdata.common.biz.dto.KeyValueDto;
import cn.com.duiba.bigdata.common.biz.dto.SortDto;
import cn.com.duiba.bigdata.common.biz.enums.HologresShowTypeEnum;
import cn.com.duiba.bigdata.common.biz.enums.OperatorsEnum;
import cn.com.duiba.bigdata.common.biz.enums.SortEnum;
import cn.com.duiba.bigdata.common.biz.form.HoloQueryForm;
import cn.com.duiba.bigdata.common.biz.interfaces.CalculateMetricEnum;
import cn.com.duiba.bigdata.common.biz.interfaces.CombineMetricEnum;
import cn.com.duiba.bigdata.common.biz.interfaces.DictEnum;
import cn.com.duiba.bigdata.common.biz.interfaces.DimensionEnum;
import cn.com.duiba.bigdata.common.biz.interfaces.MetricEnum;
import cn.com.duiba.bigdata.common.biz.service.SqlService;
import cn.com.duiba.bigdata.common.biz.utils.BusinessEnumUtil;
import cn.com.duiba.bigdata.common.biz.utils.MD5Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoloSqlService {
    private static final Logger log = LoggerFactory.getLogger(HoloSqlService.class);

    public static String getQuerySql(HoloQueryForm form, List<String> dimensionList, int businessType, int resultType) throws Exception {
        String orderBySql;
        String havingSql;
        String groupBySumSql;
        HoloSqlService.dealABTestCondition(form);
        HoloSqlService.addOrderMetricList(form, businessType);
        HoloSqlService.addCalculateMetricList(form, businessType);
        HoloSqlService.addCombineMetricList(form, businessType);
        HoloSqlService.addOrderByMetric(form);
        List<Object> metricList = HoloSqlService.getMetricList(form.getMetricList(), businessType);
        List<KeyValueDto> metricConditionList = HoloSqlService.getMetricConditionList(form);
        StringBuilder sql = new StringBuilder("select ");
        String dimensionSumSql = HoloSqlService.getDimensionSumSql(form.getDataShowType(), dimensionList, businessType, resultType);
        if (StringUtils.isNotBlank((CharSequence)dimensionSumSql)) {
            sql.append(dimensionSumSql);
        }
        String metricSumSql = HoloSqlService.getMetricSumSql(metricList, form.getCalculateMetricList(), form.getCombineMetricList(), businessType, resultType);
        sql.append(metricSumSql);
        String querySql = HoloSqlService.getQueryUnionAllSql(form, metricList, businessType);
        if (StringUtils.isBlank((CharSequence)querySql)) {
            return null;
        }
        sql.append(" from (").append(querySql).append(") t ");
        String leftJoinSql = HoloSqlService.getDictLeftJoinSql(dimensionList, businessType);
        if (StringUtils.isNotBlank((CharSequence)leftJoinSql)) {
            sql.append(leftJoinSql);
        }
        if (StringUtils.isNotBlank((CharSequence)(groupBySumSql = HoloSqlService.getGroupBySumSql(form.getDataShowType(), dimensionList, businessType)))) {
            sql.append(" group by ").append(groupBySumSql);
        }
        if (StringUtils.isNotBlank((CharSequence)(havingSql = HoloSqlService.getHavingSumSql(metricConditionList, businessType)))) {
            sql.append(" having ").append(havingSql);
        }
        if (StringUtils.isNotBlank((CharSequence)(orderBySql = HoloSqlService.getOrderBySql(form.getDataShowType(), form.getOrderByMetric(), businessType, resultType)))) {
            sql.append(orderBySql);
        }
        if (form.getPageSize() != null && form.getPageNumber() != null) {
            sql.append(" limit ").append(form.getPageSize()).append(" offset ").append((form.getPageNumber() - 1) * form.getPageSize());
        }
        return sql.toString();
    }

    private static void dealABTestCondition(HoloQueryForm form) {
        if (CollectionUtils.isEmpty(form.getConditionList())) {
            return;
        }
        String abtestPlanId = "";
        String abtestGroupId = "";
        ArrayList<KeyValueDto> conditionList = new ArrayList<KeyValueDto>();
        for (KeyValueDto dto : form.getConditionList()) {
            if (dto.getKey().toString().equals(SqlService.ABTEST_PLAN_ID)) {
                abtestPlanId = dto.getValue().toString();
                continue;
            }
            if (dto.getKey().toString().equals(SqlService.ABTEST_GROUP_ID)) {
                abtestGroupId = dto.getValue().toString();
                continue;
            }
            conditionList.add(dto);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{abtestPlanId, abtestGroupId})) {
            String abtest = abtestPlanId + "-" + abtestGroupId;
            conditionList.add(new KeyValueDto(SqlService.ABTEST, abtest, OperatorsEnum.ARRAY.toString()));
            form.setConditionList(conditionList);
        }
    }

    private static void addOrderMetricList(HoloQueryForm form, int businessType) {
        if (form.getOrderByMetric() == null) {
            return;
        }
        String metric = form.getOrderByMetric().getKey();
        if (Objects.requireNonNull(BusinessEnumUtil.getMetricEnumList(businessType)).contains(metric)) {
            List<String> metricList = form.getMetricList();
            if (metricList == null) {
                metricList = new ArrayList<String>();
                form.setMetricList(metricList);
            }
            metricList.add(metric);
        } else if (Objects.requireNonNull(BusinessEnumUtil.getCalculateMetricEnumList(businessType)).contains(metric)) {
            List<String> metricList = form.getCalculateMetricList();
            if (metricList == null) {
                metricList = new ArrayList<String>();
                form.setCalculateMetricList(metricList);
            }
            metricList.add(metric);
        } else if (Objects.requireNonNull(BusinessEnumUtil.getCombineMetricEnumList(businessType)).contains(metric)) {
            List<String> metricList = form.getCombineMetricList();
            if (metricList == null) {
                metricList = new ArrayList<String>();
                form.setCombineMetricList(metricList);
            }
            metricList.add(metric);
        }
    }

    private static void addCalculateMetricList(HoloQueryForm form, int businessType) {
        if (CollectionUtils.isEmpty(form.getCalculateMetricList())) {
            return;
        }
        if (CollectionUtils.isEmpty(form.getMetricList())) {
            form.setMetricList(new ArrayList<String>());
        }
        for (String metric : form.getCalculateMetricList()) {
            CalculateMetricEnum metricEnum = Objects.requireNonNull(BusinessEnumUtil.getCalculateMetricEnum(businessType, metric));
            form.getMetricList().add(metricEnum.getNumerator());
            form.getMetricList().add(metricEnum.getDenominator());
        }
    }

    private static void addCombineMetricList(HoloQueryForm form, int businessType) {
        if (CollectionUtils.isEmpty(form.getCombineMetricList())) {
            return;
        }
        if (CollectionUtils.isEmpty(form.getMetricList())) {
            form.setMetricList(new ArrayList<String>());
        }
        for (String combineMetric : form.getCombineMetricList()) {
            String[] array;
            CombineMetricEnum metricEnum = Objects.requireNonNull(BusinessEnumUtil.getCombineMetricEnum(businessType, combineMetric));
            for (String metric : array = StringUtils.split((String)metricEnum.getMetricList(), (String)",")) {
                form.getMetricList().add(metric);
            }
        }
    }

    private static void addOrderByMetric(HoloQueryForm form) {
        if (form.getOrderByMetric() != null) {
            return;
        }
        String metric = form.getMetricList().get(0);
        SortDto sortDto = new SortDto(metric, SortEnum.DESC.toString());
        form.setOrderByMetric(sortDto);
    }

    public static List<Object> getMetricList(List<String> metricList, int businessType) {
        HashSet<String> metricSet = new HashSet<String>(metricList);
        ArrayList<Object> list = new ArrayList<Object>();
        HashMap map = new HashMap();
        for (String metric : metricSet) {
            MetricEnum metricEnum = Objects.requireNonNull(BusinessEnumUtil.getMetricEnum(businessType, metric));
            StringBuilder sb = new StringBuilder();
            sb.append(metricEnum.getTableName());
            sb.append(metricEnum.getCondition());
            String md5 = MD5Util.computeMD5(sb.toString());
            if (!map.containsKey(md5)) {
                map.put(md5, new ArrayList());
            }
            ((List)map.get(md5)).add(metric);
        }
        for (List metricGroupList : map.values()) {
            if (metricGroupList.size() == 1) {
                list.add(metricGroupList.get(0));
                continue;
            }
            list.add(metricGroupList);
        }
        return list;
    }

    private static List<KeyValueDto> getMetricConditionList(HoloQueryForm form) {
        if (CollectionUtils.isEmpty(form.getConditionList())) {
            return null;
        }
        ArrayList<KeyValueDto> dimConditionList = new ArrayList<KeyValueDto>();
        ArrayList<KeyValueDto> metricConditionList = new ArrayList<KeyValueDto>();
        for (KeyValueDto dto : form.getConditionList()) {
            int type = OperatorsEnum.valueOf(dto.getSymbol()).getType();
            if (type == 1) {
                dimConditionList.add(dto);
                continue;
            }
            if (type != 2) continue;
            metricConditionList.add(dto);
        }
        if (metricConditionList.size() > 0) {
            form.setConditionList(dimConditionList);
        }
        return metricConditionList;
    }

    private static String getDimensionSumSql(String dataShowType, List<String> dimensionList, int businessType, int resultType) {
        StringBuilder sb = new StringBuilder();
        if (!HologresShowTypeEnum.ALL.toString().equals(dataShowType)) {
            HologresShowTypeEnum hologresShowTypeEnum = HologresShowTypeEnum.valueOf(dataShowType);
            if (resultType == 1) {
                sb.append(hologresShowTypeEnum.getFormatSegment()).append(" as ").append("\"").append(hologresShowTypeEnum.getFieldName()).append("\"").append(", ");
            } else if (resultType == 2) {
                sb.append(hologresShowTypeEnum.getFormatSegment()).append(" as ").append(hologresShowTypeEnum.getFieldName()).append(", ");
            }
        }
        sb.append(HoloSqlService.getDimensionSumSql(dimensionList, businessType, resultType));
        return sb.toString();
    }

    private static String getDimensionSumSql(List<String> dimensionList, int businessType, int resultType) {
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isEmpty(dimensionList)) {
            return sb.toString();
        }
        for (String dim : dimensionList) {
            if (Objects.requireNonNull(BusinessEnumUtil.getDictEnumList(businessType)).contains(dim)) {
                DictEnum dictEnum = Objects.requireNonNull(BusinessEnumUtil.getDictEnum(businessType, dim));
                if (resultType == 1) {
                    sb.append(dictEnum.getAliasName()).append(".").append(dictEnum.getTableFieldName()).append(" as ").append("\"").append(dictEnum.getTableFieldName()).append("\"").append(", ");
                    continue;
                }
                if (resultType != 2) continue;
                sb.append(dictEnum.getAliasName()).append(".").append(dictEnum.getTableFieldName()).append(" as ").append(dictEnum.getTableFieldName()).append(", ");
                continue;
            }
            DimensionEnum dimensionEnum = Objects.requireNonNull(BusinessEnumUtil.getDimensionEnum(businessType, dim));
            if (resultType == 1) {
                sb.append(dimensionEnum.getResultFieldName()).append(" as ").append("\"").append(dimensionEnum.getResultFieldName()).append("\"").append(", ");
                continue;
            }
            if (resultType != 2) continue;
            sb.append(dimensionEnum.getResultFieldName()).append(" as ").append(dimensionEnum.getResultFieldName()).append(", ");
        }
        return sb.toString();
    }

    public static String getMetricSumSql(List<Object> metricList, List<String> calculateMetricList, List<String> combineMetricList, int businessType, int resultType) {
        StringBuilder sb = new StringBuilder();
        for (Object metric : metricList) {
            sb.append(HoloSqlService.getObjectMetricSumSql(metric, businessType, resultType));
        }
        if (CollectionUtils.isNotEmpty(calculateMetricList)) {
            HashSet<String> calculateMetricSet = new HashSet<String>(calculateMetricList);
            for (String metric : calculateMetricSet) {
                sb.append(HoloSqlService.getCalculateMetricSumSql(metric, businessType, resultType));
            }
        }
        if (CollectionUtils.isNotEmpty(combineMetricList)) {
            HashSet<String> combineMetricSet = new HashSet<String>(combineMetricList);
            for (String metric : combineMetricSet) {
                sb.append(HoloSqlService.getCombineMetricSumSql(metric, businessType, resultType));
            }
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private static String getObjectMetricSumSql(Object metric, int businessType, int resultType) {
        StringBuilder sb = new StringBuilder();
        if (metric instanceof String) {
            sb.append(HoloSqlService.getStringMetricSumSql(metric.toString(), businessType, resultType));
        } else if (metric instanceof List) {
            List metricGroup = (List)metric;
            for (String subMetric : metricGroup) {
                sb.append(HoloSqlService.getStringMetricSumSql(subMetric, businessType, resultType));
            }
        }
        return sb.toString();
    }

    private static String getStringMetricSumSql(String metric, int businessType, int resultType) {
        StringBuilder sb = new StringBuilder();
        String resultFieldName = Objects.requireNonNull(BusinessEnumUtil.getMetricEnum(businessType, metric)).getResultFieldName();
        if (resultType == 1) {
            sb.append("sum(").append(resultFieldName).append(")").append(" as ").append("\"").append(resultFieldName).append("\"").append(",");
        } else if (resultType == 2) {
            sb.append("sum(").append(resultFieldName).append(")").append(" as ").append(resultFieldName).append(",");
        }
        return sb.toString();
    }

    private static String getCalculateMetricSumSql(String metric, int businessType, int resultType) {
        StringBuilder sb = new StringBuilder();
        CalculateMetricEnum calculateMetricEnum = Objects.requireNonNull(BusinessEnumUtil.getCalculateMetricEnum(businessType, metric));
        if (resultType == 1) {
            sb.append(calculateMetricEnum.getMetricSql()).append(" as ").append("\"").append(calculateMetricEnum.getResultFieldName()).append("\"").append(",");
        } else if (resultType == 2) {
            sb.append(calculateMetricEnum.getMetricSql()).append(" as ").append(calculateMetricEnum.getResultFieldName()).append(",");
        }
        return sb.toString();
    }

    private static String getCombineMetricSumSql(String metric, int businessType, int resultType) {
        StringBuilder sb = new StringBuilder();
        CombineMetricEnum combineMetricEnum = Objects.requireNonNull(BusinessEnumUtil.getCombineMetricEnum(businessType, metric));
        if (resultType == 1) {
            sb.append(combineMetricEnum.getMetricSql()).append(" as ").append("\"").append(combineMetricEnum.getResultFieldName()).append("\"").append(",");
        } else if (resultType == 2) {
            sb.append(combineMetricEnum.getMetricSql()).append(" as ").append(combineMetricEnum.getResultFieldName()).append(",");
        }
        return sb.toString();
    }

    private static String getDictLeftJoinSql(List<String> dimensionList, int businessType) {
        if (CollectionUtils.isEmpty(dimensionList)) {
            return null;
        }
        ArrayList<String> dictList = new ArrayList<String>();
        for (String string : dimensionList) {
            if (!Objects.requireNonNull(BusinessEnumUtil.getDictEnumList(businessType)).contains(string)) continue;
            dictList.add(string);
        }
        if (CollectionUtils.isEmpty(dictList)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : dictList) {
            DictEnum dictEnum = Objects.requireNonNull(BusinessEnumUtil.getDictEnum(businessType, string));
            map.put(dictEnum.getTableName(), string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String dict : map.values()) {
            DictEnum dictEnum = Objects.requireNonNull(BusinessEnumUtil.getDictEnum(businessType, dict));
            DimensionEnum dimensionEnum = Objects.requireNonNull(BusinessEnumUtil.getDimensionEnum(businessType, dictEnum.getDimensionName()));
            stringBuilder.append("left join ").append(dictEnum.getTableName()).append(" ").append(dictEnum.getAliasName()).append(" on ").append("t.").append(dimensionEnum.getResultFieldName()).append(" = ").append(dictEnum.getAliasName()).append(".").append(dictEnum.getPrimaryKey()).append(" ");
        }
        return stringBuilder.toString();
    }

    private static String getGroupBySumSql(String dataShowType, List<String> dimensionList, int businessType) {
        String sql;
        StringBuilder sb = new StringBuilder();
        if (!HologresShowTypeEnum.ALL.toString().equals(dataShowType)) {
            sb.append(HologresShowTypeEnum.valueOf(dataShowType).getFieldName()).append(", ");
        }
        if (CollectionUtils.isNotEmpty(dimensionList)) {
            for (String dim : dimensionList) {
                if (Objects.requireNonNull(BusinessEnumUtil.getDictEnumList(businessType)).contains(dim)) {
                    DictEnum dictEnum = Objects.requireNonNull(BusinessEnumUtil.getDictEnum(businessType, dim));
                    sb.append(dictEnum.getAliasName()).append(".").append(dictEnum.getTableFieldName()).append(", ");
                    continue;
                }
                DimensionEnum dimensionEnum = Objects.requireNonNull(BusinessEnumUtil.getDimensionEnum(businessType, dim));
                sb.append(dimensionEnum.getResultFieldName()).append(", ");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(sql = sb.toString()))) {
            sql = sql.substring(0, sql.length() - 2);
        }
        return sql;
    }

    private static String getHavingSumSql(List<KeyValueDto> metricConditionList, int businessType) {
        if (CollectionUtils.isEmpty(metricConditionList)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (KeyValueDto dto : metricConditionList) {
            String symbol = OperatorsEnum.valueOf(dto.getSymbol()).getSymbol();
            String value = dto.getValue().toString();
            if (Objects.requireNonNull(BusinessEnumUtil.getMetricEnumList(businessType)).contains(dto.getKey().toString())) {
                MetricEnum metricEnum = Objects.requireNonNull(BusinessEnumUtil.getMetricEnum(businessType, dto.getKey().toString()));
                sb.append("sum(").append(metricEnum.getResultFieldName()).append(")").append(symbol).append(value).append(" and ");
                continue;
            }
            if (Objects.requireNonNull(BusinessEnumUtil.getCalculateMetricEnumList(businessType)).contains(dto.getKey().toString())) {
                CalculateMetricEnum calculateMetricEnum = Objects.requireNonNull(BusinessEnumUtil.getCalculateMetricEnum(businessType, dto.getKey().toString()));
                sb.append(calculateMetricEnum.getMetricSql()).append(symbol).append(value).append(" and ");
                continue;
            }
            if (!Objects.requireNonNull(BusinessEnumUtil.getCombineMetricEnumList(businessType)).contains(dto.getKey().toString())) continue;
            CombineMetricEnum combineMetricEnum = Objects.requireNonNull(BusinessEnumUtil.getCombineMetricEnum(businessType, dto.getKey().toString()));
            sb.append(combineMetricEnum.getMetricSql()).append(symbol).append(value).append(" and ");
        }
        sb.delete(sb.length() - " and ".length(), sb.length());
        return sb.toString();
    }

    private static String getOrderBySql(String dataShowType, SortDto orderByMetric, int businessType, int resultType) {
        StringBuilder sb = new StringBuilder();
        if (orderByMetric == null) {
            if (!HologresShowTypeEnum.ALL.toString().equals(dataShowType)) {
                if (resultType == 1) {
                    sb.append(" order by ").append("\"").append(HologresShowTypeEnum.valueOf(dataShowType).getFieldName()).append("\"").append(" ").append(SortEnum.ASC.getName());
                } else if (resultType == 2) {
                    sb.append(" order by ").append(HologresShowTypeEnum.valueOf(dataShowType).getFieldName()).append(" ").append(SortEnum.ASC.getName());
                }
            }
            return sb.toString();
        }
        String orderField = HoloSqlService.getOrderField(orderByMetric.getKey(), businessType);
        if (StringUtils.isBlank((CharSequence)orderField)) {
            return sb.toString();
        }
        if (resultType == 1) {
            orderField = "\"" + orderField + "\"";
        }
        sb.append(" order by ").append(orderField).append(" ").append(SortEnum.valueOf(orderByMetric.getValue()).getName());
        return sb.toString();
    }

    private static String getOrderField(String key, int businessType) {
        List<String> metricEnumList = Objects.requireNonNull(BusinessEnumUtil.getMetricEnumList(businessType));
        if (metricEnumList.contains(key)) {
            return Objects.requireNonNull(BusinessEnumUtil.getMetricEnum(businessType, key)).getResultFieldName();
        }
        List<String> calculateMetricEnumList = Objects.requireNonNull(BusinessEnumUtil.getCalculateMetricEnumList(businessType));
        if (calculateMetricEnumList.contains(key)) {
            return Objects.requireNonNull(BusinessEnumUtil.getCalculateMetricEnum(businessType, key)).getResultFieldName();
        }
        List<String> combineMetricEnumList = Objects.requireNonNull(BusinessEnumUtil.getCombineMetricEnumList(businessType));
        if (combineMetricEnumList.contains(key)) {
            return Objects.requireNonNull(BusinessEnumUtil.getCombineMetricEnum(businessType, key)).getResultFieldName();
        }
        List<String> dimensionEnumList = Objects.requireNonNull(BusinessEnumUtil.getDimensionEnumList(businessType));
        if (dimensionEnumList.contains(key)) {
            return Objects.requireNonNull(BusinessEnumUtil.getDimensionEnum(businessType, key)).getResultFieldName();
        }
        List<String> dictEnumList = Objects.requireNonNull(BusinessEnumUtil.getDictEnumList(businessType));
        if (dictEnumList.contains(key)) {
            return Objects.requireNonNull(BusinessEnumUtil.getDictEnum(businessType, key)).getTableFieldName();
        }
        return null;
    }

    private static String getQueryUnionAllSql(HoloQueryForm form, List<Object> metricList, int businessType) throws Exception {
        StringBuilder sql = new StringBuilder();
        for (Object metric : metricList) {
            String querySql = SqlService.getQuerySql(form, metricList, metric, businessType);
            if (!StringUtils.isNotBlank((CharSequence)querySql)) continue;
            sql.append(querySql);
            sql.append(" union all ");
        }
        if (StringUtils.isNotBlank((CharSequence)sql.toString())) {
            sql.delete(sql.length() - " union all ".length(), sql.length());
        }
        return sql.toString();
    }
}

