package cn.com.duiba.bigdata.common.biz.enums;

import cn.com.duiba.bigdata.common.biz.interfaces.MetricEnum;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xugf 2023-11-24
 * 推啊业务-基础指标字段
 */
public enum TuiaMetricEnum implements MetricEnum {

    //广告位访问pv
    SLOT_VISIT_PV("slotVisitPV", "count(1)", "tuia_activity_log_detail_month", "url_host = 'engine.tuia.cn' and url_path in ('/index/activity')", "广告位访问pv"),

    //广告位访问uv（根据rid去重）
    SLOT_VISIT_RID_UV("slotVisitRidUV", "approx_count_distinct(rid)", "tuia_activity_log_detail_month", "url_host = 'engine.tuia.cn' and url_path in ('/index/activity')", "广告位访问uv（根据rid去重）"),

    //广告位访问uv（根据cid去重）
    SLOT_VISIT_CID_UV("slotVisitCidUV", "approx_count_distinct(consumer_id)", "tuia_activity_log_detail_month", "url_host = 'engine.tuia.cn' and url_path in ('/index/activity')", "广告位访问uv（根据cid去重）"),

    //广告位访问pv(旧逻辑)
    SLOT_ACCESS_PV("slotAccessPV", "count(1)", "tuia_activity_log_detail_month", "url_host = 'activity.tuia.cn' and tenter='SOW' and url_path in ('/index/activity','/newactivity/index','/index/rid','/activity/index','/mainmeet/index','/actcenter/index','/direct/index','/game/index')", "广告位访问pv(旧逻辑)"),

    //广告位访问uv（根据cid去重）(旧逻辑)
    SLOT_ACCESS_UV("slotAccessUV", "approx_count_distinct(consumer_id)", "tuia_activity_log_detail_month", "url_host = 'activity.tuia.cn' and tenter='SOW' and url_path in ('/index/activity','/newactivity/index','/index/rid','/activity/index','/mainmeet/index','/actcenter/index','/direct/index','/game/index')", "活动访问uv（根据cid去重）"),

    //广告位访问uv（根据ip去重）(旧逻辑)
    SLOT_ACCESS_IP_UV("slotAccessIpUV", "approx_count_distinct(ip)", "tuia_activity_log_detail_month", "url_host = 'activity.tuia.cn' and tenter='SOW' and url_path in ('/index/activity','/newactivity/index','/index/rid','/activity/index','/mainmeet/index','/actcenter/index','/direct/index','/game/index')", "广告位访问uv（根据ip去重）(旧逻辑)"),

    //加密手机号接入pv(旧逻辑)
    SECRET_PHONE_PV("secretPhonePV", "count(secret_phone)", "tuia_activity_log_detail_month", "url_host = 'activity.tuia.cn' and tenter='SOW' and url_path in ('/index/activity','/newactivity/index','/index/rid','/activity/index','/mainmeet/index','/actcenter/index','/direct/index','/game/index')", "加密手机号接入pv(旧逻辑)"),

    //活动访问pv
    ACTIVITY_REQUEST_PV("activityRequestPV", "count(1)", "tuia_activity_log_detail_month", "url_host = 'activity.tuia.cn' and url_path in ('/index/activity','/newactivity/index','/index/rid','/activity/index','/mainmeet/index','/actcenter/index','/direct/index','/game/index')", "活动访问pv"),

    //活动访问uv（根据rid去重）
    ACTIVITY_REQUEST_RID_UV("activityRequestRidUV", "approx_count_distinct(rid)", "tuia_activity_log_detail_month", "url_host = 'activity.tuia.cn' and url_path in ('/index/activity','/newactivity/index','/index/rid','/activity/index','/mainmeet/index','/actcenter/index','/direct/index','/game/index')", "活动访问uv（根据rid去重）"),

    //活动访问uv（根据cid去重）
    ACTIVITY_REQUEST_CID_UV("activityRequestCidUV", "approx_count_distinct(consumer_id)", "tuia_activity_log_detail_month", "url_host = 'activity.tuia.cn' and url_path in ('/index/activity','/newactivity/index','/index/rid','/activity/index','/mainmeet/index','/actcenter/index','/direct/index','/game/index')", "活动访问uv（根据cid去重）"),

    //活动参与pv
    ACTIVITY_JOIN_PV("activityJoinPV", "count(1)", "tuia_activity_log_detail_month", "url_host = 'activity.tuia.cn' and url_path in ('/activity/dojoin')", "活动参与pv"),

    //活动参与uv（根据rid去重）
    ACTIVITY_JOIN_RID_UV("activityJoinRidUV", "approx_count_distinct(rid)", "tuia_activity_log_detail_month", "url_host = 'activity.tuia.cn' and url_path in ('/activity/dojoin')", "活动参与uv（根据rid去重）"),

    //活动参与uv（根据cid去重）
    ACTIVITY_JOIN_CID_UV("activityJoinCidUV", "approx_count_distinct(consumer_id)", "tuia_activity_log_detail_month", "url_host = 'activity.tuia.cn' and url_path in ('/activity/dojoin')", "活动参与uv（根据cid去重）"),

    //活动首屏加载pv
    ACTIVITY_FIRST_LOAD_PV("activityFirstLoadPV", "count(1)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 180", "活动首屏加载pv"),

    //活动首屏加载uv（根据rid去重）
    ACTIVITY_FIRST_LOAD_RID_UV("activityFirstLoadRidUV", "approx_count_distinct(rid)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 180", "活动首屏加载uv（根据rid去重）"),

    //活动首屏加载总时长（单位：毫秒）
    ACTIVITY_FIRST_LOAD_TIME("activityFirstLoadTime", "sum(fmp)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 180", "活动首屏加载总时长（单位：毫秒）"),

    //活动加载完成pv
    ACTIVITY_FINISH_LOAD_PV("activityFinishLoadPV", "count(1)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 181", "活动加载完成PV"),

    //活动加载完成uv（根据rid去重）
    ACTIVITY_FINISH_LOAD_RID_UV("activityFinishLoadRidUV", "approx_count_distinct(rid)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 181", "活动加载完成uv（根据rid去重）"),

    //活动加载完成总时长（单位：毫秒）
    ACTIVITY_FINISH_LOAD_TIME("activityFinishLoadTime", "sum(load_time)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 181", "活动加载完成总时长（单位：毫秒）"),

    //活动1s内加载完成PV
    ACTIVITY_1S_LOAD_PV("activity1sLoadPV", "count(case when load_time <= 1000 then 1 else null end)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 181", "活动1s内加载完成PV"),

    //活动1s内加载完成uv（根据rid去重）
    ACTIVITY_1S_LOAD_RID_UV("activity1sLoadRidUV", "approx_count_distinct(case when load_time <= 1000 then rid else null end)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 181", "活动1s内加载完成uv（根据rid去重）"),

    //活动2s内加载完成PV
    ACTIVITY_2S_LOAD_PV("activity2sLoadPV", "count(case when load_time <= 2000 then 1 else null end)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 181", "活动2s内加载完成PV"),

    //活动2s内加载完成uv（根据rid去重）
    ACTIVITY_2S_LOAD_RID_UV("activity2sLoadRidUV", "approx_count_distinct(case when load_time <= 2000 then rid else null end)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 181", "活动2s内加载完成uv（根据rid去重）"),

    //活动3s内加载完成PV
    ACTIVITY_3S_LOAD_PV("activity3sLoadPV", "count(case when load_time <= 3000 then 1 else null end)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 181", "活动3s内加载完成PV"),

    //活动3s内加载完成uv（根据rid去重）
    ACTIVITY_3S_LOAD_RID_UV("activity3sLoadRidUV", "approx_count_distinct(case when load_time <= 3000 then rid else null end)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 181", "活动3s内加载完成uv（根据rid去重）"),

    //活动曝光pv
    ACTIVITY_EXPOSE_PV("activityExposePV", "count(1)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 182", "活动曝光pv"),

    //活动曝光uv（根据rid去重）
    ACTIVITY_EXPOSE_RID_UV("activityExposeRidUV", "approx_count_distinct(rid)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 182", "活动曝光uv（根据rid去重）"),

    //活动引导页曝光pv
    ACTIVITY_GUIDE_EXPOSE_PV("activityGuideExposePV", "count(1)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 183", "活动引导页曝光pv"),

    //活动引导页曝光uv（根据rid去重）
    ACTIVITY_GUIDE_EXPOSE_RID_UV("activityGuideExposeRidUV", "approx_count_distinct(rid)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 183", "活动引导页曝光uv（根据rid去重）"),

    //活动引导页点击pv
    ACTIVITY_GUIDE_CLICK_PV("activityGuideClickPV", "count(1)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 184", "活动引导页点击pv"),

    //活动引导页点击uv（根据rid去重）
    ACTIVITY_GUIDE_CLICK_RID_UV("activityGuideClickRidUV", "approx_count_distinct(rid)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 184", "活动引导页点击uv（根据rid去重）"),

    //券请求pv
    COUPON_REQUEST_PV("couponRequestPV", "count(1)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 23", "券请求pv"),

    //券请求uv（根据tuia_id去重）
    COUPON_REQUEST_UV("couponRequestUV", "approx_count_distinct(tuia_id)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 23", "券请求uv（根据tuia_id去重）"),

    //发券量pv
    LAUNCH_COUPON_PV("launchCouponPV", "count(1)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 20", "发券量pv"),

    //发券量uv（根据tuia_id去重）
    LAUNCH_COUPON_UV("launchCouponUV", "approx_count_distinct(tuia_id)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 20", "发券量uv（根据tuia_id去重）"),

    //付费券-发券量pv
    LAUNCH_PAY_COUPON_PV("launchPayCouponPV", "count(case when is_free = 0 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 20", "付费券-发券量pv"),

    //付费券-发券量uv（根据tuia_id去重）
    LAUNCH_PAY_COUPON_UV("launchPayCouponUV", "approx_count_distinct(case when is_free = 0 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 20", "付费券-发券量uv（根据tuia_id去重）"),

    //免费券-发券量pv
    LAUNCH_FREE_COUPON_PV("launchFreeCouponPV", "count(case when is_free = 1 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 20", "免费券-发券量pv"),

    //免费券-发券量uv（根据tuia_id去重）
    LAUNCH_FREE_COUPON_UV("launchFreeCouponUV", "approx_count_distinct(case when is_free = 1 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 20", "免费券-发券量uv（根据tuia_id去重）"),

    //作弊-发券量pv
    LAUNCH_RISK_COUPON_PV("launchRiskCouponPV", "count(case when risk_type in (1, 2) then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 20", "作弊-发券量pv"),

    //作弊-发券量uv（根据tuia_id去重）
    LAUNCH_RISK_COUPON_UV("launchRiskCouponUV", "approx_count_distinct(case when risk_type in (1, 2) then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 20", "作弊-发券量uv（根据tuia_id去重）"),

    //券曝光pv
    COUPON_EXPOSURE_PV("couponExposurePV", "count(1)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 22", "券曝光pv"),

    //券曝光uv（根据tuia_id去重）
    COUPON_EXPOSURE_UV("couponExposureUV", "approx_count_distinct(tuia_id)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 22", "券曝光uv（根据tuia_id去重）"),

    //券普通点击pv
    COUPON_CLICK_PV("couponClickPV", "count(1)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 21", "券普通点击pv"),

    //券普通点击uv（根据tuia_id去重）
    COUPON_CLICK_UV("couponClickUV", "approx_count_distinct(tuia_id)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 21", "券普通点击uv（根据tuia_id去重）"),

    //券计费点击pv
    COUPON_EFFECT_CLICK_PV("couponEffectClickPV", "count(1)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 25", "券计费点击pv"),

    //券计费点击pv(cpc计费)
    CPC_COUPON_EFFECT_CLICK_PV("cpcCouponEffectClickPV", "count(case when charge_type = 'CPC' then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 25", "券计费点击pv(cpc计费)"),

    //券计费点击uv（根据tuia_id去重）
    COUPON_EFFECT_CLICK_UV("couponEffectClickUV", "approx_count_distinct(tuia_id)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 25", "券计费点击uv（根据tuia_id去重）"),

    //广告消耗（单位：分）
    CONSUME("consume", "sum(fee)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 25", "广告消耗（单位：分）"),

    //平台消耗(利润扣量后的消耗)
    PLATFORM_CONSUME("platformConsume", "sum(platform_fee)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 25", "平台消耗(利润扣量后的消耗)"),

    //cpc广告消耗（单位：分）
    CPC_CONSUME("cpcConsume", "sum(case when charge_type = 'CPC' then fee else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 25", "cpc广告消耗（单位：分）"),

    //落地页曝光pv
    LP_EXPOSE_PV("lpExposePV", "count(1)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 7", "落地页曝光pv"),

    //落地页曝光uv（根据tuia_id去重）
    LP_EXPOSE_UV("lpExposeUV", "approx_count_distinct(tuia_id)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 7", "落地页曝光uv（根据tuia_id去重）"),

    //落地页转化pv
    LP_CLICK_PV("lpClickPV", "count(1)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 8", "落地页转化pv"),

    //落地页转化uv（根据tuia_id去重）
    LP_CLICK_UV("lpClickUV", "approx_count_distinct(tuia_id)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 8", "落地页转化uv（根据tuia_id去重）"),

    //落地页转化消耗（前端转化消耗）
    LP_CLICK_CONSUME("lpClickConsume", "sum(case when charge_type = 'CPA' and target_effect_type = 0 then a_fee else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 8", "落地页转化消耗（前端转化消耗）"),

    //落地页目标转化pv（前端目标转化）
    LP_TARGET_EFFECT_PV("lpTargetEffectPV", "count(case when charge_type = 'CPA' and target_effect_type = 0 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 8", "落地页目标转化pv（前端目标转化）"),

    //落地页目标转化uv（前端目标转化，根据tuia_id去重）
    LP_TARGET_EFFECT_UV("lpTargetEffectUV", "approx_count_distinct(case when charge_type = 'CPA' and target_effect_type = 0 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 8", "落地页目标转化uv（前端目标转化，根据tuia_id去重）"),

    //后端转化消耗
    BACKEND_EFFECT_CONSUME("backendEffectConsume", "sum(case when charge_type = 'CPA' and target_effect_type = backend_effect_type then a_fee else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化消耗"),

    //理论消耗（单位：分）：cpc消耗 + 前端转化消耗 + 后端转化消耗
    THEORY_CONSUME("theoryConsume", "sum(case when inner_type = 25 and charge_type = 'CPC' then fee when inner_type = 8 and charge_type = 'CPA' and target_effect_type = 0 then a_fee when inner_type = 61 and charge_type = 'CPA' and target_effect_type = backend_effect_type then a_fee else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type in (25,8,61)", "理论消耗（单位：分）：cpc消耗 + 前端转化消耗 + 后端转化消耗"),

    //后端目标转化pv
    BACKEND_TARGET_EFFECT_PV("backendTargetEffectPV", "count(case when charge_type = 'CPA' and target_effect_type = backend_effect_type then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端目标转化pv"),

    //后端目标转化uv（根据tuia_id去重）
    BACKEND_TARGET_EFFECT_UV("backendTargetEffectUV", "approx_count_distinct(case when charge_type = 'CPA' and target_effect_type = backend_effect_type then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端目标转化uv（根据tuia_id去重）"),

    //目标转化pv：前端目标转化pv + 后端目标转化pv
    TARGET_EFFECT_PV("targetEffectPV", "count(case when inner_type = 8 and charge_type = 'CPA' and target_effect_type = 0 then 1 when inner_type = 61 and charge_type = 'CPA' and target_effect_type = backend_effect_type then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type in (8,61)", "目标转化pv：前端目标转化pv + 后端目标转化pv"),

    //目标转化uv（根据tuia_id去重）：前端目标转化uv + 后端目标转化uv
    TARGET_EFFECT_UV("targetEffectUV", "approx_count_distinct(case when inner_type = 8 and charge_type = 'CPA' and target_effect_type = 0 then tuia_id when inner_type = 61 and charge_type = 'CPA' and target_effect_type = backend_effect_type then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type in (8,61)", "目标转化uv（根据tuia_id去重）：前端目标转化uv + 后端目标转化uv"),

    //后端转化类型-安装pv
    INSTALL_PV("installPV", "count(case when backend_effect_type = 1 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-安装pv"),

    //后端转化类型-安装uv（根据tuia_id去重）
    INSTALL_UV("installUV", "approx_count_distinct(case when backend_effect_type = 1 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-安装uv（根据tuia_id去重）"),

    //后端转化类型-启动pv
    START_PV("startPV", "count(case when backend_effect_type = 2 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-启动pv"),

    //后端转化类型-启动uv（根据tuia_id去重）
    START_UV("startUV", "approx_count_distinct(case when backend_effect_type = 2 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-启动uv（根据tuia_id去重）"),

    //后端转化类型-注册pv
    REGISTE_PV("registePV", "count(case when backend_effect_type = 3 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-注册pv"),

    //后端转化类型-注册uv（根据tuia_id去重）
    REGISTE_UV("registeUV", "approx_count_distinct(case when backend_effect_type = 3 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-注册uv（根据tuia_id去重）"),

    //后端转化类型-激活pv
    ACTIVATE_PV("activatePV", "count(case when backend_effect_type = 4 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-激活pv"),

    //后端转化类型-激活uv（根据tuia_id去重）
    ACTIVATE_UV("activateUV", "approx_count_distinct(case when backend_effect_type = 4 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-激活uv（根据tuia_id去重）"),

    //后端转化类型-登录pv
    LOGIN_PV("loginPV", "count(case when backend_effect_type = 5 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-登录pv"),

    //后端转化类型-登录uv（根据tuia_id去重）
    LOGIN_UV("loginUV", "approx_count_distinct(case when backend_effect_type = 5 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-登录uv（根据tuia_id去重）"),

    //后端转化类型-付费pv
    PAY_PV("payPV", "count(case when backend_effect_type = 6 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-付费pv"),

    //后端转化类型-付费uv（根据tuia_id去重）
    PAY_UV("payUV", "approx_count_distinct(case when backend_effect_type = 6 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-付费uv（根据tuia_id去重）"),

    //后端转化类型-付费金额（单位分）
    PAY_CONSUME("payConsume", "sum(case when backend_effect_type = 6 then payment_amount * 100 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-付费金额（单位元，保留两位小数）"),

    //后端转化类型-进件pv
    ENTRY_PV("entryPV", "count(case when backend_effect_type = 7 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-进件pv"),

    //后端转化类型-进件uv（根据tuia_id去重）
    ENTRY_UV("entryUV", "approx_count_distinct(case when backend_effect_type = 7 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-进件uv（根据tuia_id去重）"),

    //后端转化类型-完件pv
    FINISH_PV("finishPV", "count(case when backend_effect_type = 8 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-完件pv"),

    //后端转化类型-完件uv（根据tuia_id去重）
    FINISH_UV("finishUV", "approx_count_distinct(case when backend_effect_type = 8 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-完件uv（根据tuia_id去重）"),

    //后端转化类型-签收pv
    SIGN_PV("signPV", "count(case when backend_effect_type = 9 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-签收pv"),

    //后端转化类型-签收uv（根据tuia_id去重）
    SIGN_UV("signUV", "approx_count_distinct(case when backend_effect_type = 9 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-签收uv（根据tuia_id去重）"),

    //后端转化类型-拒签pv
    DENY_PV("denyPV", "count(case when backend_effect_type = 10 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-拒签pv"),

    //后端转化类型-拒签uv（根据tuia_id去重）
    DENY_UV("denyUV", "approx_count_distinct(case when backend_effect_type = 10 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-拒签uv（根据tuia_id去重）"),

    //后端转化类型-出单pv
    ORDER_PV("orderPV", "count(case when backend_effect_type = 11 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-出单pv"),

    //后端转化类型-出单uv（根据tuia_id去重）
    ORDER_UV("orderUV", "approx_count_distinct(case when backend_effect_type = 11 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-出单uv（根据tuia_id去重）"),

    //后端转化类型-订单取消pv
    CANCEL_PV("cancelPV", "count(case when backend_effect_type = 12 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-订单取消pv"),

    //后端转化类型-订单取消uv（根据tuia_id去重）
    CANCEL_UV("cancelUV", "approx_count_distinct(case when backend_effect_type = 12 then tuia_id else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-订单取消uv（根据tuia_id去重）"),

    //后端转化类型-唤起pv
    WAKE_PV("wakePV", "count(case when backend_effect_type = 20 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-唤起pv"),

    //后端转化类型-首次唤起pv
    FIRST_WAKE_PV("firstWakePV", "count(case when backend_effect_type = 21 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-首次唤起pv"),

    //后端转化类型-次留pv
    MORROW_RETENTION_PV("morrowRetentionPV", "count(case when backend_effect_type = 22 then 1 else null end)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 61", "后端转化类型-次留pv"),

    //落地页请求uv（根据tuia_id去重）
    LP_REQUEST_UV("lpRequestUV", "approx_count_distinct(tuia_id)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 185", "落地页请求uv（根据tuia_id去重）"),

    //落地页加载完成uv（根据tuia_id去重）
    LP_FINISH_LOAD_UV("lpFinishLoadUV", "approx_count_distinct(tuia_id)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 186", "落地页加载完成uv（根据tuia_id去重）"),

    //落地页加载完成pv
    LP_FINISH_LOAD_PV("lpFinishLoadPV", "count(1)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 186", "落地页加载完成pv"),

    //落地页加载完成总时长（单位：毫秒）
    LP_FINISH_LOAD_TIME("lpFinishLoadTime", "sum(load_time)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 186", "落地页加载完成总时长（单位：毫秒）"),

    //落地页1s内加载完成PV
    LP_1S_LOAD_PV("lp1sLoadPV", "count(case when load_time <= 1000 then 1 else null end)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 186", "落地页1s内加载完成PV"),

    //落地页1s内加载完成uv（根据tuia_id去重）
    LP_1S_LOAD_UV("lp1sLoadUV", "approx_count_distinct(case when load_time <= 1000 then tuia_id else null end)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 186", "落地页1s内加载完成uv（根据tuia_id去重）"),

    //落地页2s内加载完成PV
    LP_2S_LOAD_PV("lp2sLoadPV", "count(case when load_time <= 2000 then 1 else null end)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 186", "落地页2s内加载完成PV"),

    //落地页2s内加载完成uv（根据tuia_id去重）
    LP_2S_LOAD_UV("lp2sLoadUV", "approx_count_distinct(case when load_time <= 2000 then tuia_id else null end)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 186", "落地页2s内加载完成uv（根据tuia_id去重）"),

    //落地页3s内加载完成PV
    LP_3S_LOAD_PV("lp3sLoadPV", "count(case when load_time <= 3000 then 1 else null end)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 186", "落地页3s内加载完成PV"),

    //落地页3s内加载完成uv（根据tuia_id去重）
    LP_3S_LOAD_UV("lp3sLoadUV", "approx_count_distinct(case when load_time <= 3000 then tuia_id else null end)", "tuia_ext01_log_detail_month", "inner_group = 1 and inner_type = 186", "落地页3s内加载完成uv（根据tuia_id去重）"),

    //ADX消耗 单位分
    ADX_CONSUME("adxConsume", "sum(case when inner_type = 191 and bill_type = 1 then fee when inner_type = 192 and bill_type = 0 then fee else 0 end) / 10000000", "adx_log_detail_month", "inner_group = 1 and inner_type in (191,192)", "adx消耗 单位分"),

    //ADX竞价请求pv
    ADX_BID_REQUEST_PV("adxBidRequestPV", "sum(adx_bid_request_pv) * 1000", "adx_bid_request_minute", "inner_group = 1 and inner_type = 3", "ADX竞价请求pv"),

    //ADX底价汇总
    ADX_FLOOR_PRICE("adxFloorPrice", "sum(adx_floor_price)", "adx_bid_request_minute", "inner_group = 1 and inner_type = 3", "ADX底价汇总"),

    //ADX竞价返回pv
    ADX_BID_RETURN_PV("adxBidReturnPV", "count(1) * 1000", "adx_log_detail_month", "inner_group = 1 and inner_type = 194", "ADX竞价返回pv"),

    //ADX竞价返回出价汇总
    ADX_BID_RETURN_PRICE("adxBidReturnPrice", "sum(fee)", "adx_log_detail_month", "inner_group = 1 and inner_type = 194", "ADX竞价返回出价汇总"),

    //ADX竞价成功pv
    ADX_BID_SUCCESS_PV("adxBidSuccessPV", "count(1)", "adx_log_detail_month", "inner_group = 1 and inner_type = 193", "ADX竞价成功pv"),

    //DSP请求pv
    DSP_REQUEST_PV("dspRequestPV", "sum(dsp_request_pv) * 100", "adx_dsp_request_minute", "inner_group = 1 and inner_type = 197", "DSP请求pv"),

    //DSP返回pv
    DSP_RETURN_PV("dspReturnPV", "count(1) * 100", "adx_log_detail_month", "inner_group = 1 and inner_type = 198", "DSP返回pv"),

    //DSP返回出价汇总
    DSP_RETURN_PRICE("dspReturnPrice", "sum(dsp_return_price)", "adx_log_detail_month", "inner_group = 1 and inner_type = 198", "DSP返回出价汇总"),

    //ADX曝光pv
    ADX_EXPOSURE_PV("adxExposurePV", "count(1)", "adx_log_detail_month", "inner_group = 1 and inner_type = 191", "ADX曝光pv"),

    //ADX点击pv
    ADX_CLICK_PV("adxClickPV", "count(1)", "adx_log_detail_month", "inner_group = 1 and inner_type = 192", "ADX点击pv"),

    //adx唤起成功pv
    ADX_WAKE_SUCCESS_PV("adxWakeSuccessPV", "count(case when wake_up_status = 0 then 1 else null end)", "adx_log_detail_month", "inner_group = 1 and inner_type = 196", "adx唤起成功pv"),

    //adx唤起失败pv
    ADX_WAKE_FAILURE_PV("adxWakeFailurePV", "count(case when wake_up_status = 1 then 1 else null end)", "adx_log_detail_month", "inner_group = 1 and inner_type = 196", "adx唤起失败pv"),

    //转化上报pv
    EFFECT_REPORT_PV("effectReportPV", "count(1)", "tuia_ext02_log_detail_month", "inner_group = 1 and inner_type = 69", "转化上报pv"),

    //在线广告主个数
    ACCOUNT_NUM("accountNum", "count(distinct account_id)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 20", "在线广告主个数"),

    //在线广告计划个数
    ADVERT_NUM("advertNum", "count(distinct advert_id)", "tuia_advert_log_detail_month", "inner_group = 1 and inner_type = 20", "在线广告计划个数"),







    ;


    //结果数据对应的别名
    private final String resultFieldName;

    //指标sql代码段
    private final String metricSql;

    //指标对应的 hologres 表
    private final String tableName;

    //指标特定的查询条件
    private final String condition;

    //指标解释说明
    private final String desc;

    //枚举列表
    public static final List<String> enumList = new ArrayList<>();

    TuiaMetricEnum(String resultFieldName, String metricSql, String tableName, String condition, String desc) {
        this.resultFieldName = resultFieldName;
        this.metricSql = metricSql;
        this.tableName = tableName;
        this.condition = condition;
        this.desc = desc;
    }

    public String getResultFieldName() {
        return resultFieldName;
    }

    public String getMetricSql() {
        return metricSql;
    }

    public String getTableName() {
        return tableName;
    }

    public String getCondition() {
        return condition;
    }

    public String getDesc() {
        return desc;
    }

    static {
        TuiaMetricEnum[] values = TuiaMetricEnum.values();
        for (TuiaMetricEnum value : values) {
            enumList.add(value.toString());
        }
    }

}
