package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum AdxBidRequestLogSumMinuteEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    DATA_MD5("data_md5", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    INNER_GROUP("inner_group", "公司业务分类，大类"),

    INNER_TYPE("inner_type", "日志分类，小类"),

    APP_ID("app_id", "媒体id"),

    GROUP_ID("group_id", "ADX推广组id"),

    RESOURCE_ID("resource_id", "ADX资源位id"),

    IDEA_ID("idea_id", "ADX创意id"),

    //ADX创意素材id
    IDEA_MATERIAL_ID("idea_material_id",  "ADX创意素材id"),

    ADX_LOG_TYPE("adx_log_type", "ADX日志类型  0=曝光，1=点击，2=竞价成功，3=参与竞价");

    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    AdxBidRequestLogSumMinuteEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
