package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata_offline;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum AdvertFilterReasonOfflineEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    DATA_MD5("data_md5", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    INNER_GROUP("inner_group", "公司业务分类，大类"),

    INNER_TYPE("inner_type", "日志分类，小类"),

    APP_ID("app_id", "媒体id"),

    SLOT_ID("slot_id", "广告位id"),

    ADVERT_ID("advert_id", "广告id"),

    ORIENTATION_ID("orientation_id", "广告定向配置id 0为默认配置"),

    LAUNCH_REQUEST_TYPE("launch_request_type", "券请求场景"),

    FILTER_TYPE("filter_type", "过滤原因"),

    ACTIVITY_ID("activity_id", "活动id"),

    ;

    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    AdvertFilterReasonOfflineEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
