/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHttpResponse(String url, StringEntity body, int timeout) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpUriRequest httpUriRequest = HttpClientUtil.getHttpUriRequest(url, (HttpEntity)body, timeout);
            CloseableHttpResponse response = httpClient.execute(httpUriRequest);
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            log.error("getHttpResponse error,", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHttpResponse(String url, JSONObject head, HttpEntity body, int timeout) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpUriRequest httpUriRequest = HttpClientUtil.getHttpUriRequest(url, body, timeout);
            if (head != null && head.size() > 0) {
                for (String key : head.keySet()) {
                    httpUriRequest.addHeader(key, head.getString(key));
                }
            }
            CloseableHttpResponse response = httpClient.execute(httpUriRequest);
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            log.error("getHttpResponse error,", (Throwable)e);
            return null;
        }
    }

    private static HttpUriRequest getHttpUriRequest(String url, HttpEntity body, int timeout) {
        if (body == null) {
            return HttpClientUtil.httpGet(url, timeout);
        }
        return HttpClientUtil.httpPost(url, body, timeout);
    }

    private static HttpGet httpGet(String url, int timeout) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpGet.setConfig(HttpClientUtil.getRequestConfig(timeout));
        return httpGet;
    }

    private static HttpPost httpPost(String url, HttpEntity entity, int timeout) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpPost.setEntity(entity);
        httpPost.setConfig(HttpClientUtil.getRequestConfig(timeout));
        return httpPost;
    }

    private static RequestConfig getRequestConfig(int timeout) {
        return RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).build();
    }
}

