package cn.com.duiba.bigdata.common.biz.dto;

import cn.com.duiba.bigdata.common.biz.enums.OperatorsEnum;
import lombok.Data;

import java.io.Serializable;

@Data
public class KeyValueDto implements Serializable {

    private static final long serialVersionUID = 1027024424679438807L;

    //推啊业务线（维度列取值：TuiaDimensionEnum 指标列取值：TuiaMetricEnum、TuiaCalculateMetricEnum、TuiaCombineMetricEnum）
    private Object key;

    //多个值用list, 如果symbol = "IS_NULL" 或者 symbol = "IS_NOT_NULL"，value 不需要赋值
    private Object value;

    //操作符，默认是in，取值参考 OperatorsEnum
    private String symbol = OperatorsEnum.IN.toString();

    public KeyValueDto(Object key, Object value) {
        this.key = key;
        this.value = value;
    }

    public KeyValueDto(Object key, Object value, String symbol) {
        this.key = key;
        this.value = value;
        this.symbol = symbol;
    }

}
