package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaInnerLogDetailDayEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    INNER_GROUP("inner_group", "公司业务分类，大类"),

    INNER_TYPE("inner_type", "日志分类，小类"),

    CONSUMER_ID("consumer_id", "用户id"),

    APP_ID("app_id", "媒体id"),

    SDK_VERSION("sdk_version",  "sdk版本"),

    SDK_REPORT_TYPE("sdk_report_type", "sdk上报类型 1-SDK启动上报，2-SDK崩溃上报"),

    SDK_SOURCE("sdk_source", "1-创新SDK  其他-大盘SDK"),

    PATCH_TYPE("patch_type", "补丁状态 1-补丁下载 2-补丁生效"),

    PATCH_VERSION("patch_version","补丁版本"),

    DOWNLOAD_STATUS("download_status", "SDK下载状态 1-SDK下载成功 2-SDK下载失败"),

    UA("ua",  "操作系统"),

    CRASH_TYPE("crash_type",  "奔溃类型"),

    PLUGIN_PUT_TYPE("plugin_put_type", "插件投放类型 1-分流算法3.0，2-配置大盘默认，3-配置活动，4-配置广告位定制，5-配置算法，6-盘古，7-分流算法2.0"),










    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DuibaInnerLogDetailDayEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
