package cn.com.duiba.bigdata.common.biz.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xugf 2023-11-24
 * 推啊业务线-hologres查询结果封装对象
 */
@Data
public class TuiaResultDto implements Serializable {
    private static final long serialVersionUID = -902574723032482837L;

    //----------------------------------维度字段-----------------------------------------------------------------//
    //统计时间段 格式(yyyy-MM-dd HH:mm:ss)
    private String timeSegment;

    //媒体id
    private Long appId;

    //广告位id
    private Long slotId;

    //活动id
    private Long activityId;

    //广告id
    private Long advertId;

    //广告定向配置id
    private Long orientationId;

    //实验计划id
    private Long abtestPlanId;

    //实验分组id
    private Long abtestGroupId;

    //资源位类型：1-直投；2-浮标；3-推荐弹层；4-第一次返回拦截；5-谢谢参与推荐弹层；6-下拉推荐位；7-第二次返回拦截；9-第三次返回拦截；10-直投广告；11-adx直投广告
    private Integer resourceType;

    //活动流量来源类型：1-微信,2-QQ,3-支付宝,4-其他,5-微信小程序,6-支付宝小程序,7-微信快应用
    private Integer appFlowType;

    //广告券流量来源类型 1-微信,2-QQ,3-支付宝,4-其他,5-微信小程序,6-支付宝小程序,7-微信快应用
    private Integer advertFlowType;

    //广告位活动投放类型：1-插件工具、2-活动工具、3-直投页、4-展示广告，5-浮标 6-激励等（activityType）
    private Integer slotActivityType;

    //广告主ID
    private Long accountId;

    //广告素材id
    private Long materialId;

    //广告位素材id
    private Long slotMaterialId;

    //ADX资源位id
    private Long resourceId;

    //ADX推广组id
    private Long groupId;

    //ADX创意id
    private Long ideaId;

    //券弹层ID
    private Long couponLayerId;

    //券弹层类型(0:活动;1:积木)
    private Integer couponLayerType;

    //落地页来源 0-广告推广链接；1-AB测试链接；2-新媒体测试链接；3-定向配置链接；4-特殊广告链接；5-DSP平台adx推广链接；6-广告测试素材绑定落地页
    private Integer advertPromoteSource;

    //操作系统类型 android/ios
    private String osType;

    //网络运营商类型 1-移动2-联通3-电信4-未知
    private Integer isp;

    //手机品牌
    private String brandName;

    //广告发券次序
    private Integer launchTimes;

    //活动曝光来源 0-广告位正常访问；1-弹层关闭后 (参与结果弹层关闭后)；2-落地页返回 (券落地页返回)
    private Integer exposureSource;

    //活动参与次序减1，用于关联全链路数据
    private Integer trackJoinTimes;

    //活动参与前置引导类型 1-积木动效 (积木动效弹层)；2-现金激励 (现金激励奖励弹层)；3-快应用点击组件
    private Integer bootType;

    //活动参与触发类型 0-点击；1-自动参与 (自动玩一次,如大转盘自动开始转)；2-自动出券 (自动调dojoin接口并出券,玩法没有参与动效)
    private Integer triggerType;

    //是否回流数据（不为空表示回流数据）
    private String autoFlowBack;

    //ADX创意素材Id
    private Long ideaMaterialId;

    //外部联盟媒体ID
    private String extAppId;

    //外部联盟广告位ID
    private String extSlotId;

    //媒体包名
    private String packageName;

    //dsp任务ID
    private String dspTaskId;

    //业务类型(1:adx业务)
    private Integer businessType;

    //城市编码(直辖市:2位编码 其它城市:4位编码)
    private Integer cityId;

    //城市名称
    private String cityName;

    //省份编码(2位)
    private Integer provinceId;

    //省份名称
    private String provinceName;

    //广告目标转化类型
    private Integer targetEffectType;

    //计费类型：CPA、CPC、ECMP
    private String chargeType;

    //投放模式：0-人工包；1-稳定投放；2-抢量优先（中）；3-抢量优先（高）；4-人工定向；5-成本优先
    private Integer putTargetType;

    //深度优化类型：0-落地页转化；1-安装；2-启动；3-注册；4-激活；5-登录；6-付费；7-进件；8-完件；9-签收；10-留存
    private Integer depthTargetEffectType;

    //媒体开户账号id
    private String openAccountId;

    //外部广告id
    private String extAdvertId;

    //外部广告组id
    private String extAdvertGroupId;

    //外部创意id
    private String extIdeaId;

    //投放场景：1-点券直接上报；2-转化概率多o；3-点券概率多o；4-转化直接上报
    private Integer putScene;

    //流量是否绑券 (0:否 1:是)
    private Integer customizeCoupon;

    //活动域名
    private String activityHost;

    //落地页域名
    private String landpageHost;

    //dp链接ID
    private Integer dpLinkId;

    //dp链接库ID
    private Integer dpLinkLibraryId;

    //货到模型分层
    private Integer huodaoDcvrLevel;

    //货到私有模型分层
    private Integer pHuodaoDcvrLevel;

    //运营商模型分层
    private Integer ispDcvrLevel;

    //会籍卡模型分层
    private Integer huijikaDcvrLevel;

    //视频模型分层
    private Integer videoDcvrLevel;

    //应用分发模型分层
    private Integer appDistDcvrLevel;

    //人群分层是否应用 (0:否 1:是)
    private Integer useDcvrLevel;

    //媒体包名
    private String appPackage;

    //蚂蚁支付分（-1：未找到；0：[0, 5)；5：[5, 10)；10：[10, 15)；15：[15, 20)；20：[20, 25)；25：[25, 30)；30：[30, 40)；40：[40, 50)；50：[50, 60)；60：[60, 70)；70：[70, 80)；80：[80, 90)；90：[90,100]）
    private Integer antScoreRange;

    //货到助攻模型类型（1-行业，2-私有）
    private Integer hdDcvrType;

    //客诉会籍卡dcvr分层
    private Integer cpHuijikaDcvrLevel;

    //手机号归属省份名称
    private String phoneProvinceName;

    //手机号归属城市名称
    private String phoneCityName;

    //货到预估签收率分层
    private Integer hdSignRateLevel;

    //是否开启签收调价（0：没有开启调价 1：开启调价）
    private Integer hitSignRate;

    //网络类型（1：2G/3G/4G/5G 2：wifi 3：未知）
    private Integer netType;

    //竞价类型（0:互动，1:直投，2:外部dsp）
    //字段含义和创意维度表中的竞价类型一样，只是对空值进行了处理，把所有的空值调整成互动，方便接口直接使用，因为现有的接口不支持 "or" 的条件
    private Integer adxBidType;

    //百奇页面ID
    private Integer pageId;

    //----------------------------------维度字段-----------------------------------------------------------------//

    //--------------------------------字典表关联的属性字段（字段命名和数据库表中的字段保持一致）-------------------------//
    //-----媒体维度表--------//
    //媒体名称
    private String app_name;

    //媒体来源
    private Long app_source;

    //媒体性质 1-在线KA；2-潜力KA‘3-普通媒体
    private Integer app_level;

    //流量渠道标签id
    private String app_flow_channel_id;

    //流量渠道标签描述
    private String app_flow_channel_desc;

    //交易方式标签描述
    private String trade_type_desc;

    //程序化联盟媒体标签名称
    private String app_type_name;

    //媒体主运营
    private String main_media_operation_name;

    //媒体运营1
    private String media_one;

    //媒介
    private String meijie_manager_name;

    //一级标签描述
    private String app_first_tag_desc;

    //二级标签描述
    private String app_second_tag_desc;

    //媒体流量标签描述
    private String app_flow_tag_desc;

    //账号id
    private Long developer_id;
    //-----媒体维度表--------//

    //-----广告位维度表--------//
    //广告位名称
    private String slot_name;

    //广告位类型 0-插屏 1-横幅 2-信息流 3-banner 4-浮标 5-应用墙
    private Integer slot_type;

    //接入广告类型 0-互动广告 1-展示广告
    private Integer slot_access_type;

    //投放场景，1：插屏，2：banner/横幅，3：信息流，6：浮标，7：应用墙，8：开屏，9：自定义场景，10：原生插屏，11：icon
    private Integer scene_type;

    //上报策略 1-多O概率上报 2-单资源概率上报 3-直接上报 4-固定收益上报 5-固定收益-自定义上报
    private Integer strategy_id;

    //媒体链接对接方式标签：(api;活跃;防封;短链)
    private String link_docking_tags;

    //是否开启防封：(是；否)
    private String open_prevent_close;
    //-----广告位维度表--------//

    //-----广告维度表--------//
    //广告名称
    private String advert_name;

    //广告类型 1-互动广告、2-展示广告、3-激励广告
    private Integer advert_type;

    //广告主名称
    private String account_name;

    //所属代理商名称，如果本身为代理商则为空
    private String agent_name;

    //综合行业标签编码
    private Long trade_tag_id;

    //综合行业名称
    private String new_trade;

    //广告对应资源标签名称
    private String resoure_tag_name;

    //广告二级行业名称
    private String advert_second_trade_name;

    //AE姓名
    private String sso_ae_name;

    //销售姓名
    private String sell_name;
    //-----广告维度表--------//

    //-----广告配置维度表--------//
    //广告定向配置名称
    private String orientation_name;
    //-----广告配置维度表--------//

    //-----活动维度表--------//
    //活动名称
    private String activity_name;

    //活动皮肤ID
    private String skin_id;

    //活动皮肤名称
    private String skin_name;

    //皮肤类型
    private String skin_type;

    //皮肤模板类型
    private Integer template_type;

    //活动皮肤类型
    private String activity_template_name;
    //-----活动维度表--------//

    //-----广告位素材维度表--------//
    //广告位素材名称
    private String material_title;

    //素材图片类型 0:动图 1:静图 3:视频
    private String picture_type;

    //素材创建时间
    private String material_create_time;
    //-----广告位素材维度表--------//

    //-----adx推广组维度表--------//
    //推广组名称
    private String groupName;
    //-----adx推广组维度表--------//

    //-----adx资源位维度表--------//
    //资源位名称
    private String resourceName;
    //-----adx资源位维度表--------//

    //-----adx创意维度表--------//
    //创意名称
    private String ideaName;

    //dsp广告位id
    private String dspSlotId;

    //dsp平台id
    private Long dspId;

    //dsp平台名称
    private String dspName;
    //-----adx创意维度表--------//
    //--------------------------------字典表关联的属性字段（字段命名和数据库表中的字段保持一致）-------------------------//

    //----------------------------------基础指标字段-------------------------------------------------------------//
    //总记录数
    private Long countPV;

    //广告位访问pv
    private Long slotVisitPV;

    //广告位访问uv（根据rid去重）
    private Long slotVisitRidUV;

    //广告位访问uv（根据cid去重）
    private Long slotVisitCidUV;

    //广告位访问pv(旧逻辑)
    private Long slotAccessPV;

    //广告位访问uv（根据cid去重）(旧逻辑)
    private Long slotAccessUV;

    //广告位访问uv（根据ip去重）(旧逻辑)
    private Long slotAccessIpUV;

    //加密手机号接入pv(旧逻辑)
    private Long secretPhonePV;

    //活动访问pv
    private Long activityRequestPV;

    //活动访问uv（根据rid去重）
    private Long activityRequestRidUV;

    //活动访问uv（根据cid去重）
    private Long activityRequestCidUV;

    //活动参与pv
    private Long activityJoinPV;

    //活动参与uv（根据rid去重）
    private Long activityJoinRidUV;

    //活动参与uv（根据cid去重）
    private Long activityJoinCidUV;

    //活动首屏加载pv
    private Long activityFirstLoadPV;

    //活动首屏加载uv（根据rid去重）
    private Long activityFirstLoadRidUV;

    //活动首屏加载总时长（单位：毫秒）
    private Long activityFirstLoadTime;

    //活动加载完成pv
    private Long activityFinishLoadPV;

    //活动加载完成uv（根据rid去重）
    private Long activityFinishLoadRidUV;

    //活动加载完成总时长（单位：毫秒）
    private Long activityFinishLoadTime;

    //活动1s内加载完成PV
    private Long activity1sLoadPV;

    //活动1s内加载完成uv（根据rid去重）
    private Long activity1sLoadRidUV;

    //活动2s内加载完成PV
    private Long activity2sLoadPV;

    //活动2s内加载完成uv（根据rid去重）
    private Long activity2sLoadRidUV;

    //活动3s内加载完成PV
    private Long activity3sLoadPV;

    //活动3s内加载完成uv（根据rid去重）
    private Long activity3sLoadRidUV;

    //活动曝光pv
    private Long activityExposePV;

    //活动曝光uv（根据rid去重）
    private Long activityExposeRidUV;

    //活动引导页曝光pv
    private Long activityGuideExposePV;

    //活动引导页曝光uv（根据rid去重）
    private Long activityGuideExposeRidUV;

    //活动引导页点击pv
    private Long activityGuideClickPV;

    //活动引导页点击uv（根据rid去重）
    private Long activityGuideClickRidUV;

    //券请求pv
    private Long couponRequestPV;

    //券请求uv（根据tuia_id去重）
    private Long couponRequestUV;

    //携带手机号码的券请求uv（根据cid去重）
    private Long couponRequestPhoneUV;

    //发券量pv
    private Long launchCouponPV;

    //发券量uv（根据tuia_id去重）
    private Long launchCouponUV;

    //付费券-发券量pv
    private Long launchPayCouponPV;

    //付费券-发券量uv（根据tuia_id去重）
    private Long launchPayCouponUV;

    //免费券-发券量pv
    private Long launchFreeCouponPV;

    //免费券-发券量uv（根据tuia_id去重）
    private Long launchFreeCouponUV;

    //作弊-发券量pv
    private Long launchRiskCouponPV;

    //作弊-发券量uv（根据tuia_id去重）
    private Long launchRiskCouponUV;

    //券曝光pv
    private Long couponExposurePV;

    //券曝光pv（pre_ctr > 0）
    private Long preCouponExposurePV;

    //券曝光uv（根据tuia_id去重）
    private Long couponExposureUV;

    //券普通点击pv
    private Long couponClickPV;

    //券普通点击uv（根据tuia_id去重）
    private Long couponClickUV;

    //券计费点击pv
    private Long couponEffectClickPV;

    //券计费点击pv(cpc计费)
    private Long cpcCouponEffectClickPV;

    //券计费点击uv（根据tuia_id去重）
    private Long couponEffectClickUV;

    //券计费点击pv(pre_cvr > 0)
    private Long preCouponEffectClickPV;

    //广告消耗（单位：分）
    private Long consume;

    //平台消耗(利润扣量后的消耗)
    private Double platformConsume;

    //cpc广告消耗（单位：分）
    private Long cpcConsume;

    //落地页曝光pv
    private Long lpExposePV;

    //落地页曝光uv（根据tuia_id去重）
    private Long lpExposeUV;

    //落地页转化pv
    private Long lpClickPV;

    //落地页转化uv（根据tuia_id去重）
    private Long lpClickUV;

    //落地页转化消耗（前端转化消耗）
    private Long lpClickConsume;

    //落地页目标转化pv（前端目标转化）
    private Long lpTargetEffectPV;

    //落地页目标转化uv（前端目标转化，根据tuia_id去重）
    private Long lpTargetEffectUV;

    //后端转化消耗
    private Long backendEffectConsume;

    //理论消耗（单位：分）：cpc消耗 + 前端转化消耗 + 后端转化消耗
    private Long theoryConsume;

    //平台理论消耗：cpc平台消耗(利润扣量后的消耗) + CPA目标转化平台消耗(利润扣量后的消耗)
    private Double platformTheoryConsume;

    //后端目标转化pv
    private Long backendTargetEffectPV;

    //后端目标转化uv（根据tuia_id去重）
    private Long backendTargetEffectUV;

    //目标转化pv：前端目标转化pv + 后端目标转化pv
    private Long targetEffectPV;

    //目标转化uv（根据tuia_id去重）：前端目标转化uv + 后端目标转化uv
    private Long targetEffectUV;

    //后端转化类型-安装pv
    private Long installPV;

    //后端转化类型-安装uv（根据tuia_id去重）
    private Long installUV;

    //后端转化类型-安装pv(归因，以订单创建时间为准)
    private Long ascribeInstallPV;

    //后端转化类型-启动pv
    private Long startPV;

    //后端转化类型-启动uv（根据tuia_id去重）
    private Long startUV;

    //后端转化类型-启动pv(归因，以订单创建时间为准)
    private Long ascribeStartPV;

    //后端转化类型-注册pv
    private Long registePV;

    //后端转化类型-注册uv（根据tuia_id去重）
    private Long registeUV;

    //后端转化类型-注册pv(归因，以订单创建时间为准)
    private Long ascribeRegistePV;

    //后端转化类型-激活pv
    private Long activatePV;

    //后端转化类型-激活uv（根据tuia_id去重）
    private Long activateUV;

    //后端转化类型-激活pv(归因，以订单创建时间为准)
    private Long ascribeActivatePV;

    //后端转化类型-登录pv
    private Long loginPV;

    //后端转化类型-登录uv（根据tuia_id去重）
    private Long loginUV;

    //后端转化类型-登录pv(归因，以订单创建时间为准)
    private Long ascribeLoginPV;

    //后端转化类型-付费pv
    private Long payPV;

    //后端转化类型-付费uv（根据tuia_id去重）
    private Long payUV;

    //后端转化类型-付费金额（单位分）
    private Double payConsume;

    //后端转化类型-付费pv(归因，以订单创建时间为准)
    private Long ascribePayPV;

    //后端转化类型-进件pv
    private Long entryPV;

    //后端转化类型-进件uv（根据tuia_id去重）
    private Long entryUV;

    //后端转化类型-进件pv(归因，以订单创建时间为准)
    private Long ascribeEntryPV;

    //后端转化类型-完件pv
    private Long finishPV;

    //后端转化类型-完件uv（根据tuia_id去重）
    private Long finishUV;

    //后端转化类型-完件pv(归因，以订单创建时间为准)
    private Long ascribeFinishPV;

    //后端转化类型-签收pv
    private Long signPV;

    //后端转化类型-签收uv（根据tuia_id去重）
    private Long signUV;

    //后端转化类型-签收pv(归因，以订单创建时间为准)
    private Long ascribeSignPV;

    //后端转化类型-拒签pv
    private Long denyPV;

    //后端转化类型-注册拒签pv（先有注册，再有拒签）
    private Long registeDenyPV;

    //后端转化类型-拒签uv（根据tuia_id去重）
    private Long denyUV;

    //后端转化类型-注册拒签uv（根据tuia_id去重，先有注册，再有拒签）
    private Long registeDenyUV;

    //后端转化类型-拒签pv(归因，以订单创建时间为准)
    private Long ascribeDenyPV;

    //后端转化类型-注册拒签pv(归因，以订单创建时间为准，先有注册，再有拒签)
    private Long ascribeRegisteDenyPV;

    //后端转化类型-出单pv
    private Long orderPV;

    //后端转化类型-出单uv（根据tuia_id去重）
    private Long orderUV;

    //后端转化类型-出单pv(归因，以订单创建时间为准)
    private Long ascribeOrderPV;

    //后端转化类型-订单取消pv
    private Long cancelPV;

    //后端转化类型-订单取消uv（根据tuia_id去重）
    private Long cancelUV;

    //后端转化类型-订单取消pv(归因，以订单创建时间为准)
    private Long ascribeCancelPV;

    //后端转化类型-唤起pv
    private Long wakePV;

    //后端转化类型-唤起pv(归因，以订单创建时间为准)
    private Long ascribeWakePV;

    //后端转化类型-首次唤起pv
    private Long firstWakePV;

    //后端转化类型-首次唤起pv(归因，以订单创建时间为准)
    private Long ascribeFirstWakePV;

    //后端转化类型-次留pv
    private Long morrowRetentionPV;

    //后端转化类型-次留pv(归因，以订单创建时间为准)
    private Long ascribeMorrowRetentionPV;

    //后端转化类型-关键行为pv（全部付费回传）
    private Long keyActionPV;

    //后端转化类型-关键行为pv（全部付费回传，归因，以订单创建时间为准）
    private Long ascribeKeyActionPV;

    //落地页请求uv（根据tuia_id去重）
    private Long lpRequestUV;

    //落地页加载完成uv（根据tuia_id去重）
    private Long lpFinishLoadUV;

    //落地页加载完成pv
    private Long lpFinishLoadPV;

    //落地页加载完成总时长（单位：毫秒）
    private Long lpFinishLoadTime;

    //落地页1s内加载完成PV
    private Long lp1sLoadPV;

    //落地页1s内加载完成uv（根据tuia_id去重）
    private Long lp1sLoadUV;

    //落地页2s内加载完成PV
    private Long lp2sLoadPV;

    //落地页2s内加载完成uv（根据tuia_id去重）
    private Long lp2sLoadUV;

    //落地页3s内加载完成PV
    private Long lp3sLoadPV;

    //落地页3s内加载完成uv（根据tuia_id去重）
    private Long lp3sLoadUV;

    //dsp出价 单位分
    private Long dspPrice;

    //dsp消耗 单位分
    private Long dspConsume;

    //adx出价 单位分
    private Long adxPrice;

    //ADX消耗 单位分
    private Long adxConsume;

    //ADX cpm消耗 单位分
    private Long adxCpmConsume;

    //ADX cpc消耗 单位分
    private Long adxCpcConsume;

    //ADX竞价请求pv
    private Long adxBidRequestPV;

    //ADX底价汇总
    private Double adxFloorPrice;

    //ADX竞价返回pv
    private Long adxBidReturnPV;

    //ADX竞价返回出价汇总
    private Long adxBidReturnPrice;

    //ADX竞价成功pv
    private Long adxBidSuccessPV;

    //DSP请求pv
    private Long dspRequestPV;

    //DSP返回pv
    private Long dspReturnPV;

    //DSP返回出价汇总
    private Double dspReturnPrice;

    //ADX曝光pv
    private Long adxExposurePV;

    //ADX点击pv
    private Long adxClickPV;

    //adx唤起成功pv
    private Long adxWakeSuccessPV;

    //adx唤起失败pv
    private Long adxWakeFailurePV;

    //转化上报pv
    private Long effectReportPV;

    //在线广告主个数
    private Long accountNum;

    //在线广告计划个数
    private Long advertNum;

    //预估ctr汇总
    private Double sumPreCtr;

    //预估cvr汇总
    private Double sumPreCvr;
    //----------------------------------基础指标字段-------------------------------------------------------------//

    //----------------------------------计算指标字段-------------------------------------------------------------//
    //广告位每UV访问数：广告位访问pv(旧逻辑) / 广告位访问uv（根据cid去重）(旧逻辑)
    private Double slotAccessUVRate;

    //手机号接入率：加密手机号接入pv(旧逻辑) / 广告位访问pv(旧逻辑)
    private Double secretPhoneRate;

    //活动页到达率：活动访问uv（根据rid去重）/ 广告位访问uv（根据rid去重）
    private Double activityRequestRate;

    //活动曝光率：活动曝光uv（根据rid去重）/ 活动访问uv（根据rid去重）
    private Double activityExposeRate;

    //活动参与率（根据rid去重）：活动参与uv（根据rid去重）/ 活动访问uv（根据rid去重）
    private Double activityJoinRate;

    //活动参与率（根据cid去重）：活动参与uv（根据cid去重）/ 活动访问uv（根据cid去重）
    private Double activityJoinCidRate;

    //活动复参数：活动参与pv / 活动参与uv（根据cid去重）
    private Double activityRejoinRate;

    //活动每UV参与：活动参与pv / 活动访问uv（根据cid去重）
    private Double activityJoinUVRate;

    //活动首屏加载率：活动首屏加载pv / 活动访问pv
    private Double activityFirstLoadRate;

    //活动首屏加载平均时长：活动首屏加载总时长（单位：毫秒）/ 活动首屏加载pv
    private Double activityFirstLoadAvgTime;

    //活动加载完成率：活动加载完成pv / 活动访问pv
    private Double activityFinishLoadRate;

    //活动加载完成平均时长：活动加载完成总时长（单位：毫秒）/ 活动加载完成pv
    private Double activityFinishLoadAvgTime;

    //活动引导页参与点击率：活动引导页点击uv（根据rid去重）/ 活动访问uv（根据rid去重）
    private Double activityGuideClickRate;

    //落地页加载完成平均时长：落地页加载完成总时长（单位：毫秒）/ 落地页加载完成pv
    private Double lpFinishLoadAvgTime;

    //券请求成功率：券请求pv / 活动参与pv
    private Double couponRequestRate;

    //发券成功率：发券量uv（根据tuia_id去重）/ 券请求uv（根据tuia_id去重）
    private Double launchCouponRate;

    //发券成功率：发券量pv / 券请求pv
    private Double launchCouponPVRate;

    //付费券占比：付费券-发券量pv / 发券量pv
    private Double launchPayCouponPVRate;

    //免费券占比：免费券-发券量pv / 发券量pv
    private Double launchFreeCouponPVRate;

    //作弊券占比：作弊-发券量pv / 发券量pv
    private Double launchRiskCouponPVRate;

    //券曝光成功率：券曝光uv（根据tuia_id去重）/ 发券量uv（根据tuia_id去重）
    private Double couponExposureRate;

    //券曝光成功率：券曝光pv / 发券量pv
    private Double couponExposurePVRate;

    //CTR：券计费点击uv（根据tuia_id去重）/ 券曝光uv（根据tuia_id去重）
    private Double ctr;

    //CTR：券计费点击pv / 券曝光pv
    private Double pvCtr;

    //落地页到达率：落地页曝光uv（根据tuia_id去重）/ 券计费点击uv（根据tuia_id去重）
    private Double lpExposeRate;

    //落地页到达率：落地页曝光pv / 券计费点击pv
    private Double lpExposePVRate;

    //CVR：落地页转化uv（根据tuia_id去重）/ 券计费点击uv（根据tuia_id去重）
    private Double cvr;

    //CVR：落地页转化pv / 券计费点击pv
    private Double pvCvr;

    //注册CVR：后端转化类型-注册uv（根据tuia_id去重）/ 券计费点击uv（根据tuia_id去重）
    private Double registeCvr;

    //注册CVR：后端转化类型-注册pv / 券计费点击pv
    private Double registePVCvr;

    //ARPU：广告消耗（单位：分）/ 发券量uv（根据tuia_id去重）
    private Double arpu;

    //ARPU：广告消耗（单位：分）/ 发券量pv
    private Double pvArpu;

    //理论ARPU：理论消耗（单位：分）/ 发券量uv（根据tuia_id去重）
    private Double theoryArpu;

    //理论ARPU：理论消耗（单位：分）/ 发券量pv
    private Double theoryPVArpu;

    //注册成本：广告消耗（单位：分）/ 后端转化类型-注册uv（根据tuia_id去重）
    private Double registeCost;

    //安装成本：广告消耗（单位：分）/ 后端转化类型-安装pv
    private Double installPVCost;

    //安装成本：平台消耗(利润扣量后的消耗) / 后端转化类型-安装pv
    private Double platformInstallPVCost;

    //安装CVR：后端转化类型-安装pv / 券计费点击pv
    private Double installPVCvr;

    //启动成本：广告消耗（单位：分）/ 后端转化类型-启动pv
    private Double startPVCost;

    //启动成本：平台消耗(利润扣量后的消耗) / 后端转化类型-启动pv
    private Double platformStartPVCost;

    //启动CVR：后端转化类型-启动pv / 券计费点击pv
    private Double startPVCvr;

    //注册成本：广告消耗（单位：分）/ 后端转化类型-注册pv
    private Double registePVCost;

    //注册成本：平台消耗(利润扣量后的消耗) / 后端转化类型-注册pv
    private Double platformRegistePVCost;

    //激活成本：广告消耗（单位：分）/ 后端转化类型-激活pv
    private Double activatePVCost;

    //激活成本：平台消耗(利润扣量后的消耗) / 后端转化类型-激活pv
    private Double platformActivatePVCost;

    //激活CVR：后端转化类型-激活pv / 券计费点击pv
    private Double activatePVCvr;

    //登录成本：广告消耗（单位：分）/ 后端转化类型-登录pv
    private Double loginPVCost;

    //登录成本：平台消耗(利润扣量后的消耗) / 后端转化类型-登录pv
    private Double platformLoginPVCost;

    //登录CVR：后端转化类型-登录pv / 券计费点击pv
    private Double loginPVCvr;

    //付费成本：广告消耗（单位：分）/ 后端转化类型-付费pv
    private Double payPVCost;

    //付费成本：平台消耗(利润扣量后的消耗) / 后端转化类型-付费pv
    private Double platformPayPVCost;

    //付费CVR：后端转化类型-付费pv / 券计费点击pv
    private Double payPVCvr;

    //进件成本：广告消耗（单位：分）/ 后端转化类型-进件pv
    private Double entryPVCost;

    //进件成本：平台消耗(利润扣量后的消耗) / 后端转化类型-进件pv
    private Double platformEntryPVCost;

    //进件CVR：后端转化类型-进件pv / 券计费点击pv
    private Double entryPVCvr;

    //完件成本：广告消耗（单位：分）/ 后端转化类型-完件pv
    private Double finishPVCost;

    //完件成本：平台消耗(利润扣量后的消耗) / 后端转化类型-完件pv
    private Double platformFinishPVCost;

    //完件CVR：后端转化类型-完件pv / 券计费点击pv
    private Double finishPVCvr;

    //签收成本：广告消耗（单位：分）/ 后端转化类型-签收pv
    private Double signPVCost;

    //签收成本：平台消耗(利润扣量后的消耗) / 后端转化类型-签收pv
    private Double platformSignPVCost;

    //签收CVR：后端转化类型-签收pv / 券计费点击pv
    private Double signPVCvr;

    //拒签成本：广告消耗（单位：分）/ 后端转化类型-拒签pv
    private Double denyPVCost;

    //拒签成本：平台消耗(利润扣量后的消耗) / 后端转化类型-拒签pv
    private Double platformDenyPVCost;

    //注册拒签成本：广告消耗（单位：分）/ 后端转化类型-注册拒签pv（先有注册，再有拒签）
    private Double registeDenyPVCost;

    //出单成本：广告消耗（单位：分）/ 后端转化类型-出单pv
    private Double orderPVCost;

    //出单成本：平台消耗(利润扣量后的消耗) / 后端转化类型-出单pv
    private Double platformOrderPVCost;

    //ECPM：广告消耗（单位：分）/ 券曝光uv（根据tuia_id去重）
    private Double ecpm;

    //ECPM：广告消耗（单位：分）/ 券曝光pv
    private Double pvEcpm;

    //落地页转化成本：广告消耗（单位：分）/ 落地页转化uv（根据tuia_id去重）
    private Double lpClickCost;

    //落地页转化成本：广告消耗（单位：分）/ 落地页转化pv
    private Double lpClickPVCost;

    //落地页转化成本：平台消耗(利润扣量后的消耗) / 落地页转化pv
    private Double platformLPClickPVCost;

    //落地页转化理论成本：平台理论消耗 / 落地页转化pv
    private Double lpClickTheoryPVCost;

    //每UV发券：发券量uv（根据tuia_id去重）/ 活动访问uv（根据cid去重）
    private Double launchCouponUVRate;

    //每UV发券：发券量pv / 活动访问uv（根据cid去重）
    private Double launchCouponUVPVRate;

    //每UV点券：券计费点击uv（根据tuia_id去重）/ 活动访问uv（根据cid去重）
    private Double couponEffectClickUVRate;

    //每UV点券：券计费点击pv / 活动访问uv（根据cid去重）
    private Double couponEffectClickUVPVRate;

    //每UV消耗：广告消耗（单位：分）/ 活动访问uv（根据cid去重）
    private Double consumeUVRate;

    //理论每UV消耗：理论消耗（单位：分） / 活动访问uv（根据cid去重）
    private Double theoryConsumeUVRate;

    //计费点击单价：广告消耗（单位：分）/ 券计费点击uv（根据tuia_id去重）
    private Double couponEffectClickCost;

    //计费点击单价：广告消耗（单位：分）/ 券计费点击pv
    private Double couponEffectClickPVCost;

    //理论计费点击单价：理论消耗（单位：分） / 券计费点击uv（根据tuia_id去重）
    private Double theoryCouponEffectClickCost;

    //理论计费点击单价：理论消耗（单位：分） / 券计费点击pv
    private Double theoryCouponEffectClickPVCost;

    //理论OCPC单价：理论消耗（单位：分） / 目标转化pv
    private Double theoryTargetEffectPVCost;

    //平均媒体底价：ADX底价汇总 / ADX竞价请求pv
    private Double avgFloorPrice;

    //adx的ROI：广告消耗 / ADX消耗
    private Double adxRoi;

    //adx分成比例：ADX消耗 / 广告消耗
    private Double adxCostRate;

    //adx点击单价：ADX消耗 / ADX点击pv
    private Double adxClickPVCost;

    //adx媒体激活单价：ADX消耗 / 后端转化类型-激活pv
    private Double adxActivatePVCost;

    //adx媒体二价率：ADX cpm消耗 / adx出价
    private Double adxSecondPriceRate;

    //dsp广告主二价率：dsp消耗 / dsp出价
    private Double dspSecondPriceRate;

    //dsp平均曝光出价：dsp出价 / ADX曝光pv
    private Double avgDspExposurePrice;

    //dsp曝光率：ADX曝光pv / DSP返回pv
    private Double dspExposureRate;

    //adx竞价成功率：竞价成功pv / 竞价返回pv
    private Double adxBidSuccessRate;

    //adx曝光率：ADX曝光pv / 竞价成功pv
    private Double adxExposureRate;

    //adx真实曝光率：ADX曝光pv / 竞价返回pv
    private Double adxRealExposureRate;

    //adx点击率：ADX点击pv / ADX曝光pv
    private Double adxClickRate;

    //adx竞价返回率：ADX竞价返回pv / ADX竞价请求pv
    private Double adxBidReturnRate;

    //ADX唤起成功率：adx唤起成功pv / ADX点击pv
    private Double adxWakeSuccessRate;

    //ADX平均返回出价：ADX竞价返回出价汇总 / ADX竞价返回pv
    private Double avgAdxBidReturnPrice;

    //DSP返回率：DSP返回pv / DSP请求pv
    private Double dspReturnRate;

    //DSP平均返回出价：DSP返回出价汇总 / DSP返回pv
    private Double avgDspReturnPrice;

    //平均成本ECPM：ADX消耗 单位分 / ADX曝光pv * 1000
    private Double adxAppEcpm;

    //平均支出ECPM：广告消耗（单位：分）/ ADX曝光pv * 1000
    private Double adxAdvertEcpm;

    //广告位每pv消耗：广告消耗 / 广告位访问pv
    private Double slotVisitCost;

    //广告位每pv消耗(旧逻辑)：广告消耗 / 广告位访问pv(旧逻辑)
    private Double slotAccessPVCost;

    //转化上报CVR：转化上报pv / 券计费点击pv
    private Double effectReportPVCvr;

    //目标转化CVR：目标转化pv / 券计费点击pv
    private Double targetEffectPVCvr;

    //转化上报成本：平台消耗(利润扣量后的消耗) / 转化上报pv
    private Double effectReportPVCost;

    //转化上报理论成本：平台理论消耗(利润扣量后的消耗) / 转化上报pv
    private Double effectReportPVTheoryCost;

    //转化上报现金成本：平台消耗(利润扣量后的消耗) / 转化上报pv * 1.15
    private Double effectReportPVCashCost;

    //后端转化-付费ROI：后端转化类型-付费金额 / 广告消耗 * 100
    private Double payConsumeRoi;

    //后端转化-安装付费CVR：后端转化类型-付费pv / 后端转化类型-安装pv
    private Double installPayCvr;

    //后端转化-关键行为CVR：后端转化类型-关键行为PV / 券计费点击pv
    private Double keyActionCvr;

    //平均预估CTR: 预估ctr汇总 / 券曝光pv（pre_ctr > 0）
    private Double avgPreCtr;

    //平均预估CVR: 预估cvr汇总 / 券计费点击pv(pre_cvr > 0)
    private Double avgPreCvr;

    //adx万次请求广告消耗: 广告消耗 / (ADX竞价请求pv / 10000)
    private Double adxBidRequest1wConsume;

    //平均预估校准因子: 预估校准因子汇总 / 预估校准因子-发券量pv
    private Double avgPcFactorNew;

    //填表率: 携带手机号码的券请求uv（根据cid去重）/ 活动访问uv（根据cid去重）
    private Double couponRequestPhoneRate;
    //----------------------------------计算指标字段-------------------------------------------------------------//


}
