package cn.com.duiba.bigdata.common.biz.service;

import cn.com.duiba.bigdata.common.biz.constant.BigdataRedisMetricsKeys;
import cn.com.duiba.bigdata.common.biz.entity.redis.BigdataRedisMetricsEntity;
import cn.com.duiba.bigdata.common.biz.utils.BigdataUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

@Slf4j
public class CommonService {

    //后缀
    private static final String SUFFIX = "_a_fee";

    /**
     * 获取bigdata_redis指标池中的统计数据
     *
     * @param map redis hashmap
     * @return 统计指标
     */
    public static BigdataRedisMetricsEntity getBigdataRedisMetricsEntity(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return null;
        }

        BigdataRedisMetricsEntity info = new BigdataRedisMetricsEntity();

        //后端转化指标（区分subType转化类型）
        info.setBackendCntMap(BigdataUtil.getBackendCntMap(map));

        //后端转化消耗（区分subType转化类型）
        info.setBackendAFeeMap(getBackendAFeeMap(map));

        //基础统计指标
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            switch (key) {
                case BigdataRedisMetricsKeys.ACTIVITY_REQUEST:
                    info.setActivityRequest(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ACTIVITY_JOIN:
                    info.setActivityJoin(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.LANDPAGE_EXPOSURE:
                    info.setLandpageExposure(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.LANDPAGE_CLICK:
                    info.setLandpageClick(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.LAUNCH:
                    info.setLaunch(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.EFFECT_CLICK:
                    info.setEffectClick(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.FEE:
                    info.setFee(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.CPC_FEE:
                    info.setCpcFee(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.MIN_FEE:
                    info.setMinFee(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.CLICK:
                    info.setClick(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ADVERT_EXPOSURE:
                    info.setAdvertExposure(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.SDK_SLOT_EXPOSURE:
                    info.setSdkSlotExposure(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.SDK_SLOT_CLICK:
                    info.setSdkSlotClick(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.API_SLOT_EXPOSURE:
                    info.setApiSlotExposure(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.API_SLOT_CLICK:
                    info.setApiSlotClick(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.NEZHA_LAUNCH:
                    info.setNezhaLaunch(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.PRE_CTR:
                    info.setPreCtr(Double.parseDouble(value));
                    break;
                case BigdataRedisMetricsKeys.PRE_CVR:
                    info.setPreCvr(Double.parseDouble(value));
                    break;
                case BigdataRedisMetricsKeys.STAT_CTR:
                    info.setStatCtr(Double.parseDouble(value));
                    break;
                case BigdataRedisMetricsKeys.STAT_CVR:
                    info.setStatCvr(Double.parseDouble(value));
                    break;
                case BigdataRedisMetricsKeys.ADX_FEE:
                    info.setAdxFee(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ADX_CLICK:
                    info.setAdxClick(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ADX_EXPOSURE:
                    info.setAdxExposure(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ADX_BID:
                    info.setAdxBid(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ADX_BID_SUCCESS:
                    info.setAdxBidSuccess(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.BACKEND_CLICK:
                    info.setBackendClick(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ADJUST_FACTOR:
                    info.setFactor(Double.parseDouble(value));
                    break;
                case BigdataRedisMetricsKeys.LANDPAGE_CLICK_AFEE:
                    info.setLandpageClickAfee(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.BACKEND_EFFECT_AFEE:
                    info.setBackendEffectAfee(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ADX_CPM_FEE:
                    info.setAdxCpmFee(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ADX_CPC_FEE:
                    info.setAdxCpcFee(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ALGO_PRICE:
                    info.setAlgoPrice(Double.parseDouble(value));
                    break;
                case BigdataRedisMetricsKeys.SLOT_VISIT:
                    info.setSlotVisit(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.TARGET_LANDPAGE_CLICK:
                    info.setTargetLandpageClick(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.TARGET_BACKEND_CLICK:
                    info.setTargetBackendClick(Long.parseLong(value));
                    break;


                default:
                    break;
            }
        }

        return info;
    }

    //后端转化消耗（区分subType转化类型）
    public static Map<String, Long> getBackendAFeeMap(Map<String, String> data) {
        Map<String, Long> map = new HashMap<>();
        try {
            for (String key : data.keySet()) {
                if (key.endsWith(SUFFIX)) {
                    String value = data.get(key);
                    key = key.replace(SUFFIX, "");
                    map.put(key, Long.valueOf(value));
                }
            }
        } catch (Exception e) {
            log.error("getBackendAFeeMap error", e);
        }

        return map;
    }

}
