package cn.com.duiba.bigdata.common.biz.enums;

public enum StatDimEnum {

    //广告维度
    ADVERT("advert", "advert_id"),

    //广告配置
    PACKAGE("package", "orientation_id"),

    //媒体维度
    APP("app", "app_id"),

    //广告位维度
    SLOT("slot", "slot_id"),

    //广告发券次数
    LAUNCH_TIMES("launch_times", "launch_times"),

    //活动维度
    ACTIVITY("activity", "activity_id"),

    //素材维度
    MATERIAL("material", "material_id"),

    //广告类型
    MAIN_TYPE("main_type", "advert_type"),

    //流量涞源
    FLOW_TYPE("flow_type", "advert_flow_type"),

    //广告二级标签
    SECOND_TAG("second_tag", "advert_second_tag_num"),

    //广告计费方式
    CHARGE_TYPE("charge_type", "charge_type"),

    //托管广告转化成本
    TRUSTEESHIP_COST("trusteeship_cost", "trusteeship_cost"),

    //渠道类型
//    SOURCE_TYPE("source_type"),

    //广告位素材
    SLOT_MATERIAL("slot_material", "slot_material_id"),

    //出价区间
//    FEE_LEVEL("fee_level"),

    //算法推荐类型
    ALG_TYPE("alg_type", "alg_id"),

    //是否是表单类广告 0:非表单 1:表单
    FORM_ADVERT("form_advert", "form_advert"),

    //adx资源位
    RESOURCE("resource", "resource_id"),

    //adx创意
    IDEA("idea", "idea_id"),

    //adx出价策略
    ADX_STRATEGY("adx_strategy", "adx_strategy"),

    //adx出价区间
    ADX_LEVEL("adx_level", "adx_level"),

    //广告行业
    ADVERT_TRADE("advert_trade", "advert_trade_tag_id"),

    //媒体一级行业
    APP_FIRST_TRADE("app_first_trade", "app_first_trade_id"),

    //score区间
    RANK_SCORE("rank_score", "rank_score_level"),

    //目标转化类型
    TARGET_TYPE("target_type", "target_effect_type"),

    //MDP托管自动人群
//    DMP_TAG("dmp_tag"),

    //资源位类型
    RESOURCE_TYPE("resource_type", "dsm2_a"),

    //插件ID
    PLUGIN("plugin", "rsp_plugin_id"),

    //插件次序
    PLUGIN_INDEX("plugin_index", "rsp_plugin_index"),

    //活动投放方式
    ACTIVITY_PUT_TYPE("activity_put_type", "activity_put_type"),

    //广告位素材算法版本
    MATERIAL_ALG_TYPE("material_alg_type", "slot_material_put_type"),

    //adx出价类型 0：人工出价 1：算法出价 2：直投出价
    ADX_PRICE_TYPE("adx_price_type", "price_type"),

    //活动推荐算法版本
    ACTIVITY_ALG_TYPE("activity_alg_type", "activity_release_sub_mode"),

    //标题
//    TITLE("title"),

    //SDK实际投放类型
    SDK_ACTUAL_ACCTTPE("sdk_actual_type", "adx_actual_material"),

    //adx ctr预估区间
    ADX_PRE_INTERVAL("adx_pre_interval", "adx_pre_interval"),

    //adx 过滤类型 1-对照组、不过滤 2-测试组、过滤
    ADX_FILTER_TYPE("adx_filter_type", "adx_pre_filter_type"),
    //
//    //返回插件内容id
//    INTER_CONTENT_ID("inter_content_id"),
//    //返回拦截内容类型
//    INTER_CONTENT_TYPE("inter_content_type"),
    //点击价值分层
    CLICK_VALUE_LEVEL("click_value_level", "adx_click_value_level"),
    //adx交易模式
    ADX_DEAL_TYPE("adx_deal_type", "adx_deal_type"),

    //双出价-模型类型
    DFEE_MODEL_ID("dfee_model_id", "dfee_model_id"),

    //adx 0-不过滤，1-流量预过滤，2-每pv发券过滤
    ADX_STAT_FILTER_TYPE("adx_stat_filter_type", "filter_type"),

    //广告位素材标签
    SLOT_MATERIAL_TAG("slot_material_tag", "slot_material_tag"),

    //活动皮肤类型
    SKIN("skin", "skin_type"),

    //活动奖品标签
    PRIZE_TAG("prize_tag", "prize_tag"),

    //媒体二级行业
    APP_SECOND_TRADE("app_second_trade", "app_second_trade_id"),

    //百度appId（统一成 ext_app_id 字段）
    BAIDU_APP_ID("baidu_app_id", "ext_app_id"),

    //广告主
    ACCOUNT_ID("account_id", "account_id"),

    //ocpc 拓展测试组
    OCPC_EXP_TEST("ocpc_exp_test", "ocpc_exp_test"),

    //探索类型
    AD_EXPLORE("ad_explore", "ad_explore"),

    //实验id 转多行
    EXP_ID("exp_id", "flow_exp_id"),

    //实验组 转多行
    EXP_GROUP("exp_group", "group_tag"),

    //创意素材
    IDEA_MATERIAL("idea_material", "idea_material_id"),

    //创意尺寸
    IDEA_SIZE("idea_size", "idea_size"),

    //外部广告位
    EXTERNAL_SLOT("external_slot", "ext_slot_id"),

    //外部媒体行业
    EXT_APP_TRADE("ext_app_trade", "ext_app_trade"),

    //流量探价类型
    EXPLORE_TYPE("explore_type", "explore_type"),

    //探价Id
    EXPLORE_ID("explore_id", "explore_id"),

    //流量聚合id
    FLOW_POLY_ID("flow_poly_id", "flow_poly_id"),

    //联盟媒体id
    EXT_APP_ID("ext_app_id", "ext_app_id"),

    //联盟广告位id
    EXT_SLOT_ID("ext_slot_id", "ext_slot_id"),

    //dsp平台ID
    DSP_ID("dsp_id", "dsp_id"),

    //dsp广告位ID
    DSP_SLOT_ID("dsp_slot_id", "dsp_slot_id"),

    //dsp任务id
    DSP_TASK_ID("dsp_task_id", "dsp_task_id"),

    //adx流量上携带的媒体包
    PACKAGE_NAME("package_name", "package_name"),







    ;






    private final String name;

    private final String field;

    private StatDimEnum(String name, String field) {
        this.name = name;
        this.field = field;
    }

    public String getName() {
        return name;
    }

    public String getField() {
        return field;
    }
}
