package cn.com.duiba.bigdata.common.biz.enums;

import cn.com.duiba.bigdata.common.biz.domain.CalculateMetricDomain;
import cn.com.duiba.bigdata.common.biz.interfaces.CalculateMetricEnum;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xugf 2023-11-27
 * 推啊业务线-计算类指标字段
 */
public enum TuiaCalculateMetricEnum implements CalculateMetricEnum {

    //广告位每UV访问数：广告位访问pv(旧逻辑) / 广告位访问uv（根据cid去重）(旧逻辑)
    SLOT_ACCESS_UV_RATE("SLOT_ACCESS_PV", "SLOT_ACCESS_UV", "case when sum(slotAccessPV) = 0 or sum(slotAccessUV) = 0 then 0 else round(cast(cast(sum(slotAccessPV) as float) / sum(slotAccessUV) as numeric), 4) end", 4, "slotAccessUVRate", "广告位每UV访问数：广告位访问pv(旧逻辑) / 广告位访问uv（根据cid去重）(旧逻辑)"),

    //手机号接入率：加密手机号接入pv(旧逻辑) / 广告位访问pv(旧逻辑)
    SECRET_PHONE_RATE("SECRET_PHONE_PV", "SLOT_ACCESS_PV", "case when sum(secretPhonePV) = 0 or sum(slotAccessPV) = 0 then 0 else round(cast(cast(sum(secretPhonePV) as float) / sum(slotAccessPV) as numeric), 4) end", 4, "secretPhoneRate", "手机号接入率：加密手机号接入pv(旧逻辑) / 广告位访问pv(旧逻辑)"),

    //活动页到达率：活动访问uv（根据rid去重）/ 广告位访问uv（根据rid去重）
    ACTIVITY_REQUEST_RATE("ACTIVITY_REQUEST_RID_UV", "SLOT_VISIT_RID_UV", "case when sum(activityRequestRidUV) = 0 or sum(slotVisitRidUV) = 0 then 0 else round(cast(cast(sum(activityRequestRidUV) as float) / sum(slotVisitRidUV) as numeric), 4) end", 4, "activityRequestRate", "活动页到达率：活动访问uv（根据rid去重）/ 广告位访问uv（根据rid去重）"),

    //活动曝光率：活动曝光uv（根据rid去重）/ 活动访问uv（根据rid去重）
    ACTIVITY_EXPOSE_RATE("ACTIVITY_EXPOSE_RID_UV", "ACTIVITY_REQUEST_RID_UV", "case when sum(activityExposeRidUV) = 0 or sum(activityRequestRidUV) = 0 then 0 else round(cast(cast(sum(activityExposeRidUV) as float) / sum(activityRequestRidUV) as numeric), 4) end", 4, "activityExposeRate", "活动曝光率：活动曝光uv（根据rid去重）/ 活动访问uv（根据rid去重）"),

    //活动参与率（根据rid去重）：活动参与uv（根据rid去重）/ 活动访问uv（根据rid去重）
    ACTIVITY_JOIN_RATE("ACTIVITY_JOIN_RID_UV", "ACTIVITY_REQUEST_RID_UV", "case when sum(activityJoinRidUV) = 0 or sum(activityRequestRidUV) = 0 then 0 else round(cast(cast(sum(activityJoinRidUV) as float) / sum(activityRequestRidUV) as numeric), 4) end", 4, "activityJoinRate", "活动参与率：活动参与uv（根据rid去重）/ 活动访问uv（根据rid去重）"),

    //活动参与率（根据cid去重）：活动参与uv（根据cid去重）/ 活动访问uv（根据cid去重）
    ACTIVITY_JOIN_CID_RATE("ACTIVITY_JOIN_CID_UV", "ACTIVITY_REQUEST_CID_UV", "case when sum(activityJoinCidUV) = 0 or sum(activityRequestCidUV) = 0 then 0 else round(cast(cast(sum(activityJoinCidUV) as float) / sum(activityRequestCidUV) as numeric), 4) end", 4, "activityJoinCidRate", "活动参与率（根据cid去重）：活动参与uv（根据cid去重）/ 活动访问uv（根据cid去重）"),

    //活动复参数：活动参与pv / 活动参与uv（根据cid去重）
    ACTIVITY_REJOIN_RATE("ACTIVITY_JOIN_PV", "ACTIVITY_JOIN_CID_UV", "case when sum(activityJoinPV) = 0 or sum(activityJoinCidUV) = 0 then 0 else round(cast(cast(sum(activityJoinPV) as float) / sum(activityJoinCidUV) as numeric), 4) end", 4, "activityRejoinRate", "活动复参数：活动参与pv / 活动参与uv（根据cid去重）"),

    //活动每UV参与：活动参与pv / 活动访问uv（根据cid去重）
    ACTIVITY_JOIN_UV_RATE("ACTIVITY_JOIN_PV", "ACTIVITY_REQUEST_CID_UV", "case when sum(activityJoinPV) = 0 or sum(activityRequestCidUV) = 0 then 0 else round(cast(cast(sum(activityJoinPV) as float) / sum(activityRequestCidUV) as numeric), 4) end", 4, "activityJoinUVRate", "活动每UV参与：活动参与pv / 活动访问uv（根据cid去重）"),

    //活动首屏加载率：活动首屏加载pv / 活动访问pv
    ACTIVITY_FIRST_LOAD_RATE("ACTIVITY_FIRST_LOAD_PV", "ACTIVITY_REQUEST_PV", "case when sum(activityFirstLoadPV) = 0 or sum(activityRequestPV) = 0 then 0 else round(cast(cast(sum(activityFirstLoadPV) as float) / sum(activityRequestPV) as numeric), 4) end", 4, "activityFirstLoadRate", "活动首屏加载率：活动首屏加载pv / 活动访问pv"),

    //活动首屏加载平均时长：活动首屏加载总时长（单位：毫秒）/ 活动首屏加载pv
    ACTIVITY_FIRST_LOAD_AVG_TIME("ACTIVITY_FIRST_LOAD_TIME", "ACTIVITY_FIRST_LOAD_PV", "case when sum(activityFirstLoadTime) = 0 or sum(activityFirstLoadPV) = 0 then 0 else round(cast(cast(sum(activityFirstLoadTime) as float) / sum(activityFirstLoadPV) as numeric), 4) end", 4, "activityFirstLoadAvgTime", "活动首屏加载平均时长：活动首屏加载总时长（单位：毫秒）/ 活动首屏加载pv"),

    //活动加载完成率：活动加载完成pv / 活动访问pv
    ACTIVITY_FINISH_LOAD_RATE("ACTIVITY_FINISH_LOAD_PV", "ACTIVITY_REQUEST_PV", "case when sum(activityFinishLoadPV) = 0 or sum(activityRequestPV) = 0 then 0 else round(cast(cast(sum(activityFinishLoadPV) as float) / sum(activityRequestPV) as numeric), 4) end", 4, "activityFinishLoadRate", "活动加载完成率：活动加载完成pv / 活动访问pv"),

    //活动加载完成平均时长：活动加载完成总时长（单位：毫秒）/ 活动加载完成pv
    ACTIVITY_FINISH_LOAD_AVG_TIME("ACTIVITY_FINISH_LOAD_TIME", "ACTIVITY_FINISH_LOAD_PV", "case when sum(activityFinishLoadTime) = 0 or sum(activityFinishLoadPV) = 0 then 0 else round(cast(cast(sum(activityFinishLoadTime) as float) / sum(activityFinishLoadPV) as numeric), 4) end", 4, "activityFinishLoadAvgTime", "活动加载完成平均时长：活动加载完成总时长（单位：毫秒）/ 活动加载完成pv"),

    //活动引导页参与点击率：活动引导页点击uv（根据rid去重）/ 活动访问uv（根据rid去重）
    ACTIVITY_GUIDE_CLICK_RATE("ACTIVITY_GUIDE_CLICK_RID_UV", "ACTIVITY_REQUEST_RID_UV", "case when sum(activityGuideClickRidUV) = 0 or sum(activityRequestRidUV) = 0 then 0 else round(cast(cast(sum(activityGuideClickRidUV) as float) / sum(activityRequestRidUV) as numeric), 4) end", 4, "activityGuideClickRate", "活动引导页参与点击率：活动引导页点击uv（根据rid去重）/ 活动访问uv（根据rid去重）"),

    //落地页加载完成平均时长：落地页加载完成总时长（单位：毫秒）/ 落地页加载完成pv
    LP_FINISH_LOAD_AVG_TIME("LP_FINISH_LOAD_TIME", "LP_FINISH_LOAD_PV", "case when sum(lpFinishLoadTime) = 0 or sum(lpFinishLoadPV) = 0 then 0 else round(cast(cast(sum(lpFinishLoadTime) as float) / sum(lpFinishLoadPV) as numeric), 4) end", 4, "lpFinishLoadAvgTime", "落地页加载完成平均时长：落地页加载完成总时长（单位：毫秒）/ 落地页加载完成pv"),

    //券请求成功率：券请求pv / 活动参与pv
    COUPON_REQUEST_RATE("COUPON_REQUEST_PV", "ACTIVITY_JOIN_PV", "case when sum(couponRequestPV) = 0 or sum(activityJoinPV) = 0 then 0 else round(cast(cast(sum(couponRequestPV) as float) / sum(activityJoinPV) as numeric), 4) end", 4, "couponRequestRate", "券请求成功率：券请求pv / 活动参与pv"),

    //发券成功率：发券量uv（根据tuia_id去重）/ 券请求uv（根据tuia_id去重）
    LAUNCH_COUPON_RATE("LAUNCH_COUPON_UV", "COUPON_REQUEST_UV", "case when sum(launchCouponUV) = 0 or sum(couponRequestUV) = 0 then 0 else round(cast(cast(sum(launchCouponUV) as float) / sum(couponRequestUV) as numeric), 4) end", 4, "launchCouponRate", "发券成功率：发券量uv（根据tuia_id去重）/ 券请求uv（根据tuia_id去重）"),

    //发券成功率：发券量pv / 券请求pv
    LAUNCH_COUPON_PV_RATE("LAUNCH_COUPON_PV", "COUPON_REQUEST_PV", "case when sum(launchCouponPV) = 0 or sum(couponRequestPV) = 0 then 0 else round(cast(cast(sum(launchCouponPV) as float) / sum(couponRequestPV) as numeric), 4) end", 4, "launchCouponPVRate", "发券成功率：发券量pv / 券请求pv"),

    //付费券占比：付费券-发券量pv / 发券量pv
    LAUNCH_PAY_COUPON_PV_RATE("LAUNCH_PAY_COUPON_PV", "LAUNCH_COUPON_PV", "case when sum(launchPayCouponPV) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(launchPayCouponPV) as float) / sum(launchCouponPV) as numeric), 4) end", 4, "launchPayCouponPVRate", "付费券占比：付费券-发券量pv / 发券量pv"),

    //免费券占比：免费券-发券量pv / 发券量pv
    LAUNCH_FREE_COUPON_PV_RATE("LAUNCH_FREE_COUPON_PV", "LAUNCH_COUPON_PV", "case when sum(launchFreeCouponPV) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(launchFreeCouponPV) as float) / sum(launchCouponPV) as numeric), 4) end", 4, "launchFreeCouponPVRate", "免费券占比：免费券-发券量pv / 发券量pv"),

    //作弊券占比：作弊-发券量pv / 发券量pv
    LAUNCH_RISK_COUPON_PV_RATE("LAUNCH_RISK_COUPON_PV", "LAUNCH_COUPON_PV", "case when sum(launchRiskCouponPV) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(launchRiskCouponPV) as float) / sum(launchCouponPV) as numeric), 4) end", 4, "launchRiskCouponPVRate", "作弊券占比：作弊-发券量pv / 发券量pv"),

    //券曝光成功率：券曝光uv（根据tuia_id去重）/ 发券量uv（根据tuia_id去重）
    COUPON_EXPOSURE_RATE("COUPON_EXPOSURE_UV", "LAUNCH_COUPON_UV", "case when sum(couponExposureUV) = 0 or sum(launchCouponUV) = 0 then 0 else round(cast(cast(sum(couponExposureUV) as float) / sum(launchCouponUV) as numeric), 4) end", 4, "couponExposureRate", "券曝光成功率：券曝光uv（根据tuia_id去重）/ 发券量uv（根据tuia_id去重）"),

    //券曝光成功率：券曝光pv / 发券量pv
    COUPON_EXPOSURE_PV_RATE("COUPON_EXPOSURE_PV", "LAUNCH_COUPON_PV", "case when sum(couponExposurePV) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(couponExposurePV) as float) / sum(launchCouponPV) as numeric), 4) end", 4, "couponExposurePVRate", "券曝光成功率：券曝光pv / 发券量pv"),

    //CTR：券计费点击uv（根据tuia_id去重）/ 券曝光uv（根据tuia_id去重）
    CTR("COUPON_EFFECT_CLICK_UV", "COUPON_EXPOSURE_UV", "case when sum(couponEffectClickUV) = 0 or sum(couponExposureUV) = 0 then 0 else round(cast(cast(sum(couponEffectClickUV) as float) / sum(couponExposureUV) as numeric), 4) end", 4, "ctr", "CTR：券计费点击uv（根据tuia_id去重）/ 券曝光uv（根据tuia_id去重）"),

    //CTR：券计费点击pv / 券曝光pv
    PV_CTR("COUPON_EFFECT_CLICK_PV", "COUPON_EXPOSURE_PV", "case when sum(couponEffectClickPV) = 0 or sum(couponExposurePV) = 0 then 0 else round(cast(cast(sum(couponEffectClickPV) as float) / sum(couponExposurePV) as numeric), 4) end", 4, "pvCtr", "CTR：券计费点击pv / 券曝光pv"),

    //落地页到达率：落地页曝光uv（根据tuia_id去重）/ 券计费点击uv（根据tuia_id去重）
    LP_EXPOSE_RATE("LP_EXPOSE_UV", "COUPON_EFFECT_CLICK_UV", "case when sum(lpExposeUV) = 0 or sum(couponEffectClickUV) = 0 then 0 else round(cast(cast(sum(lpExposeUV) as float) / sum(couponEffectClickUV) as numeric), 4) end", 4, "lpExposeRate", "落地页到达率：落地页曝光uv（根据tuia_id去重）/ 券计费点击uv（根据tuia_id去重）"),

    //落地页到达率：落地页曝光pv / 券计费点击pv
    LP_EXPOSE_PV_RATE("LP_EXPOSE_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(lpExposePV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(lpExposePV) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "lpExposePVRate", "落地页到达率：落地页曝光pv / 券计费点击pv"),

    //CVR：落地页转化uv（根据tuia_id去重）/ 券计费点击uv（根据tuia_id去重）
    CVR("LP_CLICK_UV", "COUPON_EFFECT_CLICK_UV", "case when sum(lpClickUV) = 0 or sum(couponEffectClickUV) = 0 then 0 else round(cast(cast(sum(lpClickUV) as float) / sum(couponEffectClickUV) as numeric), 4) end", 4, "cvr", "CVR：落地页转化uv（根据tuia_id去重）/ 券计费点击uv（根据tuia_id去重）"),

    //CVR：落地页转化pv / 券计费点击pv
    PV_CVR("LP_CLICK_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(lpClickPV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(lpClickPV) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "pvCvr", "CVR：落地页转化pv / 券计费点击pv"),

    //注册CVR：后端转化类型-注册uv（根据tuia_id去重）/ 券计费点击uv（根据tuia_id去重）
    REGISTE_CVR("REGISTE_UV", "COUPON_EFFECT_CLICK_UV", "case when sum(registeUV) = 0 or sum(couponEffectClickUV) = 0 then 0 else round(cast(cast(sum(registeUV) as float) / sum(couponEffectClickUV) as numeric), 4) end", 4, "registeCvr", "注册CVR：后端转化类型-注册uv（根据tuia_id去重）/ 券计费点击uv（根据tuia_id去重）"),

    //注册CVR：后端转化类型-注册pv / 券计费点击pv
    REGISTE_PV_CVR("REGISTE_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(registePV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(registePV) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "registePVCvr", "注册CVR：后端转化类型-注册pv / 券计费点击pv"),

    //ARPU：广告消耗（单位：分）/ 发券量uv（根据tuia_id去重）
    ARPU("CONSUME", "LAUNCH_COUPON_UV", "case when sum(consume) = 0 or sum(launchCouponUV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(launchCouponUV) as numeric), 4) end", 4, "arpu", "ARPU：广告消耗（单位：分）/ 发券量uv（根据tuia_id去重）"),

    //ARPU：广告消耗（单位：分）/ 发券量pv
    PV_ARPU("CONSUME", "LAUNCH_COUPON_PV", "case when sum(consume) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(launchCouponPV) as numeric), 4) end", 4, "pvArpu", "ARPU：广告消耗（单位：分）/ 发券量pv"),

    //理论ARPU：理论消耗（单位：分）/ 发券量uv（根据tuia_id去重）
    THEORY_ARPU("THEORY_CONSUME", "LAUNCH_COUPON_UV", "case when sum(theoryConsume) = 0 or sum(launchCouponUV) = 0 then 0 else round(cast(cast(sum(theoryConsume) as float) / sum(launchCouponUV) as numeric), 4) end", 4, "theoryArpu", "ARPU：理论ARPU：理论消耗（单位：分）/ 发券量uv（根据tuia_id去重）"),

    //理论ARPU：理论消耗（单位：分）/ 发券量pv
    THEORY_PV_ARPU("THEORY_CONSUME", "LAUNCH_COUPON_PV", "case when sum(theoryConsume) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(theoryConsume) as float) / sum(launchCouponPV) as numeric), 4) end", 4, "theoryPVArpu", "ARPU：理论消耗（单位：分）/ 发券量pv"),

    //注册成本：广告消耗（单位：分）/ 后端转化类型-注册uv（根据tuia_id去重）
    REGISTE_COST("CONSUME", "REGISTE_UV", "case when sum(consume) = 0 or sum(registeUV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(registeUV) as numeric), 4) end", 4, "registeCost", "注册成本：广告消耗（单位：分）/ 后端转化类型-注册uv（根据tuia_id去重）"),

    //安装成本：广告消耗（单位：分）/ 后端转化类型-安装pv
    INSTALL_PV_COST("CONSUME", "INSTALL_PV", "case when sum(consume) = 0 or sum(installPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(installPV) as numeric), 4) end", 4, "installPVCost", "安装成本：广告消耗（单位：分）/ 后端转化类型-安装pv"),

    //安装成本：平台消耗(利润扣量后的消耗) / 后端转化类型-安装pv
    PLATFORM_INSTALL_PV_COST("PLATFORM_CONSUME", "INSTALL_PV", "case when sum(platformConsume) = 0 or sum(installPV) = 0 then 0 else round(cast(cast(sum(platformConsume) as float) / sum(installPV) as numeric), 4) end", 4, "platformInstallPVCost", "安装成本：平台消耗(利润扣量后的消耗) / 后端转化类型-安装pv"),

    //安装CVR：后端转化类型-安装pv / 券计费点击pv
    INSTALL_PV_CVR("INSTALL_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(installPV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(installPV) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "installPVCvr", "安装CVR：后端转化类型-安装pv / 券计费点击pv"),

    //启动成本：广告消耗（单位：分）/ 后端转化类型-启动pv
    START_PV_COST("CONSUME", "START_PV", "case when sum(consume) = 0 or sum(startPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(startPV) as numeric), 4) end", 4, "startPVCost", "启动成本：广告消耗（单位：分）/ 后端转化类型-启动pv"),

    //启动成本：平台消耗(利润扣量后的消耗) / 后端转化类型-启动pv
    PLATFORM_START_PV_COST("PLATFORM_CONSUME", "START_PV", "case when sum(platformConsume) = 0 or sum(startPV) = 0 then 0 else round(cast(cast(sum(platformConsume) as float) / sum(startPV) as numeric), 4) end", 4, "platformStartPVCost", "启动成本：平台消耗(利润扣量后的消耗) / 后端转化类型-启动pv"),

    //启动CVR：后端转化类型-启动pv / 券计费点击pv
    START_PV_CVR("START_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(startPV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(startPV) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "startPVCvr", "启动CVR：后端转化类型-启动pv / 券计费点击pv"),

    //注册成本：广告消耗（单位：分）/ 后端转化类型-注册pv
    REGISTE_PV_COST("CONSUME", "REGISTE_PV", "case when sum(consume) = 0 or sum(registePV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(registePV) as numeric), 4) end", 4, "registePVCost", "注册成本：广告消耗（单位：分）/ 后端转化类型-注册pv"),

    //注册成本：平台消耗(利润扣量后的消耗) / 后端转化类型-注册pv
    PLATFORM_REGISTE_PV_COST("PLATFORM_CONSUME", "REGISTE_PV", "case when sum(platformConsume) = 0 or sum(registePV) = 0 then 0 else round(cast(cast(sum(platformConsume) as float) / sum(registePV) as numeric), 4) end", 4, "platformRegistePVCost", "注册成本：平台消耗(利润扣量后的消耗) / 后端转化类型-注册pv"),

    //激活成本：广告消耗（单位：分）/ 后端转化类型-激活pv
    ACTIVATE_PV_COST("CONSUME", "ACTIVATE_PV", "case when sum(consume) = 0 or sum(activatePV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(activatePV) as numeric), 4) end", 4, "activatePVCost", "广告激活单价：广告消耗（单位：分）/ 后端转化类型-激活pv"),

    //激活成本：平台消耗(利润扣量后的消耗) / 后端转化类型-激活pv
    PLATFORM_ACTIVATE_PV_COST("PLATFORM_CONSUME", "ACTIVATE_PV", "case when sum(platformConsume) = 0 or sum(activatePV) = 0 then 0 else round(cast(cast(sum(platformConsume) as float) / sum(activatePV) as numeric), 4) end", 4, "platformActivatePVCost", "激活成本：平台消耗(利润扣量后的消耗) / 后端转化类型-激活pv"),

    //激活CVR：后端转化类型-激活pv / 券计费点击pv
    ACTIVATE_PV_CVR("ACTIVATE_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(activatePV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(activatePV) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "activatePVCvr", "激活CVR：后端转化类型-激活pv / 券计费点击pv"),

    //登录成本：广告消耗（单位：分）/ 后端转化类型-登录pv
    LOGIN_PV_COST("CONSUME", "LOGIN_PV", "case when sum(consume) = 0 or sum(loginPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(loginPV) as numeric), 4) end", 4, "loginPVCost", "登录成本：广告消耗（单位：分）/ 后端转化类型-登录pv"),

    //登录成本：平台消耗(利润扣量后的消耗) / 后端转化类型-登录pv
    PLATFORM_LOGIN_PV_COST("PLATFORM_CONSUME", "LOGIN_PV", "case when sum(platformConsume) = 0 or sum(loginPV) = 0 then 0 else round(cast(cast(sum(platformConsume) as float) / sum(loginPV) as numeric), 4) end", 4, "platformLoginPVCost", "登录成本：平台消耗(利润扣量后的消耗) / 后端转化类型-登录pv"),

    //登录CVR：后端转化类型-登录pv / 券计费点击pv
    LOGIN_PV_CVR("LOGIN_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(loginPV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(loginPV) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "loginPVCvr", "登录CVR：后端转化类型-登录pv / 券计费点击pv"),

    //付费成本：广告消耗（单位：分）/ 后端转化类型-付费pv
    PAY_PV_COST("CONSUME", "PAY_PV", "case when sum(consume) = 0 or sum(payPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(payPV) as numeric), 4) end", 4, "payPVCost", "付费成本：广告消耗（单位：分）/ 后端转化类型-付费pv"),

    //付费成本：平台消耗(利润扣量后的消耗) / 后端转化类型-付费pv
    PLATFORM_PAY_PV_COST("PLATFORM_CONSUME", "PAY_PV", "case when sum(platformConsume) = 0 or sum(payPV) = 0 then 0 else round(cast(cast(sum(platformConsume) as float) / sum(payPV) as numeric), 4) end", 4, "platformPayPVCost", "付费成本：平台消耗(利润扣量后的消耗) / 后端转化类型-付费pv"),

    //付费CVR：后端转化类型-付费pv / 券计费点击pv
    PAY_PV_CVR("PAY_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(payPV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(payPV) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "payPVCvr", "付费CVR：后端转化类型-付费pv / 券计费点击pv"),

    //进件成本：广告消耗（单位：分）/ 后端转化类型-进件pv
    ENTRY_PV_COST("CONSUME", "ENTRY_PV", "case when sum(consume) = 0 or sum(entryPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(entryPV) as numeric), 4) end", 4, "entryPVCost", "进件成本：广告消耗（单位：分）/ 后端转化类型-进件pv"),

    //进件成本：平台消耗(利润扣量后的消耗) / 后端转化类型-进件pv
    PLATFORM_ENTRY_PV_COST("PLATFORM_CONSUME", "ENTRY_PV", "case when sum(platformConsume) = 0 or sum(entryPV) = 0 then 0 else round(cast(cast(sum(platformConsume) as float) / sum(entryPV) as numeric), 4) end", 4, "platformEntryPVCost", "进件成本：平台消耗(利润扣量后的消耗) / 后端转化类型-进件pv"),

    //进件CVR：后端转化类型-进件pv / 券计费点击pv
    ENTRY_PV_CVR("ENTRY_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(entryPV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(entryPV) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "entryPVCvr", "进件CVR：后端转化类型-进件pv / 券计费点击pv"),

    //完件成本：广告消耗（单位：分）/ 后端转化类型-完件pv
    FINISH_PV_COST("CONSUME", "FINISH_PV", "case when sum(consume) = 0 or sum(finishPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(finishPV) as numeric), 4) end", 4, "finishPVCost", "完件成本：广告消耗（单位：分）/ 后端转化类型-完件pv"),

    //完件成本：平台消耗(利润扣量后的消耗) / 后端转化类型-完件pv
    PLATFORM_FINISH_PV_COST("PLATFORM_CONSUME", "FINISH_PV", "case when sum(platformConsume) = 0 or sum(finishPV) = 0 then 0 else round(cast(cast(sum(platformConsume) as float) / sum(finishPV) as numeric), 4) end", 4, "platformFinishPVCost", "完件成本：平台消耗(利润扣量后的消耗) / 后端转化类型-完件pv"),

    //完件CVR：后端转化类型-完件pv / 券计费点击pv
    FINISH_PV_CVR("FINISH_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(finishPV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(finishPV) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "finishPVCvr", "完件CVR：后端转化类型-完件pv / 券计费点击pv"),

    //签收成本：广告消耗（单位：分）/ 后端转化类型-签收pv
    SIGN_PV_COST("CONSUME", "SIGN_PV", "case when sum(consume) = 0 or sum(signPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(signPV) as numeric), 4) end", 4, "signPVCost", "签收成本：广告消耗（单位：分）/ 后端转化类型-签收pv"),

    //签收成本：平台消耗(利润扣量后的消耗) / 后端转化类型-签收pv
    PLATFORM_SIGN_PV_COST("PLATFORM_CONSUME", "SIGN_PV", "case when sum(platformConsume) = 0 or sum(signPV) = 0 then 0 else round(cast(cast(sum(platformConsume) as float) / sum(signPV) as numeric), 4) end", 4, "platformSignPVCost", "签收成本：平台消耗(利润扣量后的消耗) / 后端转化类型-签收pv"),

    //签收CVR：后端转化类型-签收pv / 券计费点击pv
    SIGN_PV_CVR("SIGN_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(signPV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(signPV) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "signPVCvr", "签收CVR：后端转化类型-签收pv / 券计费点击pv"),

    //拒签成本：广告消耗（单位：分）/ 后端转化类型-拒签pv
    DENY_PV_COST("CONSUME", "DENY_PV", "case when sum(consume) = 0 or sum(denyPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(denyPV) as numeric), 4) end", 4, "denyPVCost", "拒签成本：广告消耗（单位：分）/ 后端转化类型-拒签pv"),

    //拒签成本：平台消耗(利润扣量后的消耗) / 后端转化类型-拒签pv
    PLATFORM_DENY_PV_COST("PLATFORM_CONSUME", "DENY_PV", "case when sum(platformConsume) = 0 or sum(denyPV) = 0 then 0 else round(cast(cast(sum(platformConsume) as float) / sum(denyPV) as numeric), 4) end", 4, "platformDenyPVCost", "拒签成本：平台消耗(利润扣量后的消耗) / 后端转化类型-拒签pv"),

    //注册拒签成本：广告消耗（单位：分）/ 后端转化类型-注册拒签pv（先有注册，再有拒签）
    REGISTE_DENY_PV_COST("CONSUME", "REGISTE_DENY_PV", "case when sum(consume) = 0 or sum(registeDenyPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(registeDenyPV) as numeric), 4) end", 4, "registeDenyPVCost", "注册拒签成本：广告消耗（单位：分）/ 后端转化类型-注册拒签pv（先有注册，再有拒签）"),

    //出单成本：广告消耗（单位：分）/ 后端转化类型-出单pv
    ORDER_PV_COST("CONSUME", "ORDER_PV", "case when sum(consume) = 0 or sum(orderPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(orderPV) as numeric), 4) end", 4, "orderPVCost", "出单成本：广告消耗（单位：分）/ 后端转化类型-出单pv"),

    //出单成本：平台消耗(利润扣量后的消耗) / 后端转化类型-出单pv
    PLATFORM_ORDER_PV_COST("PLATFORM_CONSUME", "ORDER_PV", "case when sum(platformConsume) = 0 or sum(orderPV) = 0 then 0 else round(cast(cast(sum(platformConsume) as float) / sum(orderPV) as numeric), 4) end", 4, "platformOrderPVCost", "出单成本：平台消耗(利润扣量后的消耗) / 后端转化类型-出单pv"),

    //ECPM：广告消耗（单位：分）/ 券曝光uv（根据tuia_id去重）
    ECPM("CONSUME", "COUPON_EXPOSURE_UV", "case when sum(consume) = 0 or sum(couponExposureUV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(couponExposureUV) as numeric), 4) end", 4, "ecpm", "ECPM：广告消耗（单位：分）/ 券曝光uv（根据tuia_id去重）"),

    //ECPM：广告消耗（单位：分）/ 券曝光pv
    PV_ECPM("CONSUME", "COUPON_EXPOSURE_PV", "case when sum(consume) = 0 or sum(couponExposurePV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(couponExposurePV) as numeric), 4) end", 4, "pvEcpm", "ECPM：广告消耗（单位：分）/ 券曝光pv"),

    //落地页转化成本：广告消耗（单位：分）/ 落地页转化uv（根据tuia_id去重）
    LP_CLICK_COST("CONSUME", "LP_CLICK_UV", "case when sum(consume) = 0 or sum(lpClickUV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(lpClickUV) as numeric), 4) end", 4, "lpClickCost", "落地页转化成本：广告消耗（单位：分）/ 落地页转化uv（根据tuia_id去重）"),

    //落地页转化成本：广告消耗（单位：分）/ 落地页转化pv
    LP_CLICK_PV_COST("CONSUME", "LP_CLICK_PV", "case when sum(consume) = 0 or sum(lpClickPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(lpClickPV) as numeric), 4) end", 4, "lpClickPVCost", "落地页转化成本：广告消耗（单位：分）/ 落地页转化pv"),

    //落地页转化成本：平台消耗(利润扣量后的消耗) / 落地页转化pv
    PLATFORM_LP_CLICK_PV_COST("PLATFORM_CONSUME", "LP_CLICK_PV", "case when sum(platformConsume) = 0 or sum(lpClickPV) = 0 then 0 else round(cast(cast(sum(platformConsume) as float) / sum(lpClickPV) as numeric), 4) end", 4, "platformLPClickPVCost", "落地页转化成本：平台消耗(利润扣量后的消耗) / 落地页转化pv"),

    //落地页转化理论成本：平台理论消耗 / 落地页转化pv
    LP_CLICK_THEORY_PV_COST("PLATFORM_THEORY_CONSUME", "LP_CLICK_PV", "case when sum(platformTheoryConsume) = 0 or sum(lpClickPV) = 0 then 0 else round(cast(cast(sum(platformTheoryConsume) as float) / sum(lpClickPV) as numeric), 4) end", 4, "lpClickTheoryPVCost", "落地页转化理论成本：平台理论消耗 / 落地页转化pv"),

    //每UV发券：发券量uv（根据tuia_id去重）/ 活动访问uv（根据cid去重）
    LAUNCH_COUPON_UV_RATE("LAUNCH_COUPON_UV", "ACTIVITY_REQUEST_CID_UV", "case when sum(launchCouponUV) = 0 or sum(activityRequestCidUV) = 0 then 0 else round(cast(cast(sum(launchCouponUV) as float) / sum(activityRequestCidUV) as numeric), 4) end", 4, "launchCouponUVRate", "每UV发券：发券量uv（根据tuia_id去重）/ 活动访问uv（根据cid去重）"),

    //每UV发券：发券量pv / 活动访问uv（根据cid去重）
    LAUNCH_COUPON_UV_PV_RATE("LAUNCH_COUPON_PV", "ACTIVITY_REQUEST_CID_UV", "case when sum(launchCouponPV) = 0 or sum(activityRequestCidUV) = 0 then 0 else round(cast(cast(sum(launchCouponPV) as float) / sum(activityRequestCidUV) as numeric), 4) end", 4, "launchCouponUVPVRate", "每UV发券：发券量pv / 活动访问uv（根据cid去重）"),

    //每UV点券：券计费点击uv（根据tuia_id去重）/ 活动访问uv（根据cid去重）
    COUPON_EFFECT_CLICK_UV_RATE("COUPON_EFFECT_CLICK_UV", "ACTIVITY_REQUEST_CID_UV", "case when sum(couponEffectClickUV) = 0 or sum(activityRequestCidUV) = 0 then 0 else round(cast(cast(sum(couponEffectClickUV) as float) / sum(activityRequestCidUV) as numeric), 4) end", 4, "couponEffectClickUVRate", "每UV点券：券计费点击uv（根据tuia_id去重）/ 活动访问uv（根据cid去重）"),

    //每UV点券：券计费点击pv / 活动访问uv（根据cid去重）
    COUPON_EFFECT_CLICK_UV_PV_RATE("COUPON_EFFECT_CLICK_PV", "ACTIVITY_REQUEST_CID_UV", "case when sum(couponEffectClickPV) = 0 or sum(activityRequestCidUV) = 0 then 0 else round(cast(cast(sum(couponEffectClickPV) as float) / sum(activityRequestCidUV) as numeric), 4) end", 4, "couponEffectClickUVPVRate", "每UV点券：券计费点击pv / 活动访问uv（根据cid去重）"),

    //每UV消耗：广告消耗（单位：分）/ 活动访问uv（根据cid去重）
    CONSUME_UV_RATE("CONSUME", "ACTIVITY_REQUEST_CID_UV", "case when sum(consume) = 0 or sum(activityRequestCidUV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(activityRequestCidUV) as numeric), 4) end", 4, "consumeUVRate", "每UV消耗：广告消耗（单位：分）/ 活动访问uv（根据cid去重）"),

    //理论每UV消耗：理论消耗（单位：分） / 活动访问uv（根据cid去重）
    THEORY_CONSUME_UV_RATE("THEORY_CONSUME", "ACTIVITY_REQUEST_CID_UV", "case when sum(theoryConsume) = 0 or sum(activityRequestCidUV) = 0 then 0 else round(cast(cast(sum(theoryConsume) as float) / sum(activityRequestCidUV) as numeric), 4) end", 4, "theoryConsumeUVRate", "理论每UV消耗：理论消耗（单位：分） / 活动访问uv（根据cid去重）"),

    //计费点击单价：广告消耗（单位：分）/ 券计费点击uv（根据tuia_id去重）
    COUPON_EFFECT_CLICK_COST("CONSUME", "COUPON_EFFECT_CLICK_UV", "case when sum(consume) = 0 or sum(couponEffectClickUV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(couponEffectClickUV) as numeric), 4) end", 4, "couponEffectClickCost", "计费点击单价：广告消耗（单位：分）/ 券计费点击uv（根据tuia_id去重）"),

    //计费点击单价：广告消耗（单位：分）/ 券计费点击pv
    COUPON_EFFECT_CLICK_PV_COST("CONSUME", "COUPON_EFFECT_CLICK_PV", "case when sum(consume) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "couponEffectClickPVCost", "计费点击单价：广告消耗（单位：分）/ 券计费点击pv"),

    //理论计费点击单价：理论消耗（单位：分） / 券计费点击uv（根据tuia_id去重）
    THEORY_COUPON_EFFECT_CLICK_COST("THEORY_CONSUME", "COUPON_EFFECT_CLICK_UV", "case when sum(theoryConsume) = 0 or sum(couponEffectClickUV) = 0 then 0 else round(cast(cast(sum(theoryConsume) as float) / sum(couponEffectClickUV) as numeric), 4) end", 4, "theoryCouponEffectClickCost", "理论计费点击单价：理论消耗（单位：分） / 券计费点击uv（根据tuia_id去重）"),

    //理论计费点击单价：理论消耗（单位：分） / 券计费点击pv
    THEORY_COUPON_EFFECT_CLICK_PV_COST("THEORY_CONSUME", "COUPON_EFFECT_CLICK_PV", "case when sum(theoryConsume) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(theoryConsume) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "theoryCouponEffectClickPVCost", "理论计费点击单价：理论消耗（单位：分） / 券计费点击pv"),

    //理论OCPC单价：理论消耗（单位：分） / 目标转化pv
    THEORY_TARGET_EFFECT_PV_COST("THEORY_CONSUME", "TARGET_EFFECT_PV", "case when sum(theoryConsume) = 0 or sum(targetEffectPV) = 0 then 0 else round(cast(cast(sum(theoryConsume) as float) / sum(targetEffectPV) as numeric), 4) end", 4, "theoryTargetEffectPVCost", "理论OCPC单价：理论消耗（单位：分） / 目标转化pv"),

    //平均媒体底价：ADX底价汇总 / ADX竞价请求pv
    AVG_FLOOR_PRICE("ADX_FLOOR_PRICE", "ADX_BID_REQUEST_PV", "case when sum(adxFloorPrice) = 0 or sum(adxBidRequestPV) = 0 then 0 else round(cast(cast(sum(adxFloorPrice) as float) / sum(adxBidRequestPV) * 1000 as numeric), 4) end", 4, "avgFloorPrice", "平均媒体底价：ADX底价汇总 / ADX竞价请求pv"),

    //adx的ROI：广告消耗 / ADX消耗
    ADX_ROI("CONSUME", "ADX_CONSUME", "case when sum(consume) = 0 or sum(adxConsume) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(adxConsume) as numeric), 4) end", 4, "adxRoi", "adx的ROI：广告消耗 / ADX消耗"),

    //adx分成比例：ADX消耗 / 广告消耗
    ADX_COST_RATE("ADX_CONSUME", "CONSUME", "case when sum(adxConsume) = 0 or sum(consume) = 0 then 0 else round(cast(cast(sum(adxConsume) as float) / sum(consume) as numeric), 4) end", 4, "adxCostRate", "adx分成比例：ADX消耗 / 广告消耗"),

    //adx点击单价：ADX消耗 / ADX点击pv
    ADX_CLICK_PV_COST("ADX_CONSUME", "ADX_CLICK_PV", "case when sum(adxConsume) = 0 or sum(adxClickPV) = 0 then 0 else round(cast(cast(sum(adxConsume) as float) / sum(adxClickPV) as numeric), 4) end", 4, "adxClickPVCost", "adx点击单价：ADX消耗 / ADX点击pv"),

    //adx媒体激活单价：ADX消耗 / 后端转化类型-激活pv
    ADX_ACTIVATE_PV_COST("ADX_CONSUME", "ACTIVATE_PV", "case when sum(adxConsume) = 0 or sum(activatePV) = 0 then 0 else round(cast(cast(sum(adxConsume) as float) / sum(activatePV) as numeric), 4) end", 4, "adxActivatePVCost", "adx媒体激活单价：ADX消耗 / 后端转化类型-激活pv"),

    //ADX媒体二价率：ADX cpm消耗 / ADX出价
    ADX_SECOND_PRICE_RATE("ADX_CPM_CONSUME", "ADX_PRICE", "case when sum(adxCpmConsume) = 0 or sum(adxPrice) = 0 then 0 else round(cast(cast(sum(adxCpmConsume) as float) / sum(adxPrice) as numeric), 4) end", 4, "adxSecondPriceRate", "ADX媒体二价率：ADX cpm消耗 / ADX出价"),

    //DSP广告主二价率：DSP消耗 / DSP出价
    DSP_SECOND_PRICE_RATE("DSP_CONSUME", "DSP_PRICE", "case when sum(dspConsume) = 0 or sum(dspPrice) = 0 then 0 else round(cast(cast(sum(dspConsume) as float) / sum(dspPrice) as numeric), 4) end", 4, "dspSecondPriceRate", "DSP广告主二价率：DSP消耗 / DSP出价"),

    //DSP平均曝光出价：DSP出价 / ADX曝光pv
    AVG_DSP_EXPOSURE_PRICE("DSP_PRICE", "ADX_EXPOSURE_PV", "case when sum(dspPrice) = 0 or sum(adxExposurePV) = 0 then 0 else round(cast(cast(sum(dspPrice) as float) / sum(adxExposurePV) * 1000 as numeric), 4) end", 4, "avgDspExposurePrice", "DSP平均曝光出价：DSP出价 / ADX曝光pv"),

    //DSP曝光率：ADX曝光pv / DSP返回pv
    DSP_EXPOSURE_RATE("ADX_EXPOSURE_PV", "DSP_RETURN_PV", "case when sum(adxExposurePV) = 0 or sum(dspReturnPV) = 0 then 0 else round(cast(cast(sum(adxExposurePV) as float) / sum(dspReturnPV) as numeric), 4) end", 4, "dspExposureRate", "DSP曝光率：ADX曝光pv / DSP返回pv"),

    //adx竞价成功率：竞价成功pv / 竞价返回pv
    ADX_BID_SUCCESS_RATE("ADX_BID_SUCCESS_PV", "ADX_BID_RETURN_PV", "case when sum(adxBidSuccessPV) = 0 or sum(adxBidReturnPV) = 0 then 0 else round(cast(cast(sum(adxBidSuccessPV) as float) / sum(adxBidReturnPV) as numeric), 4) end", 4, "adxBidSuccessRate", "adx竞价成功率：竞价成功pv / 竞价返回pv"),

    //adx曝光率：ADX曝光pv / 竞价成功pv
    ADX_EXPOSURE_RATE("ADX_EXPOSURE_PV", "ADX_BID_SUCCESS_PV", "case when sum(adxExposurePV) = 0 or sum(adxBidSuccessPV) = 0 then 0 else round(cast(cast(sum(adxExposurePV) as float) / sum(adxBidSuccessPV) as numeric), 4) end", 4, "adxExposureRate", "adx曝光率：ADX曝光pv / 竞价成功pv"),

    //adx真实曝光率：ADX曝光pv / 竞价返回pv
    ADX_REAL_EXPOSURE_RATE("ADX_EXPOSURE_PV", "ADX_BID_RETURN_PV", "case when sum(adxExposurePV) = 0 or sum(adxBidReturnPV) = 0 then 0 else round(cast(cast(sum(adxExposurePV) as float) / sum(adxBidReturnPV) as numeric), 4) end", 4, "adxRealExposureRate", "adx真实曝光率：ADX曝光pv / 竞价返回pv"),

    //adx点击率：ADX点击pv / ADX曝光pv
    ADX_CLICK_RATE("ADX_CLICK_PV", "ADX_EXPOSURE_PV", "case when sum(adxClickPV) = 0 or sum(adxExposurePV) = 0 then 0 else round(cast(cast(sum(adxClickPV) as float) / sum(adxExposurePV) as numeric), 4) end", 4, "adxClickRate", "adx点击率：ADX点击pv / ADX曝光pv"),

    //adx竞价返回率：ADX竞价返回pv / ADX竞价请求pv
    ADX_BID_RETURN_RATE("ADX_BID_RETURN_PV", "ADX_BID_REQUEST_PV", "case when sum(adxBidReturnPV) = 0 or sum(adxBidRequestPV) = 0 then 0 else round(cast(cast(sum(adxBidReturnPV) as float) / sum(adxBidRequestPV) as numeric), 4) end", 4, "adxBidReturnRate", "adx竞价返回率：ADX竞价返回pv / ADX竞价请求pv"),

    //ADX唤起成功率：adx唤起成功pv / ADX点击pv
    ADX_WAKE_SUCCESS_RATE("ADX_WAKE_SUCCESS_PV", "ADX_CLICK_PV", "case when sum(adxWakeSuccessPV) = 0 or sum(adxClickPV) = 0 then 0 else round(cast(cast(sum(adxWakeSuccessPV) as float) / sum(adxClickPV) as numeric), 4) end", 4, "adxWakeSuccessRate", "ADX唤起成功率：adx唤起成功pv / ADX点击pv"),

    //ADX平均返回出价：ADX竞价返回出价汇总 / ADX竞价返回pv
    AVG_ADX_BID_RETURN_PRICE("ADX_BID_RETURN_PRICE", "ADX_BID_RETURN_PV", "case when sum(adxBidReturnPrice) = 0 or sum(adxBidReturnPV) = 0 then 0 else round(cast(cast(sum(adxBidReturnPrice) as float) / sum(adxBidReturnPV) * 1000 as numeric), 4) end", 4, "avgAdxBidReturnPrice", "ADX平均返回出价：ADX竞价返回出价汇总 / ADX竞价返回pv"),

    //DSP返回率：DSP返回pv / DSP请求pv
    DSP_RETURN_RATE("DSP_RETURN_PV", "DSP_REQUEST_PV", "case when sum(dspReturnPV) = 0 or sum(dspRequestPV) = 0 then 0 else round(cast(cast(sum(dspReturnPV) as float) / sum(dspRequestPV) as numeric), 4) end", 4, "dspReturnRate", "DSP返回率：DSP返回pv / DSP请求pv"),

    //DSP平均返回出价：DSP返回出价汇总 / DSP返回pv
    AVG_DSP_RETURN_PRICE("DSP_RETURN_PRICE", "DSP_RETURN_PV", "case when sum(dspReturnPrice) = 0 or sum(dspReturnPV) = 0 then 0 else round(cast(cast(sum(dspReturnPrice) as float) / sum(dspReturnPV) as numeric), 4) end", 4, "avgDspReturnPrice", "DSP平均返回出价：DSP返回出价汇总 / DSP返回pv"),

    //平均成本ECPM：ADX消耗 单位分 / ADX曝光pv * 1000
    ADX_APP_ECPM("ADX_CONSUME", "ADX_EXPOSURE_PV", "case when sum(adxConsume) = 0 or sum(adxExposurePV) = 0 then 0 else round(cast(cast(sum(adxConsume) as float) / sum(adxExposurePV) * 1000 as numeric), 4) end", 4, "adxAppEcpm", "平均成本ECPM：ADX消耗 单位分 / ADX曝光pv * 1000"),

    //平均支出ECPM：广告消耗（单位：分）/ ADX曝光pv * 1000
    ADX_ADVERT_ECPM("CONSUME", "ADX_EXPOSURE_PV", "case when sum(consume) = 0 or sum(adxExposurePV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(adxExposurePV) * 1000 as numeric), 4) end", 4, "adxAdvertEcpm", "平均支出ECPM：广告消耗（单位：分）/ ADX曝光pv * 1000"),

    //广告位每pv消耗：广告消耗 / 广告位访问pv
    SLOT_VISIT_COST("CONSUME", "SLOT_VISIT_PV", "case when sum(consume) = 0 or sum(slotVisitPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(slotVisitPV) as numeric), 4) end", 4, "slotVisitCost", "广告位每pv消耗：广告消耗 / 广告位访问pv"),

    //广告位每pv消耗(旧逻辑)：广告消耗 / 广告位访问pv(旧逻辑)
    SLOT_ACCESS_PV_COST("CONSUME", "SLOT_ACCESS_PV", "case when sum(consume) = 0 or sum(slotAccessPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(slotAccessPV) as numeric), 4) end", 4, "slotAccessPVCost", "广告位每pv消耗(旧逻辑)：广告消耗 / 广告位访问pv(旧逻辑)"),

    //转化上报成本：平台消耗(利润扣量后的消耗) / 转化上报pv
    EFFECT_REPORT_PV_COST("PLATFORM_CONSUME", "EFFECT_REPORT_PV", "case when sum(platformConsume) = 0 or sum(effectReportPV) = 0 then 0 else round(cast(cast(sum(platformConsume) as float) / sum(effectReportPV) as numeric), 4) end", 4, "effectReportPVCost", "转化上报成本：平台消耗(利润扣量后的消耗) / 转化上报pv"),

    //转化上报理论成本：平台理论消耗(利润扣量后的消耗) / 转化上报pv
    EFFECT_REPORT_PV_THEORY_COST("PLATFORM_THEORY_CONSUME", "EFFECT_REPORT_PV", "case when sum(platformTheoryConsume) = 0 or sum(effectReportPV) = 0 then 0 else round(cast(cast(sum(platformTheoryConsume) as float) / sum(effectReportPV) as numeric), 4) end", 4, "effectReportPVTheoryCost", "转化上报理论成本：平台理论消耗(利润扣量后的消耗) / 转化上报pv"),

    //转化上报现金成本：平台消耗(利润扣量后的消耗) / 转化上报pv * 1.15
    EFFECT_REPORT_PV_CASH_COST("PLATFORM_CONSUME", "EFFECT_REPORT_PV", "case when sum(platformConsume) = 0 or sum(effectReportPV) = 0 then 0 else round(cast(cast(sum(platformConsume) as float) / (sum(effectReportPV) * 1.15) as numeric), 4) end", 4, "effectReportPVCashCost", "转化上报现金成本：平台消耗(利润扣量后的消耗) / 转化上报pv * 1.15"),

    //转化上报CVR：转化上报pv / 券计费点击pv
    EFFECT_REPORT_PV_CVR("EFFECT_REPORT_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(effectReportPV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(effectReportPV) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "effectReportPVCvr", "转化上报CVR：转化上报pv / 券计费点击pv"),

    //目标转化CVR：目标转化pv / 券计费点击pv
    TARGET_EFFECT_PV_CVR("TARGET_EFFECT_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(targetEffectPV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(targetEffectPV) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "targetEffectPVCvr", "目标转化CVR：目标转化pv / 券计费点击pv"),

    //后端转化-付费ROI：后端转化类型-付费金额 / 广告消耗
    PAY_CONSUME_ROI("PAY_CONSUME", "CONSUME", "case when sum(payConsume) = 0 or sum(consume) = 0 then 0 else round(cast(cast(sum(payConsume) as float) / sum(consume) as numeric), 2) end", 2, "payConsumeRoi", "后端转化-付费ROI：后端转化类型-付费金额 / 广告消耗"),

    //后端转化-安装付费CVR：后端转化类型-付费pv / 后端转化类型-安装pv
    INSTALL_PAY_CVR("PAY_PV", "INSTALL_PV", "case when sum(payPV) = 0 or sum(installPV) = 0 then 0 else round(cast(cast(sum(payPV) as float) / sum(installPV) as numeric), 4) end", 4, "installPayCvr", "后端转化-安装付费CVR：后端转化类型-付费pv / 后端转化类型-安装pv"),

    //后端转化-关键行为CVR：后端转化类型-关键行为PV / 券计费点击pv
    KEY_ACTION_CVR("KEY_ACTION_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(keyActionPV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(keyActionPV) as float) / sum(couponEffectClickPV) as numeric), 4) end", 4, "keyActionCvr", "后端转化-关键行为CVR：后端转化类型-关键行为PV / 券计费点击pv"),

    //平均预估CTR: 预估ctr汇总 / 券曝光pv（pre_ctr > 0）
    AVG_PRE_CTR("SUM_PRE_CTR", "PRE_COUPON_EXPOSURE_PV", "case when sum(sumPreCtr) = 0 or sum(preCouponExposurePV) = 0 then 0 else round(cast(cast(sum(sumPreCtr) as float) / sum(preCouponExposurePV) as numeric), 4) end", 4, "avgPreCtr", "平均预估CTR: 预估ctr汇总 / 券曝光pv（pre_ctr > 0）"),

    //平均预估CVR: 预估cvr汇总 / 券计费点击pv(pre_cvr > 0)
    AVG_PRE_CVR("SUM_PRE_CVR", "PRE_COUPON_EFFECT_CLICK_PV", "case when sum(sumPreCvr) = 0 or sum(preCouponEffectClickPV) = 0 then 0 else round(cast(cast(sum(sumPreCvr) as float) / sum(preCouponEffectClickPV) as numeric), 4) end", 4, "avgPreCvr", "平均预估CVR: 预估cvr汇总 / 券计费点击pv(pre_cvr > 0)"),

    //adx万次请求广告消耗: 广告消耗 / ADX竞价请求pv * 10000
    ADX_BID_REQUEST_1W_CONSUME("CONSUME", "ADX_BID_REQUEST_PV", "case when sum(consume) = 0 or sum(adxBidRequestPV) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(adxBidRequestPV) * 10000 as numeric), 4) end", 4, "adxBidRequest1wConsume", "adx万次请求广告消耗: 广告消耗 / (ADX竞价请求pv / 10000)"),

    //平均预估校准因子: 预估校准因子汇总 / 预估校准因子-发券量pv
    AVG_PC_FACTOR_NEW("SUM_PC_FACTOR_NEW", "LAUNCH_FACTOR_COUPON_PV", "case when sum(sumPcFactorNew) = 0 or sum(launchFactorCouponPV) = 0 then 0 else round(cast(cast(sum(sumPcFactorNew) as float) / sum(launchFactorCouponPV) as numeric), 6) end", 6, "avgPcFactorNew", "平均预估校准因子: 预估校准因子汇总 / 预估校准因子-发券量pv"),

    //填表率: 携带手机号码的券请求uv（根据cid去重）/ 活动访问uv（根据cid去重）
    COUPON_REQUEST_PHONE_RATE("COUPON_REQUEST_PHONE_UV", "ACTIVITY_REQUEST_CID_UV", "case when sum(couponRequestPhoneUV) = 0 or sum(activityRequestCidUV) = 0 then 0 else round(cast(cast(sum(couponRequestPhoneUV) as float) / sum(activityRequestCidUV) as numeric), 4) end", 4, "couponRequestPhoneRate", "填表率: 携带手机号码的券请求uv（根据cid去重）/ 活动访问uv（根据cid去重）"),










    ;


    //指标-分子
    private final String numerator;

    //指标-分母
    private final String denominator;

    //指标sql代码段
    private final String metricSql;

    //小数点个数
    private final int pointLength;

    //结果数据对应的别名
    private final String resultFieldName;

    //指标解释说明
    private final String desc;

    //枚举列表
    public static final List<String> enumList = new ArrayList<>();

    //结果数据列表
    public static final Map<String, CalculateMetricDomain> resultFieldMap = new HashMap<>();

    TuiaCalculateMetricEnum(String numerator, String denominator, String metricSql, int pointLength, String resultFieldName, String desc) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.metricSql = metricSql;
        this.pointLength = pointLength;
        this.resultFieldName = resultFieldName;
        this.desc = desc;
    }

    public String getNumerator() {
        return numerator;
    }

    public String getDenominator() {
        return denominator;
    }

    public String getMetricSql() {
        return metricSql;
    }

    public int getPointLength() {
        return pointLength;
    }

    public String getResultFieldName() {
        return resultFieldName;
    }

    public String getDesc() {
        return desc;
    }

    static {
        TuiaCalculateMetricEnum[] values = TuiaCalculateMetricEnum.values();
        for (TuiaCalculateMetricEnum value : values) {
            enumList.add(value.toString());
        }

        //结果数据列表
        for (TuiaCalculateMetricEnum value : values) {
            String resultFieldName = value.getResultFieldName();
            String numeratorResultFieldName = TuiaMetricEnum.valueOf(value.getNumerator()).getResultFieldName();
            String denominatorResultFieldName = TuiaMetricEnum.valueOf(value.getDenominator()).getResultFieldName();
            int pointLength = value.getPointLength();

            resultFieldMap.put(resultFieldName, new CalculateMetricDomain(numeratorResultFieldName, denominatorResultFieldName, pointLength));
        }
    }

}
