package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata;

/**
 * @author liujianxue 2022-05-30
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaSaasGameFinishDetailDayEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    EVENT_NAME("event_name", "元事件名"),

    URL_HOST("url_host", "域名"),

    URL_PATH("url_path", "访问路径"),

    TRACKING_PROJECT_ID("tracking_project_id", "埋点方案id"),

    CONSUMER_ID("consumer_id", "用户唯一标识"),

    CONSUMER_TYPE("consumer_type", "用户类型"),

    CONSUMER_LEVEL("consumer_level", "用户身份，会员等级"),

    LOG_STATUS("log_status", "登录状态"),

    APP_ID("app_id", "媒体id"),

    EVENT_CONDITION("event_condition", "事件场景"),

    CHANNEL_SOURCE("channel_source", "来源渠道"),

    LIB_VERSION("lib_version", "sdk版本"),

    ACTIVITY_ID("activity_id", "活动id"),

    ACTIVITY_TYPE("activity_type", "活动类型"),

    ACTIVITY_CODE("activity_code", "活动玩法"),

    ACTIVITY_NAME("activity_name", "活动标题"),

    CREDITS_BRING("credits_bring", "携带积分数"),

    GAME_LEVEL("game_level", "游戏关卡"),

    GAME_GOAL("game_goal", "游戏得分"),

    GAME_TIME("game_time", "游戏时长"),

    GAME_RANK("game_rank", "游戏排名"),


    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DuibaSaasGameFinishDetailDayEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
