package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata_offline;

public enum AdxLogDetailMonthEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳，格式化成分钟粒度"),

    INNER_GROUP("inner_group", "公司业务分类，大类"),

    INNER_TYPE("inner_type", "日志分类，小类"),

    GROUP_ID("group_id", "推广组id"),

    RESOURCE_ID("resource_id", "资源位id"),

    IDEA_ID("idea_id", "创意计划id"),

    IDEA_MATERIAL_ID("idea_material_id", "创意素材id"),

    APP_ID("app_id", "媒体ID"),

    SLOT_ID("slot_id", "广告位id"),

    EXT_APP_ID("ext_app_id", "外部联盟媒体id"),

    EXT_SLOT_ID("ext_slot_id", "外部联盟广告位id"),

    //adx竞价环节，还不涉及到广告计划，设计多余了，先排除掉
//    ADVERT_ID("advert_id", "广告id"),

    PACKAGE_NAME("package_name", "媒体包名"),

    WAKE_UP_STATUS("wake_up_status", "唤起是否成功 0-成功，1-失败"),

    BILL_TYPE("bill_type", "计费类型 0-cpc 1-cpm"),

    FEE("fee", "adx计费金额，单位：除以10000000 等于分"),

    DSP_TASK_ID("dsp_task_id", "dsp任务id"),

    OS_TYPE("os_type", "操作系统类型 android/ios"),





    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    AdxLogDetailMonthEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }


}
