package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata_offline;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaAccessLogOfflineEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    DATA_MD5("data_md5", "唯一键"),

    URL_HOST("url_host", "域名"),

    URL_PATH("url_path", "接口方法，已全部转换成小写"),

    HTTP_METHOD("http_method", "http方法类型，GET/POST"),

    TENTER("tenter", "广告位参数，SOW：来自广告位首次访问"),

    APP_ID("app_id", "媒体id"),

    SLOT_ID("slot_id", "广告位id"),

    ACTIVITY_ID("activity_id", "活动id"),

    APP_SOURCE("app_source", "创建App的来源  0：积分商城（兑吧） 1：广告平台（推啊）"),

    APP_LEVEL("app_level", "媒体性质 1-在线KA,2-潜力KA,3-普通媒体"),

    DEVELOPER_ID("developer_id", "媒体账号id"),

    APP_FIRST_TRADE_ID("app_first_trade_id", "媒体一级行业"),

    APP_SECOND_TRADE_ID("app_second_trade_id", "媒体二级行业"),

    APP_FLOW_TAG("app_flow_tag", "媒体流量标签"),

    SLOT_MATERIAL_ID("slot_material_id", "广告位素材id"),

    SLOT_MATERIAL_PUT_TYPE("slot_material_put_type", "广告位素材投放方式 0-人工 1-算法1.0 2-算法2.0 3-算法返回null降级"),

    ACTIVITY_SOURCE("activity_source", "活动来源 0-兑吧 1-推啊"),

    ACTIVITY_TYPE("activity_type", "广告位投放活动类型 1-常规活动，2-自定义活动（非深度），3-直投页，4-深度互动，5-原生互动，6-激励互动"),

    ACTIVITY_PUT_TYPE("activity_put_type", "活动投放方式-大类 1:测试 2:算法 3:灰度测试 4:手投"),

    ACTIVITY_RELEASE_SUB_MODE("activity_release_sub_mode", "广告位上直投活动的投放方式 仅投1 优投人工2 优投算法3 纯算法4 其他0"),

    ACTIVITY_STAGE("activity_stage", "活动阶段 1：广告位访问 2：活动访问 3：活动参与"),

    FLOW_TYPE("flow_type", "流量类型 1:sdk 2:adx 3:其它"),

    DPM_B("dpm_b", "埋点"),

    DSM2_A("dsm2_a", "资源位类型 1-广告位直投,2-浮标,3-推荐弹层,4-一次返回拦截,5-谢谢参与推荐弹层 7-二次返回拦截 9-三次返回拦截")





    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DuibaAccessLogOfflineEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
