package cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DeviceTagDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.form.DMPForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.nezha.alg.feature.vo.ItemProfileFeature;
import cn.com.duiba.nezha.alg.feature.vo.SlotActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteDMPService {

    /**
     * 获取设备号对应的标签和人群包
     * @param dmpForm 入参
     * @return 标签和人群包
     */
    DeviceTagDto getDeviceTag(DMPForm dmpForm);

    /**
     * 获取设备号对应的用户行为数据
     * @param dmpForm 入参
     * @return 行为数据
     */
    DeviceTagDto getDeviceActionData(DMPForm dmpForm);

    /**
     * 获取设备号对应的人群包
     * @param dmpForm 入参
     * @return 人群包
     */
    DeviceTagDto getDevicePkg(DMPForm dmpForm);

    /**
     * 获取设备号对应的外部人群包
     * @param dmpForm 入参
     * @return 人群包
     */
    DeviceTagDto getDeviceExtTag(DMPForm dmpForm);

    /**
     * 获取设备号的
     * @param dmpForm 入参
     * @return 设备特征
     */
    UserActFeature getDeviceFeature(DMPForm dmpForm);

    /**
     * 获取设备号对应的<item,score>
     * item advertId
     * @param dmpForm 入参
     *
     */
     Map<Long,Double> getAdvertScore(DMPForm dmpForm);

    /**
     * 获取imei特征
     * @param dmpForm 入参
     * @return imei特征
     */
    UserProfileFeature getImeiFeature(DMPForm dmpForm);


    /**
     * 获取imei标签
     * @param dmpForm 入参
     * @return imei标签
     */
    String getImeiTag(DMPForm dmpForm);


    /**
     * 获取商品特征
     * @return 商品画像
     */
    List<ItemProfileFeature> getItemFeature();

    /**
     * 获取广告位行为特征
     * @return行为画像
     */
    List<SlotActFeature> getSlotBehFeature(int type);

    /**
     * 获取广告位行为特征
     * @return行为画像
     */
    SlotActFeature getSlotBehaveFeature(String slotId);


}
