package cn.com.duiba.bigdata.filtration.service.api.remoteservice;


import cn.com.duiba.bigdata.filtration.service.api.dto.req.DataSyncNoticeReq;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 接收业务数据更新同步通知服务
 */
@AdvancedFeignClient
public interface RemoteDataSyncNoticeService {

    /**
     * 业务操作数据同步通知
     *
     * @param dataSyncNoticeReq
     * @return
     */
    public Boolean notice(DataSyncNoticeReq dataSyncNoticeReq);

    /**
     * 定时任务获取可投广告列表，进行索引维护
     *
     * @param validAdvertIds
     * @return
     */
    public Boolean syncValidAdvertList(List<Long> validAdvertIds);

}
