package cn.com.duiba.bigdata.inner.service.api.remoteservice;

import cn.com.duiba.bigdata.common.biz.dto.DruidResultDto;
import cn.com.duiba.bigdata.inner.service.api.form.HologresQueryForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author xugf 2020-07-03
 */
@AdvancedFeignClient
public interface RemoteHologresService {

    /**
     * 根据传入的条件，自动拼装sql，从hologres中查询数据
     *
     * @param form 查询条件
     * @return DruidResultDto
     */
    List<DruidResultDto> query(HologresQueryForm form) throws Exception;

    /**
     * 根据传入的sql，从hologres中查询数据
     *
     * @param sql 查询sql
     * @return jsonArrayStr
     */
    String queryHoloSql(String sql) throws Exception;
}
