package cn.com.duiba.bigdata.inner.service.api.dto;

import lombok.Data;

import java.io.Serializable;

@Data
public class SlotFeatureDto implements Serializable {
    private static final long serialVersionUID = -163060906641491916L;

    private Long slotId;  // 广告位id

    // 发券
    private String launchCntRatioTrade; // f210001 历史不同行业上发券占比
    private String launchCntRatioAccount;   // f210002 历史不同广告主上发券占比
    private String weekLaunchCntRatioTrade; // f210003 一周内不同行业上发券占比
    private String weekLaunchCntRatioAccount;   // f210004  一周内不同广告主上发券占比

    // 点击
    private String clickCntRatioTrade;  // f211001  历史不同行业上点击占比
    private String clickCntRatioAccount;    // f211002  历史不同广告主上点击占比
    private String weekClickCntRatioTrade;  // f211003  一周内不同行业上点击占比
    private String weekClickCntRatioAccount;    // f211004  一周内不同广告主上点击占比

    private String ctrTrade;    // f212001  历史不同行业上点击率
    private String ctrAccount;  // f212002  历史不同广告主上点击率
    private String weekCtrTrade;    // f212003  一周内不同行业上点击率
    private String weekCtrAccount;  // f212004  一周内不同广告主上点击率

    // 前端转化
    private String convertCntRatioTrade;    // f213001  历史不同行业上转化占比
    private String convertCntRatioAccount;  // f213002  历史不同广告主上转化占比
    private String weekConvertCntRatioTrade;    // f213003  一周内不同行业上转化占比
    private String weekConvertCntRatioAccount;  // f213004  一周内不同广告主上转化占比

    private String cvrTrade;    // f214001  历史不同行业上转化率
    private String cvrAccount;  // f214002  历史不同广告主上转化率
    private String weekCvrTrade;    // f214003  一周内不同行业上转化率
    private String weekCvrAccount;  // f214004  一周内不同广告主上转化率

    //素材数据
    private String exposureMaterialSdk7;//素材过去7天在广告位上的曝光次数,
    private String exposureMaterialHighDuration28; //历史入口各素材曝光频繁时段（凌晨0、早上1、上午2、中午3、下午4、晚上5、深夜6）,
    private String clickMaterialSdk7; //素材过去7天在广告位上的点击次数,
    private String clickMaterialHighDuration28; //'历史入口各素材点击频繁时段（凌晨0、早上1、上午2、中午3、下午4、晚上5、深夜6)',
    private String promoteChangeMaterialSdk7; // '历史7天各素材上的前端转化',
    private String promoteChangeMaterialSdk28;//'历史28天各素材上的前端转化',
    private String backChangeMaterialSdk7;// '历史7天后端转化次数 ',
    private String backChangeMaterialSdk28;// '历史28天后端转化次数',
    private String topFeeExposureMaterial;// 'top50每素材曝光消耗',


    //素材二期特征
    //点击
    private String sdkMaterialTagClickCnt7; //各素材标签的点击次数 （7天）
    private String sdkMaterialTagClickCnt28;//各素材标签的点击次数 （历史）
    private String sdkSkinTypeJoinCnt7;//各皮肤类型的点击次数 （7天）
    private String sdkSkinTypeJoinCnt28;//各皮肤类型的点击次数 （历史）
    private String sdkActPrizeTagJoinCnt7;//各奖品标签的点击次数 （7天）
    private String sdkActPrizeTagJoinCnt28;//各奖品标签的点击次数 （历史）
    //曝光
    private String sdkMaterialTagExposeCnt7;//各素材标签的曝光次数 （7天）
    private String sdkMaterialTagExposeCnt28;//各素材标签的曝光次数 （历史）
    private String sdkSkinTypeRequestCnt7;//各皮肤类型的曝光次数 （7天）
    private String sdkSkinTypeRequestCnt28;//各皮肤类型的曝光次数 （历史）
    private String sdkActPrizeTagRequestCnt7;//各奖品标签的曝光次数 （7天）
    private String sdkActPrizeTagRequestCnt28;//各奖品标签的曝光次数 （历史）

    //广告转化特征
    private String weekExposeTradeCnt;           //一周内不同行业上券曝光数
    private String weekExposeAccountCnt;           //一周内不同广告主上券曝光数
    private String weekExposeAdvert;           //一周内不同广告上券曝光数
    private String weekClickTradeCnt;           //一周内不同行业上有效券点击数
    private String weekClickAccountCnt;           //一周内不同广告主上有效券点击数
    private String weekClickAdvertCnt;           //一周内不同广告上有效券点击数
    private String weekConversionTradeCnt;           //一周内不同行业上转化数
    private String weekConversionAccountCnt;           //一周内不同广告主上转化数
    private String weekConversionAdvertCnt;           //一周内不同广告上转化数

    //API流量
    private String apiExposureMaterialHighDuration28; //'api历史入口各素材曝光频繁时段（凌晨0、早上1、上午2、中午3、下午4、晚上5、深夜6）',
    private String apiClickMaterialHighDuration28;    //'api历史入口各素材点击频繁时段（凌晨0、早上1、上午2、中午3、下午4、晚上5、深夜6)',
    private String apiPromoteChangeMaterial7;          //'api历史7天各素材上的前端转化',
    private String apiPromoteChangeMaterial28;         //'api历史28天各素材上的前端转化',
    private String apiBackChangeMaterial7;             //'api历史7天后端转化次数',
    private String apiBackChangeMaterial28;            //'api历史28天后端转化次数',
    private String apiMaterialTagExposeCnt7;          //'api7天素材各标签的曝光次数',
    private String apiMaterialTagExposeCnt28;         //'api28天素材各标签的曝光次数',
    private String apiMaterialTagClickCnt7;           //'api7天素材各标签的点击次数',
    private String apiMaterialTagClickCnt28;          //'api28天素材各标签的点击次数',
    private String apiSkinTypeRequestCnt7;            //'api7天各活动皮肤类型的曝光次数',
    private String apiSkinTypeRequestCnt28;           //'api28天各活动皮肤类型的曝光次数',
    private String apiSkinTypeJoinCnt7;               //'api7天各活动皮肤类型的参与次数',
    private String apiSkinTypeJoinCnt28;              //'api28天各活动皮肤类型的参与次数',
    private String apiActPrizeTagRequestCnt7;        //'api7天各活动奖品标签的曝光次数',
    private String apiActPrizeTagRequestCnt28;       //'api28天各活动奖品标签的曝光次数',
    private String apiActPrizeTagJoinCnt7;           //'api7天各活动奖品标签的参与次数',
    private String apiActPrizeTagJoinCnt28;          //'api28天各活动奖品标签的参与次数',
    private String apiTopFeeExposureMaterial;          //'api流量top50每素材曝光消耗,
}