package cn.com.duiba.bigdata.inner.service.api.enums;

/**
 * @author zhangzichen
 * 人群包有效状态枚举
 */

public enum ValidStateEnum {

    //人群包有效状态: 计算中 1，计算完成 2，失败 3，更新中 4，更新完成 5，可查询 6
    THIRD_PARTY_DMP_CREATE(0, "THIRD_PARTY_DMP_CREATE", "第三方创建人群包"),
    CREATING(1, "CREATING", "计算中"),
    AVAILABLE(2, "AVAILABLE", "计算完成"),
    FAIL(3, "FAIL", "失败"),
    UPDATE(4, "UPDATE", "更新中"),
    UPDATE_COMPLETED(5, "UPDATE_COMPLETED", "更新完成"),
    FOR_SEARCH(6, "FOR_SEARCH", "可查询"),
    ;
    private Integer type;

    private String code;

    private String desc;

    ValidStateEnum(Integer type, String code, String desc) {
        this.type = type;
        this.code = code;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
