package cn.com.duiba.bigdata.inner.service.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xugf 2022-12-21
 * 特征元数据
 */
@Data
public class TBAlgFeatureMetaConfigDto implements Serializable {
    private static final long serialVersionUID = 5456754162046734357L;

    //主键
    private Long id;

    //特征id
    private String featureId;

    //特征名称
    private String featureName;

    //编码类型 1:单值特征 2:多值特征 3:浮点特征
    private Integer codeType;

    //场景
    private String featureScene;

    //分隔符
    private String splitChar;

    //特征描述
    private String featureDesc;

    //特征是否多值 1代表多值，0代表非多值
    private Integer multiValue;

    //稠密空间长度
    private Long denseLen;

    //特征是否生效，默认不生效（0:关闭 1:开启）
    private Integer featureDelete;

    //特征创建人ssoId
    private Long adminId;

    //特征类型：OTHER(0, "其他"), ADVERT(1, "广告侧"), CONSUMER(2, "用户侧"), TRAFFIC(3, "流量上下文侧"),APP(4, "媒体侧"), STATISTICS(5, "统计衍生")
    private Integer encodeType;

    //特征值的生命周期，过期后特征值会被清理，默认30天，单位：天
    private Integer lifeCycle;

}
