package cn.com.duiba.bigdata.inner.service.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xugf
 * druid 返回结果转化的对象
 */
@Data
public class TestPlatformDataDto implements Serializable {

    private static final long serialVersionUID = -4453678442733558806L;

    //维度
    private String timeSegment;//统计时间段 格式(yyyy-MM-dd HH:mm:ss,跨天yyyy-MM-dd)
    private String slotId;//广告位id
    private String testPlanId;// '实验计划ID',
    private String testGroupId;// '实验组ID',

    //指标
    private Long activityRequestUv;// '活动访问UV',
    private Long activityParticipateUv;//  '活动参与UV',
    private Long slotExposurePv;// '素材（广告位）曝光PV',
    private Long slotClickPv;// '素材（广告位）点击pv',
    private Long activityRequestPv;// '活动访问PV',
    private Long activityParticipatePv;// '活动参与PV',
    private Long advertRequestTotal;// '券请求PV',
    private Long advertRequestUv;// '券请求UV',
    private Long advertLaunchTotal;// '发券PV',
    private Long payAdvertLaunchTotal;// '付费券发券PV',
    private Long freeAdvertLaunchTotal;// '免费券发券PV',
    private Long riskCheatAdvertLaunchTotal;// '作弊发券pv',
    private Long advertExposureTotal;// '券曝光PV',
    private Long advertEfClickTotal;//  '券计费点击PV',
    private Long advertConsumeAmtTotal;// '券消耗金额(分)',
    private Long advertPromoteExposePv;// '落地页曝光PV',
    private Long advertPromoteChangePv;// '落地页转化PV',
    private Long targetEffectConsume;// '目标转化消耗',
    private Long targetEffectPv;//  "目标转化pv",

    //理论目标转化消耗
    private Long cpaTargetEffectConsume;

    //美团adx指标,
    private Double meituanAdxConsume;// 美团adx媒体消耗金额(分)",
    private Long meituanAdxBidFeeTotal;// 胜出媒体出价总和(1价)(分)",
    private Long meituanAdxAdvertFeeTotal;// 美团adx广告出价总和(分)",
    private Long meituanAdxExposurePv;// 美团adx曝光pv",
    private Long meituanAdxClickPv;// 美团Adx点击pv",
    private Long meituanAdxExposureUv;// 美团adx曝光uv",
    private Long meituanAdxClickUv;// 美团Adx点击uv",
    private Long meituanAdxBidRequestPv;// 美团adx竞价请求pv",
    private Long meituanAdxBidSuccessPv;// 美团adx竞价成功pv",
    private Long meituanAdxBidReturnPv;// 美团adx竞价返回pv",
 


    //后端转化类型-安装pv
    private Long installPv;

    //后端转化类型-安装uv
    private Long installUv;

    //后端转化类型-启动pv
    private Long startPv;

    //后端转化类型-启动uv
    private Long startUv;

    //后端转化类型-注册pv
    private Long registePv;

    //后端转化类型-注册uv
    private Long registeUv;

    //后端转化类型-激活pv
    private Long activatePv;

    //后端转化类型-激活uv
    private Long activateUv;

    //后端转化类型-登录pv
    private Long loginPv;

    //后端转化类型-登录uv
    private Long loginUv;

    //后端转化类型-付费pv
    private Long payPv;

    //后端转化类型-付费uv
    private Long payUv;

    //后端转化类型-进件pv
    private Long entryPv;

    //后端转化类型-进件uv
    private Long entryUv;

    //后端转化类型-完件pv
    private Long finishPv;

    //后端转化类型-完件uv
    private Long finishUv;

    //后端转化类型-签收pv
    private Long signPv;

    //后端转化类型-签收uv
    private Long signUv;

    //后端转化类型-拒签pv
    private Long denyPv;

    //后端转化类型-拒签uv
    private Long denyUv;

    //后端转化类型-出单pv
    private Long orderPv;

    //后端转化类型-订单取消pv
    private Long cancelPv;

    //预估ctr
    private Double preCtr;

    //预估cvr
    private Double preCvr;

    //审核通过pv
    private Long checkPassPv;

}
