package cn.com.duiba.bigdata.inner.service.api.remoteservice;

import cn.com.duiba.bigdata.inner.service.api.dto.TBAlgFeatureCodeConfigDto;
import cn.com.duiba.bigdata.inner.service.api.dto.TBAlgFeatureMetaConfigDto;
import cn.com.duiba.bigdata.inner.service.api.dto.TBAlgorithmModelDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author xugf 2022-12-21
 * 特征编码服务
 */
@AdvancedFeignClient
public interface RemoteAlgFeatureCodeService {

    /**
     * 根据模型id，获取模型的配置元数据
     * @param modelId 模型id
     * @return 模型元数据
     */
    TBAlgorithmModelDto getModelMetadata(String modelId);

    /**
     * 根据模型id，获取模型使用的所有特征id
     *
     * @param modelId 模型id
     * @return 特征id列表
     */
    List<String> getFeatureIdList(String modelId);

    /**
     * 根据特征id列表，获取特征的配置元数据
     * @param featureIds 特征id列表
     * @return 特征元数据集合
     */
    List<TBAlgFeatureMetaConfigDto> getFeatureMetadata(List<String> featureIds);

    /**
     * 根据特征id列表，获取特征值和稠密编码
     *
     * @param featureIds 特征id列表
     * @return 特征编码集合
     */
    List<TBAlgFeatureCodeConfigDto> getFeatureIdAndCode(List<String> featureIds);

}
