package cn.com.duiba.bigdata.inner.service.api.remoteservice;

import cn.com.duiba.bigdata.inner.service.api.dto.ReportAuthDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author xugf
 * 火眼权限管控功能
 */
@AdvancedFeignClient
public interface RemoteReportAuthService {

    /**
     * 查询火眼报表权限
     * @param ssoId sso系统对应的员工id
     * @param chartId 火眼报表id
     * @param startTime 查询报表数据-开始时间 格式：yyyy-MM-dd
     * @param endTime 查询报表数据-结束时间 格式：yyyy-MM-dd
     * @return ReportAuthDto
     */
    ReportAuthDto queryChartAuth(Long ssoId, Long chartId, String startTime, String endTime);

}
