package cn.com.duiba.bigdata.online.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhx 2022-06-09
 */
@Data
public class DuibaRiskSaasDto implements Serializable {

    private static final long serialVersionUID = 235146216900768380L;

    //用户id
    private String consumerId;

    //商品id
    private String itemId;

    //ua或者os，全部用ua字段表示
    private String uaMd5;

    //用户ip
    private String ip;

    //用户ip前3段地址
    private String ip3;

    //媒体id
    private String appId;

    //第三方账号
    private String accountId;

    //活动id 以活动长id为主，如果没有长id，取活动短id
    private String activityId;

    //活动类型
    private String activityType;

    //天粒度的时间
    private String dayTime;

    //访问次数
    private Long pv = 0L;

    //用户关联的ip个数（去重）
    private Long ipUv = 0L;

    //用户关联的ua个数（去重）
    private Long uaUv = 0L;

    //支付宝关联的用户id个数（去重）
    private Long consumerUv = 0L;

    //商品Pv
    private Long itemPv = 0L;

    //中奖
    private Long winPv = 0l;

    //游戏完成次数
    private Long gamePv = 0l;

    //助力发起次数
    private Long invitePv = 0l;

    //积分消耗量
    private Long costSum = 0l;

    //分享次数
    private Long sharePv = 0l;

    //积分获取量
    private Long creditsSum = 0l;

    //充值账号数据
    private Long accountUv = 0l;

    //请求pv
    private Long visitPv = 0l ;

    //参与pv
    private Long joinPv = 0l;

    //ip3占比
    private Double ip3Rate = 0.0;

    //活动参与成功率
    private Double activitySuccessRate = 0.0;

    //中奖同一奖品数量
    private Long prizeUv = 0l;


}
