package cn.com.duiba.bigdata.online.service.api.remoteservice;


import cn.com.duiba.bigdata.online.service.api.dto.AdxDataDto;
import cn.com.duiba.bigdata.online.service.api.dto.OcpcExploreDto;
import cn.com.duiba.bigdata.online.service.api.dto.OcpcExploreHourDto;
import cn.com.duiba.bigdata.online.service.api.dto.OcpcExploreValueDto;
import cn.com.duiba.bigdata.online.service.api.form.AdxForm;
import cn.com.duiba.bigdata.online.service.api.form.OcpcExploreForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;


@AdvancedFeignClient
public interface RemoteAdxDataService {

    //实时数据
    AdxDataDto getTodayData(AdxForm form);

    //离线数据 7天
    AdxDataDto get7DayData(AdxForm form);


    //20220727 add 资源位历史数据
    AdxDataDto get7DayResourceData(AdxForm form);

    /**
     * 获取广告位探价因子
     *
     * @param extSlotId   广告位id
     * @param adxAppId adx媒体id
     * @return 分桶对应的探价因子
     */
    Map<String, Double> getAdxPriceFactor(String extSlotId, String adxAppId);

    /**
     * 获取探价id的探价因子
     * @param explortId   探价id
     */
    Map<String, Double> getAdxPriceIdFactor(Long explortId);


}
