package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.bigdata.online.service.api.dto.DuibaXingSuAppActivityDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * 兑吧--星速台活动
 * @author
 *
 */
@AdvancedFeignClient
public interface RemoteDuibaXingSuAppActivityService {

    /**
     * 5分钟 appId和actitvityId
     * @param appId
     * @param activityId
     * @param curDate
     * @return
     */
    List<DuibaXingSuAppActivityDto> queryXingSu5minuteAppActivityData(String appId, String activityId, Date curDate);

    /**
     * 5分钟 appId
     * @param appId
     * @param curDate
     * @return
     */
    List<DuibaXingSuAppActivityDto> queryXingSu5minuteAppIdData(String appId, Date curDate);

    /**
     * appId 和 activity
     * @param appId
     * @param activityId
     * @param curDate
     * @return
     */
    List<DuibaXingSuAppActivityDto> queryXingSuSumAppActivityData(String appId, String activityId, Date curDate);

    /**
     * sum appId
     * @param appId
     * @param curDate
     * @return
     */
    List<DuibaXingSuAppActivityDto> queryXingSuSumAppData(String appId, Date curDate);

    /**
     * sum appId
     * @param appId
     * @param curDate
     * @return
     */
    List<DuibaXingSuAppActivityDto> queryXingSuSumHistAppActivityData(String appId, String activityId, Date curDate);


}

