package cn.com.duiba.bigdata.online.service.api.form;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xugf 2019-10-12
 */
@Data
public class DuibaRiskForm implements Serializable {
    private static final long serialVersionUID = -6386228437375877L;

    //需要查询的维度类型 具体查看TuiaRiskDimTypeKeys类
    private String dimType;

    //用户id
    private String consumerId;

    //天粒度的时间 格式：yyyyMMdd
    private String dayTime;

    //媒体id
    private String appId;

    //广告位
    private String slotId;

    //活动id
    private String activityId;

    //活动类型
    private String activityType;

    //支付宝账号
    private String alipayAccount;

    //ua或者os对应的md5值，注意：ua或者os需要先转成小写后再取md5
    private String uaMd5;

    //ip地址
    private String ip;

    //ip地址前3段
    private String ip3;

    //分钟粒度时间集合 格式：yyyyMMddHHmm
    private List<String> minuteTimeList;
}
