package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.bigdata.online.service.api.dto.ActivityRecomDto;
import cn.com.duiba.bigdata.online.service.api.dto.ExcellentActivityDto;
import cn.com.duiba.bigdata.online.service.api.form.ActivityRecomForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Set;

/**
 * 广告位活动推荐
 * @author xugf 2019-09-02
 */
@AdvancedFeignClient
public interface RemoteSlotActivityRecommendService {

    /**
     * 获取推荐的活动id
     * @param form 入参 算法版本类型，广告位id
     * @return 活动id，是否降级
     */
    ActivityRecomDto getAlgActivityDto(ActivityRecomForm form);

    /**
     * 移除本次海选池中的活动id(失效的活动)
     * @param type 算法版本
     * @param slotId 广告位id
     * @param activityId 活动id
     * @return true 表示移除成功 false 表示移除失败
     */
    Boolean removeMatchActivityId(String type, Long slotId, Long activityId);

    /**
     * 活动推荐4.0 获取优质活动，数据一天更新一次
     * @param curDate 日期 格式: yyyy-MM-dd
     * @return 优质活动列表
     */
    List<ExcellentActivityDto> getExcellentActivityList(String curDate);


    //------------------------------废弃------------------------------
    /**
     * 获取推荐的活动id(算法4.0版本)
     * @param slotId 广告位id
     * @return 活动id
     */
    Long getActivityIdForAlg40(Long slotId);

    /**
     * 获取推荐的活动id(算法4.0 cvr优化版本)
     * @param slotId 广告位id
     * @return 活动id
     */
    Long getActivityIdForAlg40CVR(Long slotId);

    /**
     * 获取推荐的活动id(算法4.0版本，对用户当天参与过的活动进行过滤)
     * @param slotId 广告位id
     * @param activityIdSet 用户当天参与过的活动列表
     * @return 活动id
     */
    Long getDistinctActivityIdForAlg40(Long slotId, Set<Long> activityIdSet);

    /**
     * 移除本次海选池中的活动id(算法4.0版本)
     * @param slotId 广告位id
     * @param activityId 活动id
     * @return true 表示移除成功 false 表示移除失败
     */
    Boolean removeActivityIdForAlg40(Long slotId, Long activityId);

    /**
     * 移除本次海选池中的活动id(算法4.0 cvr优化版本)
     * @param slotId 广告位id
     * @param activityId 活动id
     * @return true 表示移除成功 false 表示移除失败
     */
    Boolean removeActivityIdForAlg40CVR(Long slotId, Long activityId);
}
