package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.bigdata.online.service.api.dto.TuiaRiskDto;
import cn.com.duiba.bigdata.online.service.api.dto.TuiaRiskMergeDto;
import cn.com.duiba.bigdata.online.service.api.form.TuiaRiskForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteTuiaRiskService {

    /**
     * 查询指标数据（合并后的结束数据）
     * @param formList 入参
     * @return TuiaRiskMergeDto
     */
    TuiaRiskMergeDto getMergeData(List<TuiaRiskForm> formList);
    
    /**
     * 查询用户相关基础指标
     *
     * @param consumerId 用户id
     * @param dayTime    天粒度时间 格式：yyyyMMdd
     * @return TuiaRiskDto实例
     */
    TuiaRiskDto getConsumerInfo(String consumerId, String dayTime);

    /**
     * 查询订单相关基础指标(批量查询)
     *
     * @param consumerId 用户id
     * @param orderList  订单列表
     * @return List<TuiaRiskDto>
     */
    List<TuiaRiskDto> getOrderInfoBatch(String consumerId, List<String> orderList);

    /**
     * 查询ip相关基础指标(批量查询)
     *
     * @param ipList  ip列表
     * @param dayTime 天粒度时间 格式：yyyyMMdd
     * @return List<TuiaRiskDto>
     */
    List<TuiaRiskDto> getIPInfoBatch(List<String> ipList, String dayTime);

    /**
     * 查询ip前3段地址相关基础指标(批量查询)
     *
     * @param ip3List ip前3段地址列表
     * @param dayTime 天粒度时间 格式：yyyyMMdd
     * @return List<TuiaRiskDto>
     */
    List<TuiaRiskDto> getIP3InfoBatch(List<String> ip3List, String dayTime);

    /**
     * 查询ip列表在广告位上的基础指标(批量查询)
     *
     * @param ipList  ip列表
     * @param slotId  广告位id
     * @param dayTime 天粒度时间 格式：yyyyMMdd
     * @return List<TuiaRiskDto>
     */
    List<TuiaRiskDto> getIPSlotInfoBatch(List<String> ipList, String slotId, String dayTime);

    /**
     * 查询设备相关基础指标(批量查询)
     *
     * @param deviceList 设备列表
     * @param dayTime    天粒度时间 格式：yyyyMMdd
     * @return List<TuiaRiskDto>
     */
    List<TuiaRiskDto> getDeviceInfoBatch(List<String> deviceList, String dayTime);

    /**
     * 查询ua相关基础指标(批量查询)
     *
     * @param uaMd5List ua的md5列表 注意：ua需要先转成小写后再取md5
     * @param dayTime   天粒度时间 格式：yyyyMMdd
     * @return List<TuiaRiskDto>
     */
    List<TuiaRiskDto> getUAInfoBatch(List<String> uaMd5List, String dayTime);
}
