package cn.com.duiba.bigdata.online.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 冷启动留存阶段
 * @auto zhx
 */
@Data
public class CoolStageValueDto implements Serializable {


    private static final long serialVersionUID = 5035315577626349004L;

    /**
     * 平均转化数
     */
    private Map<String, Long> avgBackendCntMap = new HashMap<>();

    /**
     * 平均消耗
     */
    private Long avgChargeFees = 0l;

    /**
     * 平均单价
     */
    private Double avgBillPrice = 0.0;

    /**
     * 有效点击（计费点击）
     */
    private Long clickCnt = 0l;

    /**
     * 消耗指标
     */
    private Long chargeFees = 0l;

    /**
     * 转化次数
     */
    private Map<String, Long> backendCntMap = new HashMap<>();

    /**
     * 成本
     */
    private Long aFee =0l;


    /**
     * 计费单价
     */
    private Double billPrice = 0.0;

    /**
     * 平均出价
     */
    private Double avgBill = 0.0;

    /**
     * 平均预估cvr
     */
    private Double avgCvr = 0.0;



}
