package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.bigdata.online.service.api.dto.AdvertStatDto;
import cn.com.duiba.bigdata.online.service.api.dto.AdxPutConsumeDto;
import cn.com.duiba.bigdata.online.service.api.form.AdvertStatForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * duiba_adb 广告线表 数据查询接口
 *
 * @author xugf
 */
@AdvancedFeignClient
public interface RemoteAdvertStatService {

    /**
     * 各维度数据
     *
     * @param formList 入参
     * @param dayType  1-当天+昨天 2-过去3天
     * @return List<AdvertStatDto>
     */
    List<AdvertStatDto> getDayAdvertStatData(List<AdvertStatForm> formList, String dayType);

    /**
     * adx直投广告消耗数据
     *
     * @param advertIds 广告集合
     * @return Map<Long, AdxPutConsumeDto>
     */
    Map<Long, AdxPutConsumeDto> getAdxPutConsumeData(List<Long> advertIds);

}
