package cn.com.duiba.bigdata.recommender.service.api.remoteservice;

import cn.com.duiba.bigdata.recommender.service.api.form.SlotMaterialForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteCDNSlotMaterialrecommendService {

    /**
     * 入口素材推荐-对接测试平台
     *
     * @param form 入参
     * @param version abTest版本号 dpa1.1、dpa2.0、old2.5
     * @return 本次推荐的入口素材id
     */
    Long getApiMaterialABTest(SlotMaterialForm form, String version);

    /**
     * 生成入口素材样本
     *
     * @param form       入参
     * @param materialId 素材id
     * @return 成功: success 失败: fail
     */
    String createApiMaterialSample(SlotMaterialForm form, Long materialId);

}
