/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.tool.duiba.client;

import cn.com.duiba.biz.tool.duiba.client.DESCrypto;
import cn.com.duiba.biz.tool.duiba.client.DuibaConsumerCookieClient;
import cn.com.duiba.biz.tool.duiba.dto.ConsumerCookieDto;
import cn.com.duiba.biz.tool.duiba.qpslimit.QpsLimitProxy;
import cn.com.duiba.consumer.center.api.dto.ConsumerDto;
import cn.com.duiba.consumer.center.api.remoteservice.RemoteConsumerService;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import cn.com.duiba.idmaker.service.api.remoteservice.kms.RemoteKmsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import cn.com.duiba.wolf.utils.NumberUtils;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RequestLocal
implements ApplicationContextAware,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(RequestLocal.class);
    public static final String ADSLOTID = "adslotId";
    private ApplicationContext applicationContext;
    private static RemoteConsumerService remoteConsumerService;
    private static RemoteAppService remoteAppService;
    private static Object remoteAppDirectService;
    private static DuibaConsumerCookieClient duibaConsumerCookieClient;
    private static boolean needQpsLimit;
    private static boolean needLogin;
    private static String oldConsumerEncryptKey;
    private static String cookieDomain;
    private static QpsLimitProxy qpsLimitProxy;
    private static LoadingCache<String, Optional<Long>> appKey2IdCache;
    private static LoadingCache<Long, Boolean> appId2DirectCache;
    private static ThreadLocal<HttpRequestDto> local;

    public void setNeedQpsLimit(boolean needQpsLimit) {
        RequestLocal.needQpsLimit = needQpsLimit;
    }

    public void setNeedLogin(boolean needLogin) {
        RequestLocal.needLogin = needLogin;
    }

    private static HttpRequestDto get() {
        HttpRequestDto rl = local.get();
        if (rl == null) {
            rl = new HttpRequestDto();
            local.set(rl);
        }
        return rl;
    }

    public static Long getCid() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.consumerCookieDto == null ? null : requestLocal.consumerCookieDto.getCid();
    }

    public static Long getAppId() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.consumerCookieDto == null ? null : requestLocal.consumerCookieDto.getAppId();
    }

    public static String getPartnerUserId() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.consumerCookieDto == null ? null : requestLocal.consumerCookieDto.getPartnerUserId();
    }

    public static ConsumerDto getConsumerDO() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.getConsumerDO();
    }

    public static ConsumerDto getConsumerAddr3DESDto() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.getConsumerAddr3DESDto();
    }

    public static AppSimpleDto getConsumerAppDO() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.getConsumerAppDO();
    }

    public static String getTokenId() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.getTokenId();
    }

    public static String getDeap() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.getDeap();
    }

    public static String getIp() {
        return RequestTool.getIpAddr((HttpServletRequest)RequestLocal.getRequest());
    }

    public static String getUserAgent() {
        return RequestTool.getUserAgent((HttpServletRequest)RequestLocal.getRequest());
    }

    public static String getSlotId() {
        HttpServletRequest request = RequestLocal.getRequest();
        String slotId = request.getParameter(ADSLOTID);
        if (StringUtils.isBlank((String)slotId)) {
            slotId = RequestTool.getCookie((HttpServletRequest)request, (String)"_coll_slot");
        }
        return slotId;
    }

    public static HttpServletRequest getRequest() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.getRequest();
    }

    public static boolean isIos() {
        return RequestTool.isIos((HttpServletRequest)RequestLocal.getRequest());
    }

    public static HttpServletResponse getResponse() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.getResponse();
    }

    public static boolean isLoginConsumer() {
        String partnerUserId = RequestLocal.getPartnerUserId();
        return partnerUserId != null && !"not_login".equals(partnerUserId);
    }

    public static boolean isShareConsumer() {
        return "share".equals(RequestLocal.getPartnerUserId());
    }

    public static void injectConsumerInfoIntoCookie(ConsumerDto consumer) {
        RequestLocal.injectConsumerInfoIntoCookie(consumer, false);
    }

    private static void injectConsumerInfoIntoCookie(ConsumerDto consumer, boolean isFromCommercial) {
        if (!needLogin) {
            throw new IllegalStateException("not allowed to login");
        }
        HttpRequestDto requestLocal = RequestLocal.get();
        ConsumerCookieDto consumerCookieDto = duibaConsumerCookieClient.injectConsumerInfoIntoCookie(consumer, requestLocal.getRequest(), requestLocal.getResponse(), cookieDomain, oldConsumerEncryptKey, isFromCommercial);
        requestLocal.consumerCookieDto = consumerCookieDto;
        requestLocal.consumerDO = null;
        requestLocal.consumerAppDO = null;
        requestLocal.tokenId = (String)requestLocal.getRequest().getAttribute("c_tokenId");
    }

    public static boolean setThreadLocallyAndLimitQps(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request == null || response == null) {
            throw new IllegalArgumentException("request or response must not be null");
        }
        if (org.apache.commons.lang3.StringUtils.endsWithAny((CharSequence)request.getRequestURI(), (CharSequence[])new CharSequence[]{".js", ".css", ".png", ".jpg", ".gif"})) {
            return false;
        }
        HttpRequestDto dto = RequestLocal.get();
        return dto.initAndLimitQps(request, response);
    }

    public static void clearThreadLocally() {
        local.remove();
    }

    public static void destroy() {
        if (needQpsLimit) {
            qpsLimitProxy.destroy();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        RemoteAppService remoteAppService = (RemoteAppService)this.applicationContext.getBean(RemoteAppService.class);
        if (remoteAppService == null) {
            throw new IllegalStateException("there must exists a bean of class RemoteAppService(in developer-center)");
        }
        RemoteConsumerService remoteConsumerService = (RemoteConsumerService)this.applicationContext.getBean(RemoteConsumerService.class);
        if (remoteAppService == null) {
            throw new IllegalStateException("there must exists a bean of class RemoteConsumerService(in consumer-center)");
        }
        RemoteKmsService remoteKmsService = (RemoteKmsService)this.applicationContext.getBean(RemoteKmsService.class);
        if (remoteKmsService == null) {
            throw new IllegalStateException("there must exists a bean of class RemoteKmsService(in idmaker-service)");
        }
        if (needLogin) {
            Class<?> clazz = Class.forName("cn.com.duiba.activity.center.api.remoteservice.activity.RemoteAppDirectService");
            Object remoteAppDirectService = this.applicationContext.getBean(clazz);
            if (remoteAppDirectService == null) {
                throw new IllegalStateException("there must exists a bean of class RemoteAppDirectService(in activity-center)");
            }
            RequestLocal.remoteAppDirectService = remoteAppDirectService;
            cookieDomain = this.applicationContext.getEnvironment().getProperty("app.cross.domain");
            if (cookieDomain == null || cookieDomain.isEmpty()) {
                throw new IllegalStateException("property:[app.cross.domain] does not exist");
            }
            if (cookieDomain.startsWith(".") || cookieDomain.startsWith("-")) {
                cookieDomain = cookieDomain.substring(1);
            }
        }
        if ((oldConsumerEncryptKey = this.applicationContext.getEnvironment().getProperty("app.consumer.encrypt.key")) == null || oldConsumerEncryptKey.isEmpty()) {
            throw new IllegalStateException("property:[app.consumer.encrypt.key] does not exist");
        }
        if (needQpsLimit) {
            String zookeeperAddress = this.applicationContext.getEnvironment().getProperty("app.zookeeper.address");
            if (zookeeperAddress == null || zookeeperAddress.isEmpty()) {
                throw new IllegalStateException("property:[app.zookeeper.address] does not exist");
            }
            qpsLimitProxy = new QpsLimitProxy(zookeeperAddress, 5);
            int userQpsLimit = NumberUtils.parseInt((String)this.applicationContext.getEnvironment().getProperty("app.user.qpslimit"), (int)0);
            if (userQpsLimit > 0) {
                qpsLimitProxy.setUserQpsLimit(userQpsLimit);
            }
        }
        RequestLocal.remoteAppService = remoteAppService;
        RequestLocal.remoteConsumerService = remoteConsumerService;
        duibaConsumerCookieClient = new DuibaConsumerCookieClient(remoteKmsService);
    }

    static {
        needQpsLimit = true;
        needLogin = true;
        local = new ThreadLocal();
        appKey2IdCache = CacheBuilder.newBuilder().concurrencyLevel(32).softValues().maximumSize(100000L).refreshAfterWrite(8L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Optional<Long>>(){

            public Optional<Long> load(String key) throws Exception {
                AppSimpleDto app = (AppSimpleDto)remoteAppService.getAppByAppKey(key).getResult();
                if (app != null) {
                    return Optional.of((Object)app.getId());
                }
                return Optional.absent();
            }
        });
        appId2DirectCache = CacheBuilder.newBuilder().concurrencyLevel(32).softValues().maximumSize(100000L).refreshAfterWrite(25L, TimeUnit.MINUTES).expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, Boolean>(){

            public Boolean load(Long key) throws Exception {
                Method m = remoteAppDirectService.getClass().getDeclaredMethod("findByAppId", Long.class);
                Long id = (Long)((DubboResult)m.invoke(remoteAppDirectService, key)).getResult();
                if (id != null) {
                    return true;
                }
                return false;
            }
        });
    }

    private static class AppMethodInterceptor
    implements MethodInterceptor {
        private boolean isLazyInitted = false;
        private HttpRequestDto httpRequestDto;

        public AppMethodInterceptor(HttpRequestDto httpRequestDto) {
            this.httpRequestDto = httpRequestDto;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (this.isLazyInitted) {
                return invocation.proceed();
            }
            Method m = invocation.getMethod();
            if (m.getName().equals("getId")) {
                return invocation.proceed();
            }
            AppSimpleDto originalApp = (AppSimpleDto)invocation.getThis();
            AppSimpleDto appInDb = (AppSimpleDto)remoteAppService.getSimpleApp(originalApp.getId()).getResult();
            BeanUtils.copyProperties((Object)appInDb, (Object)originalApp);
            this.isLazyInitted = true;
            this.httpRequestDto.consumerAppDO = originalApp;
            return invocation.proceed();
        }
    }

    private static class ConsumerMethodInterceptor
    implements MethodInterceptor {
        private boolean isLazyInitted = false;
        private HttpRequestDto httpRequestDto;

        public ConsumerMethodInterceptor(HttpRequestDto httpRequestDto) {
            this.httpRequestDto = httpRequestDto;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (this.isLazyInitted) {
                return invocation.proceed();
            }
            Method m = invocation.getMethod();
            if (m.getName().equals("getId") || m.getName().equals("getAppId") || m.getName().equals("getPartnerUserId")) {
                return invocation.proceed();
            }
            ConsumerDto originalConsumer = (ConsumerDto)invocation.getThis();
            ConsumerDto consumerInDb = remoteConsumerService.find(originalConsumer.getId());
            BeanUtils.copyProperties((Object)consumerInDb, (Object)originalConsumer);
            this.isLazyInitted = true;
            this.httpRequestDto.consumerDO = originalConsumer;
            return invocation.proceed();
        }
    }

    private static class HttpRequestDto {
        private ConsumerDto consumerDO;
        private AppSimpleDto consumerAppDO;
        private ConsumerCookieDto consumerCookieDto;
        private String tokenId;
        private String deap;
        private HttpServletRequest request;
        private HttpServletResponse response;

        private HttpRequestDto() {
        }

        public boolean initAndLimitQps(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            Long appId;
            Optional appIdOptional;
            this.request = request;
            this.response = response;
            ConsumerCookieDto consumerFromWdata4 = null;
            ConsumerCookieDto consumerFromWdata3 = null;
            try {
                consumerFromWdata4 = duibaConsumerCookieClient.getConsumerCookieDto(request);
            }
            catch (Exception e) {
                logger.error("get user from wdata4 error,will try to use wdata3.", (Throwable)e);
            }
            if (consumerFromWdata4 == null) {
                consumerFromWdata3 = this.parseOldWdata3();
            }
            this.tokenId = RequestTool.getCookie((HttpServletRequest)request, (String)"tokenId");
            if (this.tokenId == null || this.tokenId.isEmpty()) {
                this.tokenId = RequestTool.getCookie((HttpServletRequest)request, (String)"wdata3");
            }
            String appKey = request.getParameter("appKey");
            String openBs = request.getParameter("openBs");
            boolean preferUseWdata4 = false;
            boolean qpsLimitInvoked = false;
            if (null != appKey && "openbs".equals(openBs) && needLogin) {
                appIdOptional = (Optional)appKey2IdCache.getUnchecked((Object)appKey);
                Long l = appId = appIdOptional.isPresent() ? (Long)appIdOptional.get() : null;
                if (null != appId && this.isAppDirectByAppId(appId).booleanValue()) {
                    this.consumerCookieDto = consumerFromWdata3;
                    this.removeWdata4Cookie();
                    if (this.consumerCookieDto != null && !appId.equals(this.consumerCookieDto.getAppId()) || this.consumerCookieDto == null) {
                        if (needQpsLimit && qpsLimitProxy.doLimit(request, response, null, appId)) {
                            return true;
                        }
                        qpsLimitInvoked = true;
                        this.makeCommercialUser(appId);
                    }
                } else {
                    preferUseWdata4 = true;
                }
            } else {
                preferUseWdata4 = true;
            }
            if (preferUseWdata4) {
                ConsumerCookieDto consumerCookieDto = this.consumerCookieDto = consumerFromWdata4 == null ? consumerFromWdata3 : consumerFromWdata4;
            }
            if (!qpsLimitInvoked && this.consumerCookieDto != null && needQpsLimit) {
                String partnerUserId = this.consumerCookieDto.getPartnerUserId();
                String limitConsumerId = "not_login".equals(partnerUserId) || "share".equals(partnerUserId) ? null : String.valueOf(this.consumerCookieDto.getCid());
                return qpsLimitProxy.doLimit(request, response, limitConsumerId, this.consumerCookieDto.getAppId());
            }
            if (!qpsLimitInvoked && this.consumerCookieDto == null && needQpsLimit && appKey != null) {
                appIdOptional = (Optional)appKey2IdCache.getUnchecked((Object)appKey);
                appId = appIdOptional.isPresent() ? (Long)appIdOptional.get() : null;
                return qpsLimitProxy.doLimit(request, response, null, appId);
            }
            return false;
        }

        private void removeWdata4Cookie() {
            for (Cookie cookie : this.request.getCookies()) {
                if (!cookie.getName().equals("wdata4") && !cookie.getName().equals("w_ts")) continue;
                cookie.setValue("");
                cookie.setMaxAge(0);
                cookie.setDomain(cookieDomain);
                cookie.setPath("/");
                cookie.setHttpOnly(true);
                this.response.addCookie(cookie);
            }
        }

        private void makeCommercialUser(Long appId) {
            String uid = "gen_" + UUIDUtils.createUUID();
            ConsumerDto c = new ConsumerDto(true);
            c.setAppId(appId);
            c.setPartnerUserId(uid);
            ConsumerDto temp = remoteConsumerService.insert(c);
            c.setId(temp.getId());
            RequestLocal.injectConsumerInfoIntoCookie(c, true);
        }

        private Boolean isAppDirectByAppId(Long appId) {
            try {
                return (Boolean)appId2DirectCache.get((Object)appId);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private ConsumerCookieDto parseOldWdata3() {
            String wdata3 = RequestTool.getCookie((HttpServletRequest)this.request, (String)"wdata3");
            if (wdata3 == null || wdata3.isEmpty()) {
                return null;
            }
            String content = BlowfishUtils.decryptBlowfish((String)wdata3, (String)oldConsumerEncryptKey);
            ConsumerCookieDto c = (ConsumerCookieDto)JSONObject.parseObject((String)content, ConsumerCookieDto.class);
            if (this.isAppDirectByAppId(c.getAppId()).booleanValue()) {
                return c;
            }
            long now = System.currentTimeMillis();
            if (c.getTime() > now - 86400000L) {
                return c;
            }
            return null;
        }

        public ConsumerDto getConsumerDO() {
            if (this.consumerDO == null) {
                if (this.consumerCookieDto == null) {
                    return null;
                }
                ConsumerDto temp = new ConsumerDto();
                temp.setAppId(this.consumerCookieDto.getAppId());
                temp.setId(this.consumerCookieDto.getCid());
                temp.setPartnerUserId(this.consumerCookieDto.getPartnerUserId());
                ProxyFactory proxyFactory = new ProxyFactory();
                proxyFactory.setTarget((Object)temp);
                proxyFactory.addAdvice((Advice)new ConsumerMethodInterceptor(this));
                this.consumerDO = (ConsumerDto)proxyFactory.getProxy();
            }
            return this.consumerDO;
        }

        public ConsumerDto getConsumerAddr3DESDto() {
            ConsumerDto src = this.getConsumerDO();
            src.getAddrProvince();
            ConsumerDto consumerDto = new ConsumerDto();
            BeanUtils.copyProperties((Object)src, (Object)consumerDto);
            if (consumerDto != null) {
                if (StringUtils.isNotBlank((String)consumerDto.getAddrProvince())) {
                    consumerDto.setAddrProvince(DESCrypto.encrypt3DE(consumerDto.getAddrProvince().trim()));
                }
                if (StringUtils.isNotBlank((String)consumerDto.getAddrCity())) {
                    consumerDto.setAddrCity(DESCrypto.encrypt3DE(consumerDto.getAddrCity().trim()));
                }
                if (StringUtils.isNotBlank((String)consumerDto.getAddrArea())) {
                    consumerDto.setAddrArea(DESCrypto.encrypt3DE(consumerDto.getAddrArea().trim()));
                }
                if (StringUtils.isNotBlank((String)consumerDto.getAddrDetail())) {
                    consumerDto.setAddrDetail(DESCrypto.encrypt3DE(consumerDto.getAddrDetail().trim()));
                }
            }
            return consumerDto;
        }

        public AppSimpleDto getConsumerAppDO() {
            if (this.consumerAppDO == null) {
                if (this.consumerCookieDto == null) {
                    return null;
                }
                AppSimpleDto temp = new AppSimpleDto();
                temp.setId(this.consumerCookieDto.getAppId());
                ProxyFactory proxyFactory = new ProxyFactory();
                proxyFactory.setTarget((Object)temp);
                proxyFactory.addAdvice((Advice)new AppMethodInterceptor(this));
                this.consumerAppDO = (AppSimpleDto)proxyFactory.getProxy();
            }
            return this.consumerAppDO;
        }

        public HttpServletResponse getResponse() {
            if (this.response == null) {
                throw new IllegalStateException("response must not be null, please invoke RequestLocal.setThreadLocallyAndLimitQps first");
            }
            return this.response;
        }

        public HttpServletRequest getRequest() {
            if (this.request == null) {
                throw new IllegalStateException("request must not be null, please invoke RequestLocal.setThreadLocallyAndLimitQps first");
            }
            return this.request;
        }

        public String getTokenId() {
            return this.tokenId;
        }

        public String getDeap() {
            if (this.deap == null) {
                String[] deaps;
                String mdeap = RequestTool.getCookie((HttpServletRequest)this.request, (String)"deap");
                if (StringUtils.isBlank((String)mdeap)) {
                    this.deap = "";
                    return null;
                }
                for (String requestStr : deaps = mdeap.split(",")) {
                    if (!requestStr.startsWith(this.consumerDO.getAppId() + "-")) continue;
                    this.deap = requestStr;
                    return this.deap;
                }
                if (this.deap == null) {
                    this.deap = "";
                }
            }
            return StringUtils.trimToNull((String)this.deap);
        }
    }
}

