/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.tool.duiba.qpslimit;

import com.alibaba.fastjson.JSONArray;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpsLimitProxy {
    private static Logger log = LoggerFactory.getLogger(QpsLimitProxy.class);
    private static final int DEFAULT_USER_QPS_LIMIT = 15;
    private int userQpsLimit = 15;
    private ZkClient zkClient;
    private LoadingCache<String, AtomicInteger> consumerId2QpsCache;
    private int qpsDataCacheSeconds;
    private ConcurrentMap<Long, ConcurrentMap<String, AppUriQpsLimit>> appId2uri2qpsLimitMap = new ConcurrentHashMap<Long, ConcurrentMap<String, AppUriQpsLimit>>();
    private LoadingCache<String, AtomicInteger> appIdUri2QpsCache;
    private Cache<Long, Object> appId2WarnedFlagCache;
    private volatile boolean isDestroyed = false;

    public QpsLimitProxy(String zkServers) {
        this(zkServers, 1);
    }

    public QpsLimitProxy(String zkServers, int qpsDataCacheSeconds) {
        this(zkServers, qpsDataCacheSeconds, 10);
    }

    public QpsLimitProxy(String zkServers, int qpsDataCacheSeconds, int appWarnLogSilencePeriod) {
        if (qpsDataCacheSeconds < 1 || qpsDataCacheSeconds > 10) {
            throw new IllegalArgumentException("qpsDataCacheSeconds must between 1 and 10");
        }
        this.qpsDataCacheSeconds = qpsDataCacheSeconds;
        this.zkClient = new ZkClient(zkServers);
        this.readQpsLimitData("/QpsLimit");
        this.zkClient.subscribeDataChanges("/QpsLimit", new IZkDataListener(){

            public void handleDataChange(String parentPath, Object parentData) throws Exception {
                QpsLimitProxy.this.readQpsLimitData(parentPath);
            }

            public void handleDataDeleted(String dataPath) throws Exception {
            }
        });
        this.consumerId2QpsCache = CacheBuilder.newBuilder().expireAfterWrite((long)qpsDataCacheSeconds, TimeUnit.SECONDS).concurrencyLevel(4).initialCapacity(10000).maximumSize(1000000L).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

            public AtomicInteger load(String key) throws Exception {
                return new AtomicInteger(0);
            }
        });
        this.appIdUri2QpsCache = CacheBuilder.newBuilder().expireAfterWrite((long)qpsDataCacheSeconds, TimeUnit.SECONDS).concurrencyLevel(4).initialCapacity(10000).maximumSize(1000000L).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

            public AtomicInteger load(String key) throws Exception {
                return new AtomicInteger(0);
            }
        });
        this.appId2WarnedFlagCache = CacheBuilder.newBuilder().expireAfterWrite((long)appWarnLogSilencePeriod, TimeUnit.SECONDS).concurrencyLevel(4).initialCapacity(100).maximumSize(1000000L).build();
    }

    private void readQpsLimitData(String parentPath) {
        if (this.zkClient.exists(parentPath)) {
            List list = this.zkClient.getChildren(parentPath);
            for (String path : list) {
                if (path == null) continue;
                String data = (String)this.zkClient.readData(parentPath + "/" + path, true);
                Long appId = Long.valueOf(path);
                if (data == null) {
                    this.appId2uri2qpsLimitMap.remove(appId);
                    continue;
                }
                List limitList = JSONArray.parseArray((String)data, AppUriQpsLimit.class);
                if (limitList == null || limitList.isEmpty()) {
                    this.appId2uri2qpsLimitMap.remove(appId);
                    continue;
                }
                ConcurrentHashMap<String, AppUriQpsLimit> uri2qpsLimitMap = (ConcurrentHashMap<String, AppUriQpsLimit>)this.appId2uri2qpsLimitMap.get(appId);
                if (uri2qpsLimitMap == null) {
                    uri2qpsLimitMap = new ConcurrentHashMap<String, AppUriQpsLimit>();
                }
                Date now = new Date();
                for (AppUriQpsLimit limit : limitList) {
                    if (!limit.getFinishTime().after(now)) continue;
                    uri2qpsLimitMap.put(limit.getLimitUri(), limit);
                }
                this.appId2uri2qpsLimitMap.put(appId, uri2qpsLimitMap);
            }
        }
    }

    public boolean doLimit(HttpServletRequest request, HttpServletResponse response, String consumerId, Long appId) throws IOException, ServletException {
        boolean limited;
        if (this.isDestroyed) {
            throw new IllegalStateException("QpsLimitProxy is destroyed, can not provide service any more");
        }
        if (StringUtils.endsWithAny((CharSequence)request.getRequestURI(), (CharSequence[])new CharSequence[]{".js", ".css", ".png", ".jpg", ".gif"})) {
            return false;
        }
        if (consumerId != null && !this.isTestMode(request) && (limited = this.limitByConsumer(consumerId, response))) {
            return true;
        }
        if (appId != null) {
            String requestUri = request.getRequestURI();
            boolean limited2 = this.limitByAppAndUri(appId, requestUri, response);
            if (limited2) {
                return true;
            }
            limited2 = this.limitByAppAndUri(0L, requestUri, response);
            if (limited2) {
                return true;
            }
        }
        return false;
    }

    private boolean isTestMode(HttpServletRequest request) {
        boolean isTestMode = false;
        String testInParameter = request.getParameter("_duibaPerf");
        if (testInParameter != null && ("1".equals(testInParameter) || "true".equals(testInParameter))) {
            isTestMode = true;
        } else {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!"_duibaPerf".equals(cookie.getName()) || !"1".equals(cookie.getValue()) && !"true".equals(cookie.getValue())) continue;
                    isTestMode = true;
                }
            }
        }
        return isTestMode;
    }

    private boolean limitByAppAndUri(final Long appId, String requestUri, HttpServletResponse response) throws IOException {
        AppUriQpsLimit qpsLimit = this.getAppUriQpsLimit(appId, requestUri);
        if (qpsLimit == null) {
            return false;
        }
        Integer qpsLimitInteger = qpsLimit.getQpsLimit();
        if (qpsLimitInteger <= 0) {
            this.showBusyPage(response);
            return true;
        }
        try {
            AtomicInteger qpsAtomic = (AtomicInteger)this.appIdUri2QpsCache.get((Object)(appId + "-" + requestUri));
            int qps = qpsAtomic.get();
            if (qps >= qpsLimitInteger * this.qpsDataCacheSeconds) {
                this.showBusyPage(response);
                final AtomicBoolean canLog = new AtomicBoolean(false);
                this.appId2WarnedFlagCache.get((Object)appId, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        canLog.set(true);
                        return appId;
                    }
                });
                if (canLog.get()) {
                    log.warn("app:{},uri:{}, qps:{},\u8d85\u51fa{}", new Object[]{appId, requestUri, qps, qpsLimitInteger});
                }
                return true;
            }
            qpsAtomic.incrementAndGet();
        }
        catch (ExecutionException e) {
            log.error("", (Throwable)e);
        }
        return false;
    }

    private boolean limitByConsumer(String consumerId, HttpServletResponse response) throws IOException {
        try {
            AtomicInteger qpsAtomic = (AtomicInteger)this.consumerId2QpsCache.get((Object)consumerId);
            int qps = qpsAtomic.get();
            int limit = this.qpsDataCacheSeconds * this.userQpsLimit;
            if (qps >= limit) {
                this.showBusyPage(response);
                log.warn("user:{} qps:{},\u8d85\u51fa{}", new Object[]{consumerId, qps, this.userQpsLimit});
                return true;
            }
            qpsAtomic.incrementAndGet();
        }
        catch (ExecutionException e) {
            log.error("", (Throwable)e);
        }
        return false;
    }

    private AppUriQpsLimit getAppUriQpsLimit(Long appId, String requestUri) {
        ConcurrentMap uri2qpsLimitMap = (ConcurrentMap)this.appId2uri2qpsLimitMap.get(appId);
        if (uri2qpsLimitMap != null) {
            for (Map.Entry entry : uri2qpsLimitMap.entrySet()) {
                if (!requestUri.startsWith((String)entry.getKey())) continue;
                AppUriQpsLimit qpsLimit = (AppUriQpsLimit)entry.getValue();
                if (qpsLimit.isExpired()) {
                    uri2qpsLimitMap.remove(entry.getKey(), qpsLimit);
                    if (!uri2qpsLimitMap.isEmpty()) continue;
                    this.appId2uri2qpsLimitMap.remove(appId);
                    continue;
                }
                return qpsLimit;
            }
        }
        return null;
    }

    public void destroy() {
        this.isDestroyed = true;
        this.zkClient.unsubscribeAll();
        this.zkClient.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showBusyPage(HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        response.setCharacterEncoding("utf-8");
        String str = "<!DOCTYPE html>\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n<meta name=\"viewport\" content=\"width=device-width,initial-scale=1.0,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no\" />\n<meta name=\"apple-mobile-web-app-capable\" content=\"yes\">\n<meta name=\"apple-mobile-web-app-status-bar-style\" content=\"black-translucent\">\n<meta content=\"telephone=no\" name=\"format-detection\" />\n<title>\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5</title>\n<link rel=\"apple-touch-icon\" href=\"images/app-icon.png\"/>\n<link href=\"//yun.duiba.com.cn/webapp/css/404.css\" rel=\"stylesheet\" type=\"text/css\" />\n</head>\n<body>\n<div class=\"content\">\n\t<img name=\"\" src=\"//yun.duiba.com.cn/assets/images/error.png\" alt=\"\">\n\t<h1>\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5</h1>\n</div>\n</body>\n</html>\n\n";
        try (PrintWriter out = null;){
            out = response.getWriter();
            out.write(str);
        }
    }

    public void setUserQpsLimit(int userQpsLimit) {
        this.userQpsLimit = userQpsLimit;
    }

    public int getUserQpsLimit() {
        return this.userQpsLimit;
    }

    private static class AppUriQpsLimit {
        private Date finishTime;
        private Integer qpsLimit;
        private String limitUri;

        public AppUriQpsLimit() {
        }

        public AppUriQpsLimit(Date finishTime, Integer qpsLimit, String limitUri) {
            this.finishTime = finishTime;
            this.qpsLimit = qpsLimit;
            this.limitUri = limitUri;
        }

        public boolean isExpired() {
            return this.finishTime.before(new Date());
        }

        public Date getFinishTime() {
            return this.finishTime;
        }

        public void setFinishTime(Date finishTime) {
            this.finishTime = finishTime;
        }

        public Integer getQpsLimit() {
            return this.qpsLimit;
        }

        public void setQpsLimit(Integer qpsLimit) {
            this.qpsLimit = qpsLimit;
        }

        public String getLimitUri() {
            return this.limitUri;
        }

        public void setLimitUri(String limitUri) {
            this.limitUri = limitUri;
        }
    }
}

