/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.tool.duiba.qpslimit;

import com.alibaba.fastjson.JSONArray;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpsLimitProxy {
    private static Logger log = LoggerFactory.getLogger(QpsLimitProxy.class);
    private static final int DEFAULT_USER_QPS_LIMIT = 15;
    private int userQpsLimit = 15;
    private ZkClient zkClient;
    private LoadingCache<String, AtomicInteger> consumerId2QpsCache;
    private int qpsDataCacheSeconds;
    private ConcurrentMap<Long, ConcurrentMap<String, AppUriQpsLimit>> appId2uri2qpsLimitMap = new ConcurrentHashMap<Long, ConcurrentMap<String, AppUriQpsLimit>>();
    private LoadingCache<String, AtomicInteger> appIdUri2QpsCache;
    private Cache<Long, Object> appId2WarnedFlagCache;
    private volatile boolean isDestroyed = false;
    private static final String mobaiBusyPageWihte = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n\t<meta charset=\"UTF-8\">\n\t<title>\u9519\u8bef</title>\n\t<meta charset=\"utf-8\"/>\n<meta name=\"description\" content=\"\u79ef\u5206\u5151\u6362\u5546\u57ce\"/>\n<meta name=\"keywords\" content=\"\u79ef\u5206\u5151\u6362,\u79ef\u5206,\u5151\u6362\"/>\n<meta name=\"apple-mobile-web-app-capable\" content=\"yes\"/>\n<meta name=\"format-detection\" content=\"telephone=no\"/>\n<meta name=\"x5-fullscreen\" content=\"true\"/>\n<meta name=\"full-screen\" content=\"yes\"/>\n<meta name=\"format-detection\" content=\"email=no\"/>\n<meta name=\"apple-mobile-web-app-status-bar-style\" content=\"black-translucent\"/>\n<script type=\"text/javascript\">\n    (function (win) {var h; var dpr = win.navigator.appVersion.match(/iphone/gi) ? win.devicePixelRatio : 1; var scale = 1; var docEl = document.documentElement; var metaEl = document.createElement(\"meta\"); function IsPC() {var userAgentInfo = navigator.userAgent; var Agents = [\"Android\", \"iPhone\", \"SymbianOS\", \"Windows Phone\", \"iPad\", \"iPod\"]; var flag = true; for (var v = 0; v < Agents.length; v++) {if (userAgentInfo.indexOf(Agents[v]) > 0) {flag = false; break } } return flag } function setUnitA() {win.rem = Math.min(docEl.getBoundingClientRect().width, 750) / 16; docEl.style.fontSize = (IsPC() ? \"46.875\" : win.rem) + \"px\"; docEl.style.fontSize = win.rem + \"px\"} win.addEventListener(\"resize\", function () {clearTimeout(h); h = setTimeout(setUnitA, 300) }, false); win.addEventListener(\"pageshow\", function (e) {if (e.persisted) {clearTimeout(h); h = setTimeout(setUnitA, 300) } }, false); metaEl.setAttribute(\"name\", \"viewport\"); metaEl.setAttribute(\"content\", \"initial-scale=\" + scale + \", maximum-scale=\" + scale + \", minimum-scale=\" + scale + \", user-scalable=no\"); if (docEl.firstElementChild) {docEl.firstElementChild.appendChild(metaEl) } else {var wrap = document.createElement(\"div\"); wrap.appendChild(metaEl); document.write(wrap.innerHTML) } setUnitA() })(window);\n</script>\n<style type=\"text/css\">\n\tbody {\n\t  background-color: #FFF;\n\t}\n\t.error-content {\n\t  width: 16rem;\n\t  position: absolute;\n\t  left: 0rem;\n\t  top: 50%;\n\t  -webkit-transform: translateY(-50%);\n\t          transform: translateY(-50%);\n\t  background-color: #FFF;\n\t  padding: 0.85333333rem;\n\t  box-sizing: border-box;\n\t}\n\t.error-content .icon {\n\t  width: 6.82666667rem;\n\t  height: 3.84rem;\n\t  margin: 0 auto;\n\t  background-image: url('https://yun.duiba.com.cn/upload/re707woa16.png');\n\t  background-size: 6.22933333rem 3.2rem;\n\t  background-repeat: no-repeat;\n\t  background-position: center center;\n\t}\n\t.error-content .title {\n\t  font-size: 0.68266667rem;\n\t  color: #373c43;\n\t  margin-top: 1.70666667rem;\n\t  text-align: center;\n\t}\n\t.error-content .subtitle {\n\t  font-size: 0.59733333rem;\n\t  color: #999ba1;\n\t  margin-top: 0.85333333rem;\n\t  text-align: center;\n\t}\n</style>\n</head>\n<body>\n\t<div class=\"error-content\">\n\t\t<div class=\"icon\"></div>\n\t\t<div class=\"title\">\u5f53\u524d\u7f51\u7edc\u8c8c\u4f3c\u51fa\u4e86\u70b9\u95ee\u9898</div>\n\t\t<div class=\"subtitle\">\u53ef\u80fd\u6253\u5f00\u7684\u65b9\u5f0f\u4e0d\u5bf9\uff0c\u6362\u4e2a\u624b\u6307\u8bd5\u8bd5~</div>\n\t</div>\n</body>\n</html>";
    private static final String mobaiBusyPage = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n\t<meta charset=\"UTF-8\">\n\t<title>\u9519\u8bef</title>\n\t<meta charset=\"utf-8\"/>\n<meta name=\"description\" content=\"\u79ef\u5206\u5151\u6362\u5546\u57ce\"/>\n<meta name=\"keywords\" content=\"\u79ef\u5206\u5151\u6362,\u79ef\u5206,\u5151\u6362\"/>\n<meta name=\"apple-mobile-web-app-capable\" content=\"yes\"/>\n<meta name=\"format-detection\" content=\"telephone=no\"/>\n<meta name=\"x5-fullscreen\" content=\"true\"/>\n<meta name=\"full-screen\" content=\"yes\"/>\n<meta name=\"format-detection\" content=\"email=no\"/>\n<meta name=\"apple-mobile-web-app-status-bar-style\" content=\"black-translucent\"/>\n<script type=\"text/javascript\">\n    (function (win) {var h; var dpr = win.navigator.appVersion.match(/iphone/gi) ? win.devicePixelRatio : 1; var scale = 1; var docEl = document.documentElement; var metaEl = document.createElement(\"meta\"); function IsPC() {var userAgentInfo = navigator.userAgent; var Agents = [\"Android\", \"iPhone\", \"SymbianOS\", \"Windows Phone\", \"iPad\", \"iPod\"]; var flag = true; for (var v = 0; v < Agents.length; v++) {if (userAgentInfo.indexOf(Agents[v]) > 0) {flag = false; break } } return flag } function setUnitA() {win.rem = Math.min(docEl.getBoundingClientRect().width, 750) / 16; docEl.style.fontSize = (IsPC() ? \"46.875\" : win.rem) + \"px\"; docEl.style.fontSize = win.rem + \"px\"} win.addEventListener(\"resize\", function () {clearTimeout(h); h = setTimeout(setUnitA, 300) }, false); win.addEventListener(\"pageshow\", function (e) {if (e.persisted) {clearTimeout(h); h = setTimeout(setUnitA, 300) } }, false); metaEl.setAttribute(\"name\", \"viewport\"); metaEl.setAttribute(\"content\", \"initial-scale=\" + scale + \", maximum-scale=\" + scale + \", minimum-scale=\" + scale + \", user-scalable=no\"); if (docEl.firstElementChild) {docEl.firstElementChild.appendChild(metaEl) } else {var wrap = document.createElement(\"div\"); wrap.appendChild(metaEl); document.write(wrap.innerHTML) } setUnitA() })(window);\n</script>\n<style type=\"text/css\">\n\tbody {\n\t  background-color: #F4F5F7;\n\t}\n\t.error-content {\n\t  width: 16rem;\n\t  position: absolute;\n\t  left: 0rem;\n\t  top: 50%;\n\t  -webkit-transform: translateY(-50%);\n\t          transform: translateY(-50%);\n\t  background-color: #FFF;\n\t  padding: 0.85333333rem;\n\t  box-sizing: border-box;\n\t}\n\t.error-content .icon {\n\t  width: 6.82666667rem;\n\t  height: 3.84rem;\n\t  margin: 0 auto;\n\t  background-image: url('https://yun.duiba.com.cn/upload/re707woa16.png');\n\t  background-size: 6.22933333rem 3.2rem;\n\t  background-repeat: no-repeat;\n\t  background-position: center center;\n\t}\n\t.error-content .title {\n\t  font-size: 0.68266667rem;\n\t  color: #373c43;\n\t  margin-top: 1.70666667rem;\n\t  text-align: center;\n\t}\n\t.error-content .subtitle {\n\t  font-size: 0.59733333rem;\n\t  color: #999ba1;\n\t  margin-top: 0.85333333rem;\n\t  text-align: center;\n\t}\n</style>\n</head>\n<body>\n\t<div class=\"error-content\">\n\t\t<div class=\"icon\"></div>\n\t\t<div class=\"title\">\u5f53\u524d\u7f51\u7edc\u8c8c\u4f3c\u51fa\u4e86\u70b9\u95ee\u9898</div>\n\t\t<div class=\"subtitle\">\u53ef\u80fd\u6253\u5f00\u7684\u65b9\u5f0f\u4e0d\u5bf9\uff0c\u6362\u4e2a\u624b\u6307\u8bd5\u8bd5~</div>\n\t</div>\n</body>\n</html>";
    private static final String busyPage = "<!DOCTYPE html>\n<html>\n<head>\n<title>\u597d\u50cf\u54ea\u91cc\u4e0d\u5bf9</title>\n<meta charset=\"utf-8\" />\n<meta name=\"description\" content=\"\u79ef\u5206\u5151\u6362\u5546\u57ce\" />\n<meta name=\"keywords\" content=\"\u79ef\u5206\u5151\u6362,\u79ef\u5206,\u5151\u6362\" />\n<meta name=\"apple-mobile-web-app-capable\" content=\"yes\" />\n<meta name=\"format-detection\" content=\"telephone=no\" />\n<meta name=\"x5-fullscreen\" content=\"true\" />\n<meta name=\"full-screen\" content=\"yes\" />\n<meta name=\"format-detection\" content=\"email=no\" />\n<link rel=\"shortcut icon\" type=\"image/x-icon\" href=\"//yun.duiba.com.cn/logo.png\"><meta name=\"apple-mobile-web-app-status-bar-style\" content=\"black-translucent\" />\n<script type=\"text/javascript\">\n (function(k){var i;var n=k.navigator.appVersion.match(/iphone/gi)?k.devicePixelRatio:1;var f=1;var d=document.documentElement;var m=document.createElement(\"meta\");var a=navigator.userAgent.toLowerCase();var c=a.match(/iphone/ig)||a.match(/ipad/ig)?true:false;if(c&&window.screen.width<=320){n=\"low\"}var g=document.getElementsByTagName(\"html\")[0];var j=parseInt(l(g,\"fontSize\"));function l(o,h){if(o.currentStyle){return o.currentStyle[h]}else{return getComputedStyle(o,false)[h]}}function e(){k.rem=Math.min(d.getBoundingClientRect().width,750)/16;k.rem=k.rem*(16/j);d.style.fontSize=k.rem+\"px\"}k.addEventListener(\"resize\",function(){clearTimeout(i);i=setTimeout(e,300)},false);k.addEventListener(\"pageshow\",function(h){if(h.persisted){clearTimeout(i);i=setTimeout(e,300)}},false);d.setAttribute(\"duiba-dpr\",n);m.setAttribute(\"name\",\"viewport\");m.setAttribute(\"content\",\"initial-scale=\"+f+\", maximum-scale=\"+f+\", minimum-scale=\"+f+\", user-scalable=no\");if(d.firstElementChild){d.firstElementChild.appendChild(m)}else{var b=document.createElement(\"div\");b.appendChild(m);document.write(b.innerHTML)}e()})(window);\n</script>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"//yun.duiba.com.cn/h5/static/error.css\">\n</head>\n<body>\n<section class=\"content\">\n<img src=\"//yun.duiba.com.cn/upload/re707woa16.png\">\n<p class='title'>\u5662\u5662\uff01\u53ef\u80fd\u662f\u60a8\u7684\u6253\u5f00\u65b9\u5f0f\u4e0d\u5bf9</p>\n<p class='subtitle'>\u6362\u4e2a\u624b\u6307\u518d\u8bd5\u4e00\u6b21\uff5e</p>\n</section>\n</body>\n</html>";
    private static final String MOBAI_ITEM_DEFAULT_BUSY_PAGE = "https://yun.duiba.com.cn/mobai_item_1385142_qps_over.html";

    public QpsLimitProxy(String zkServers) {
        this(zkServers, 1);
    }

    public QpsLimitProxy(String zkServers, int qpsDataCacheSeconds) {
        this(zkServers, qpsDataCacheSeconds, 10);
    }

    public QpsLimitProxy(String zkServers, int qpsDataCacheSeconds, int appWarnLogSilencePeriod) {
        if (qpsDataCacheSeconds < 1 || qpsDataCacheSeconds > 10) {
            throw new IllegalArgumentException("qpsDataCacheSeconds must between 1 and 10");
        }
        this.qpsDataCacheSeconds = qpsDataCacheSeconds;
        this.zkClient = new ZkClient(zkServers);
        this.readQpsLimitData("/QpsLimit");
        this.zkClient.subscribeDataChanges("/QpsLimit", new IZkDataListener(){

            public void handleDataChange(String parentPath, Object parentData) throws Exception {
                QpsLimitProxy.this.readQpsLimitData(parentPath);
            }

            public void handleDataDeleted(String dataPath) throws Exception {
            }
        });
        this.consumerId2QpsCache = CacheBuilder.newBuilder().expireAfterWrite((long)qpsDataCacheSeconds, TimeUnit.SECONDS).concurrencyLevel(4).initialCapacity(10000).maximumSize(1000000L).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

            public AtomicInteger load(String key) throws Exception {
                return new AtomicInteger(0);
            }
        });
        this.appIdUri2QpsCache = CacheBuilder.newBuilder().expireAfterWrite((long)qpsDataCacheSeconds, TimeUnit.SECONDS).concurrencyLevel(4).initialCapacity(10000).maximumSize(1000000L).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

            public AtomicInteger load(String key) throws Exception {
                return new AtomicInteger(0);
            }
        });
        this.appId2WarnedFlagCache = CacheBuilder.newBuilder().expireAfterWrite((long)appWarnLogSilencePeriod, TimeUnit.SECONDS).concurrencyLevel(4).initialCapacity(100).maximumSize(1000000L).build();
    }

    private void readQpsLimitData(String parentPath) {
        if (this.zkClient.exists(parentPath)) {
            List list = this.zkClient.getChildren(parentPath);
            for (String path : list) {
                if (path == null) continue;
                String data = (String)this.zkClient.readData(parentPath + "/" + path, true);
                Long appId = Long.valueOf(path);
                if (data == null) {
                    this.appId2uri2qpsLimitMap.remove(appId);
                    continue;
                }
                List limitList = JSONArray.parseArray((String)data, AppUriQpsLimit.class);
                if (limitList == null || limitList.isEmpty()) {
                    this.appId2uri2qpsLimitMap.remove(appId);
                    continue;
                }
                ConcurrentHashMap<String, AppUriQpsLimit> uri2qpsLimitMap = (ConcurrentHashMap<String, AppUriQpsLimit>)this.appId2uri2qpsLimitMap.get(appId);
                if (uri2qpsLimitMap == null) {
                    uri2qpsLimitMap = new ConcurrentHashMap<String, AppUriQpsLimit>();
                }
                Date now = new Date();
                for (AppUriQpsLimit limit : limitList) {
                    if (!limit.getFinishTime().after(now)) continue;
                    uri2qpsLimitMap.put(limit.getLimitUri(), limit);
                }
                this.appId2uri2qpsLimitMap.put(appId, uri2qpsLimitMap);
            }
        }
    }

    public boolean doLimit(HttpServletRequest request, HttpServletResponse response, String consumerId, Long appId) throws IOException, ServletException {
        boolean limited;
        if (this.isDestroyed) {
            throw new IllegalStateException("QpsLimitProxy is destroyed, can not provide service any more");
        }
        if (StringUtils.endsWithAny((CharSequence)request.getRequestURI(), (CharSequence[])new CharSequence[]{".js", ".css", ".png", ".jpg", ".gif"})) {
            return false;
        }
        if (consumerId != null && !this.isTestMode(request) && (limited = this.limitByConsumer(consumerId, request, response, appId))) {
            return true;
        }
        if (appId != null) {
            String requestUri = request.getRequestURI();
            boolean limited2 = this.limitByAppAndUri(appId, requestUri, request, response);
            if (limited2) {
                return true;
            }
            limited2 = this.limitByAppAndUri(0L, requestUri, request, response);
            if (limited2) {
                return true;
            }
        }
        return false;
    }

    private boolean isTestMode(HttpServletRequest request) {
        boolean isTestMode = false;
        String testInParameter = request.getParameter("_duibaPerf");
        if (testInParameter != null && ("1".equals(testInParameter) || "true".equals(testInParameter))) {
            isTestMode = true;
        } else {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!"_duibaPerf".equals(cookie.getName()) || !"1".equals(cookie.getValue()) && !"true".equals(cookie.getValue())) continue;
                    isTestMode = true;
                }
            }
        }
        return isTestMode;
    }

    private boolean limitByAppAndUri(final Long appId, String requestUri, HttpServletRequest request, HttpServletResponse response) throws IOException {
        AppUriQpsLimit qpsLimit = this.getAppUriQpsLimit(appId, requestUri);
        if (qpsLimit == null) {
            return false;
        }
        Integer qpsLimitInteger = qpsLimit.getQpsLimit();
        if (qpsLimitInteger <= 0) {
            this.showBusyPage(request, response, appId);
            return true;
        }
        try {
            AtomicInteger qpsAtomic = (AtomicInteger)this.appIdUri2QpsCache.get((Object)(appId + "-" + requestUri));
            int qps = qpsAtomic.get();
            if (qps >= qpsLimitInteger * this.qpsDataCacheSeconds) {
                this.showBusyPage(request, response, appId);
                final AtomicBoolean canLog = new AtomicBoolean(false);
                this.appId2WarnedFlagCache.get((Object)appId, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        canLog.set(true);
                        return appId;
                    }
                });
                if (canLog.get()) {
                    log.warn("app:{},uri:{}, qps:{},\u8d85\u51fa{}", new Object[]{appId, requestUri, qps, qpsLimitInteger});
                }
                return true;
            }
            qpsAtomic.incrementAndGet();
        }
        catch (ExecutionException e) {
            log.error("", (Throwable)e);
        }
        return false;
    }

    private boolean limitByConsumer(String consumerId, HttpServletRequest request, HttpServletResponse response, Long appId) throws IOException {
        try {
            AtomicInteger qpsAtomic = (AtomicInteger)this.consumerId2QpsCache.get((Object)consumerId);
            int qps = qpsAtomic.get();
            int limit = this.qpsDataCacheSeconds * this.userQpsLimit;
            if (qps >= limit) {
                this.showBusyPage(request, response, appId);
                log.warn("user:{} qps:{},\u8d85\u51fa{}", new Object[]{consumerId, qps, this.userQpsLimit});
                return true;
            }
            qpsAtomic.incrementAndGet();
        }
        catch (ExecutionException e) {
            log.error("", (Throwable)e);
        }
        return false;
    }

    private AppUriQpsLimit getAppUriQpsLimit(Long appId, String requestUri) {
        ConcurrentMap uri2qpsLimitMap = (ConcurrentMap)this.appId2uri2qpsLimitMap.get(appId);
        if (uri2qpsLimitMap != null) {
            for (Map.Entry entry : uri2qpsLimitMap.entrySet()) {
                if (!requestUri.startsWith((String)entry.getKey())) continue;
                AppUriQpsLimit qpsLimit = (AppUriQpsLimit)entry.getValue();
                if (qpsLimit.isExpired()) {
                    uri2qpsLimitMap.remove(entry.getKey(), qpsLimit);
                    if (!uri2qpsLimitMap.isEmpty()) continue;
                    this.appId2uri2qpsLimitMap.remove(appId);
                    continue;
                }
                return qpsLimit;
            }
        }
        return null;
    }

    public void destroy() {
        this.isDestroyed = true;
        this.zkClient.unsubscribeAll();
        this.zkClient.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showBusyPage(HttpServletRequest request, HttpServletResponse response, Long appId) throws IOException {
        if (this.isMobaiItemDetail(request)) {
            response.sendRedirect(MOBAI_ITEM_DEFAULT_BUSY_PAGE);
            return;
        }
        response.setContentType("text/html;charset=UTF-8");
        response.setCharacterEncoding("utf-8");
        try (PrintWriter out = null;){
            out = response.getWriter();
            if (Objects.equals(appId, 1L)) {
                out.write(mobaiBusyPageWihte);
            } else {
                out.write(busyPage);
            }
        }
    }

    private boolean isMobaiItemDetail(HttpServletRequest request) {
        return "/mobile/appItemDetail".equals(request.getRequestURI()) && "1385142".equals(request.getParameter("appItemId"));
    }

    public void setUserQpsLimit(int userQpsLimit) {
        this.userQpsLimit = userQpsLimit;
    }

    public int getUserQpsLimit() {
        return this.userQpsLimit;
    }

    private static class AppUriQpsLimit {
        private Date finishTime;
        private Integer qpsLimit;
        private String limitUri;

        public AppUriQpsLimit() {
        }

        public AppUriQpsLimit(Date finishTime, Integer qpsLimit, String limitUri) {
            this.finishTime = finishTime;
            this.qpsLimit = qpsLimit;
            this.limitUri = limitUri;
        }

        public boolean isExpired() {
            return this.finishTime.before(new Date());
        }

        public Date getFinishTime() {
            return this.finishTime;
        }

        public void setFinishTime(Date finishTime) {
            this.finishTime = finishTime;
        }

        public Integer getQpsLimit() {
            return this.qpsLimit;
        }

        public void setQpsLimit(Integer qpsLimit) {
            this.qpsLimit = qpsLimit;
        }

        public String getLimitUri() {
            return this.limitUri;
        }

        public void setLimitUri(String limitUri) {
            this.limitUri = limitUri;
        }
    }
}

