package cn.com.duiba.biz.tool.duiba.client;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;

/**
 * @author zhangruofan
 * @date 2018/04/14
 */
public final class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);

    private static final String DAY = "yyyy-MM-dd";

    /**
     * Private constructor since this is a utility class.
     */
    private DateUtils() {

    }
    /**
     * 获取当月最后一天
     * @return LocalDate
     */
    public static LocalDate getLastDayOfMonth(LocalDate localDate) {
        return localDate.withDayOfMonth(localDate.lengthOfMonth());
    }

    /**
     * 获取当周最后一天(周日作为最后一天)
     * @return LocalDate
     */
    public static LocalDate getLastDayOfWeek(LocalDate localDate) {
        return localDate.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
    }

    /**
     *
     * getDayDate:(这里用一句话描述这个方法的作用). <br/>
     * method : 19、根据"yyyy-MM-dd"形式的字符串 获取Date
     * @param dateStr
     * @return
     * @since JDK 1.6
     */
    public static Date getDayDate(String dateStr) {
        return getDate(dateStr, new SimpleDateFormat(DAY));
    }

    private static Date getDate(String dateStr, SimpleDateFormat format) {
        if ("".equals(dateStr) || dateStr == null)
            return null;
        try {
            return format.parse(dateStr);
        } catch (ParseException e) {
            log.error("format yyyy-MM-dd HH:mm:ss error:", e);
        }
        return null;
    }
}
