/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.tool.duiba.client;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    private static final String DAY = "yyyy-MM-dd";

    private DateUtils() {
    }

    public static LocalDate getLastDayOfMonth(LocalDate localDate) {
        return localDate.withDayOfMonth(localDate.lengthOfMonth());
    }

    public static LocalDate getLastDayOfWeek(LocalDate localDate) {
        return localDate.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
    }

    public static Date getDayDate(String dateStr) {
        return DateUtils.getDate(dateStr, new SimpleDateFormat(DAY));
    }

    private static Date getDate(String dateStr, SimpleDateFormat format) {
        if ("".equals(dateStr) || dateStr == null) {
            return null;
        }
        try {
            return format.parse(dateStr);
        }
        catch (ParseException e) {
            log.error("format yyyy-MM-dd HH:mm:ss error:", (Throwable)e);
            return null;
        }
    }
}

