package cn.com.duiba.biz.tool.duiba.mq;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * ClassName:RocketMqTagEnum<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: mq tag 枚举类
 * @date 创建时间：2018/4/21  10:27
 * @since JDK 1.8
 **/
public enum RocketMqTagEnum {
    HD_TOOL(0, "hdTool", "活动工具"),
    TAKE_PRIZE(0, "takePrize", "活动工具领奖"),
    VISIT_TIME(0, "vist", "活动参与次数")

    ;

    public static final ImmutableMap<String, RocketMqTagEnum> ALL_TAG_MAP;

    static {
        Map<String, RocketMqTagEnum> temp = Maps.newHashMap();
        for (RocketMqTagEnum tag : values()) {
            temp.put(tag.getTag(), tag);
        }
        ALL_TAG_MAP = ImmutableMap.copyOf(temp);
    }

    /** 代码编号 */
    private Integer code;
    /** tag名 */
    private String tag;
    /** 描述说明 */
    private String desc;

    RocketMqTagEnum(Integer code, String tag, String desc) {
        this.code = code;
        this.tag = tag;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getTag() {
        return tag;
    }

    public String getDesc() {
        return desc;
    }
}
