/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.tool.duiba.qpslimit;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcludePathHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ExcludePathHelper.class);
    private static Set<String> excludePaths = ImmutableSet.copyOf(ExcludePathHelper.parseUrls());

    private ExcludePathHelper() {
    }

    private static Set<String> parseUrls() {
        String[] urls;
        InputStream inputStream = ExcludePathHelper.class.getClassLoader().getResourceAsStream("META-INF/biz_tool/biz_tool.properties");
        if (inputStream == null) {
            return Collections.emptySet();
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            LOG.info("failed to load biz_tool.properties", (Throwable)e);
        }
        if (properties.isEmpty()) {
            return Collections.emptySet();
        }
        String value = (String)properties.get("qpslimit.exclude.urls");
        String trimed = StringUtils.trim((String)value);
        if (StringUtils.isEmpty((String)trimed)) {
            return Collections.emptySet();
        }
        HashSet<String> urlSet = new HashSet<String>();
        for (String url : urls = trimed.split(",")) {
            String tempUrl = StringUtils.trim((String)url);
            if (StringUtils.isEmpty((String)tempUrl)) continue;
            urlSet.add(tempUrl);
        }
        return urlSet;
    }

    public static Set<String> getExcludePaths() {
        return excludePaths;
    }
}

