package cn.com.duiba.biz.tool.duiba.mq;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * ClassName:RocketMqTagEnum<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: mq tag 枚举类
 * @date 创建时间：2018/4/21  10:27
 * @since JDK 1.8
 **/

public enum RocketMqTagEnum {

    SUB_CREDITS_NORMAL("sub_credits_normal", "常规扣积分"),
    SUB_CREDITS_ZERO("sub_credits_zero","扣0积分"),
    TAKE_PRIZE("takePrize", "活动工具领奖"),
    TAKE_PRIZE_THROUGH("takePrizeThrough", "活动工具-闯关游戏领奖"),
    VISIT_TIME("vist", "活动参与次数");

    public static final ImmutableMap<String, RocketMqTagEnum> ALL_TAG_MAP;

    static {
        Map<String, RocketMqTagEnum> temp = Maps.newHashMap();
        for (RocketMqTagEnum tag : values()) {
            temp.put(tag.getTag(), tag);
        }
        ALL_TAG_MAP = ImmutableMap.copyOf(temp);
    }

    /** tag名 */
    private String tag;
    /** 描述说明 */
    private String desc;

    RocketMqTagEnum(String tag, String desc) {
        this.tag = tag;
        this.desc = desc;
    }

    public String getTag() {
        return tag;
    }

    public String getDesc() {
        return desc;
    }
}