package cn.com.duiba.biz.tool.duiba.dao;

import cn.com.duiba.biz.tool.duiba.dto.KeyValueDto;
import cn.com.duiba.biz.tool.duiba.entity.KeyValueEntity;

import java.util.List;

/**
 *
 * Created by hww on 2018/4/25 上午10:48.
 */
public interface KeyValueDao {

    /**
     * 获取一个拓展对象的所有propName
     * @param bizId
     * @return
     */
    List<String> findAllPropNames(Long bizId);

    /**
     * 查询一个K-V
     * @param bizId
     * @param propName
     * @return
     */
    KeyValueEntity findOneEntry(Long bizId, String propName);

    /**
     * 批量查询同一个拓展对象的几个K-V
     * @param bizId
     * @param propNames
     * @return
     */
    List<KeyValueEntity> findEntries(Long bizId, List<String> propNames);

    /**
     * 查询一个拓展对象的所有K-V
     * @param bizId
     * @return
     */
    List<KeyValueEntity> findAllEntries(Long bizId);

    /**
     * 删除一个拓展对象的一个K-V
     * 删除是将propValue设置为null
     * @param biz
     * @param propName
     * @return
     */
    int deleteOneEntry(Long biz, String propName);

    /**
     * 删除一个拓展对象的几个K-V
     * 删除是将propValue设置为null
     * @param biz
     * @param propNames
     * @return
     */
    int deleteEntries(Long biz, List<String> propNames);

    /**
     * 批量删除几个对象的所有K-V
     * 删除是将propValue设置为null
     * @param biz
     * @return
     */
    int deleteAllEntries(Long biz);

    /**
     * 更新一个K-V
     * @param bizId
     * @param propName
     * @param propValue
     * @return
     */
    int updateOneEntry(Long bizId, String propName, String propValue);

    /**
     * 批量插入K-V
     * @param entries
     * @return
     */
    int insertEntries(List<KeyValueEntity> entries);

    /**
     * 批量修改K-V
     * @param itemId
     * @param entries
     * @return
     */
    int updateEntries(Long itemId, List<KeyValueDto> entries);

}
