/**
 * Project Name:activity-access-web
 * File Name:IdentificationTool.java
 * Package Name:com.duiba.activity.accessweb.tool
 * Date:2017年3月20日下午7:05:58
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.biz.tool.duiba.util;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.regex.Pattern;

/**
 * ClassName:IdentificationTool <br/>
 * Function: 身份证号信息相关工具类. <br/>
 * 只支持18位
 * Date:     2017年3月20日 下午7:05:58 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class IdentificationTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentificationTool.class);
    private static final int VERSION = 1;
    private static final int BIGINT = 36;
    private static Pattern cidReg = Pattern.compile("^1[0-9A-Za-z]+");
    private IdentificationTool(){}


    /**
     * 加密用户id
     *
     * @param consumerId 用户id
     * @return
     */
    public static String getEncryptCid(Long consumerId) {
        StringBuilder sb = new StringBuilder();
        if (consumerId > 0L) {
            sb.append(VERSION);
            sb.append(new BigInteger(String.valueOf(consumerId * 2L + 56L), 10).toString(BIGINT));
        }
        return sb.toString();
    }

    /**
     * 解密用户id
     *
     * @param encryptCid
     * @return
     */
    public static Long getDecryptCid(String encryptCid) {
        if (StringUtils.isEmpty(encryptCid)) {
            return null;
        }
        try {
            String newEncryptCid = encryptCid.substring(1, encryptCid.length());
            long reInt = Long.parseLong(new BigInteger(newEncryptCid, 36).toString(10));
            reInt = (reInt - 56L) / 2L;
            return reInt > 0L ? reInt : 0L;
        } catch (Exception e) {
            LOGGER.warn("解析加密id失败,encryptCid={}", encryptCid);
            return null;
        }
    }

    /**
     * 验证加密用户id是否合法
     *
     * @param encryptCid
     * @return
     */
    public static boolean validateEncryptCid(String encryptCid) {
        if (StringUtils.isEmpty(encryptCid)) {
            return false;
        }
        return cidReg.matcher(encryptCid).matches();
    }


}

