package cn.com.duiba.biz.tool.duiba.redis;

/**
 * 用于管理使用Redis的所有key前缀，避免业务key重复<br/>
 * 例如<br/>
 * K001("xxx业务缓存"),<br/>
 * K002("xxx业务分布式锁"), <br/>
 * K003("xxx业务计数器");<br/>
 *
 */
public enum RedisKeySpace {
	/** 爱奇艺红包任务用户解锁的人数 */
	K001("爱奇艺红包任务用户解锁的人数"),
	/** 爱奇艺红包任务用户信息 */
	K002("爱奇艺红包任务用户信息"),
	/** 爱奇艺红包任务用户开奖状态 */
	K003("爱奇艺红包任务用户开奖状态")
	;

	/**
	 * 应用名称
	 */
	private static final String SPACE = "biz_tool";

	private String desc;

	RedisKeySpace(String description) {
		this.desc = description;
	}

	public String getDesc() {
		return desc;
	}

	/**
	 * 拼接key前置
	 */
	@Override
	public String toString() {
		return SPACE + "_" + super.toString() + "_";
	}

}