package cn.com.duiba.biz.tool.duiba.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * Created by zzy on 2018/1/19.
 */
public final class GZIPCompressUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GZIPCompressUtil.class);

    private GZIPCompressUtil() {
    }

    /**
     * 压缩
     *
     * @param bytes
     * @return
     */
    public static byte[] gzip(byte[] bytes) {
        ByteArrayOutputStream outputStream = null;
        GZIPOutputStream gzipOutputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            gzipOutputStream = new GZIPOutputStream(outputStream);
            gzipOutputStream.write(bytes);
            gzipOutputStream.flush();
            gzipOutputStream.close();
            return outputStream.toByteArray();
        } catch (Exception e) {
            LOG.error("", e);
            return null;
        }
    }

    /**
     * 解压缩
     *
     * @param bytes
     * @return
     */
    public static String ungzip(byte[] bytes) {
        ByteArrayInputStream inputStream = null;
        GZIPInputStream gzipInputStream = null;
        try {
            inputStream = new ByteArrayInputStream(bytes);
            gzipInputStream = new GZIPInputStream(inputStream);

            InputStreamReader inputStreamReader = new InputStreamReader(gzipInputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            StringBuilder builder = new StringBuilder();
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line);
            }
            bufferedReader.close();
            return builder.toString();
        } catch (Exception e) {
            LOG.error("", e);
            return null;
        }
    }

//
//    public static void main(String[] args) throws UnsupportedEncodingException {
//        String src = "hellhello worhello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!hello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!hello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!hello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!hello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!hello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!ldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!hello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!o worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!hello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!";
//        byte[] unziped = src.getBytes("utf-8");
//        byte[] bytes = gzip(src);
//        System.out.println("unzip:" + unziped.length);
//        System.out.println("zip:" + bytes.length);
//        System.out.println(new String(Hex.encodeHex(bytes)));
//        System.out.println(ungzip(bytes));
//    }
}
