/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.tool.duiba.dto;

import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class RequestParams
implements Serializable {
    private static final long serialVersionUID = -714078552503355128L;
    private static final String TRANSFER_KEY = "transfer";
    private String userAgent;
    private Long consumerId;
    private String ip;
    private String os;
    private String transfer;
    private String slotId;
    private boolean proxy = false;
    private Map<String, String> cookies = new HashMap<String, String>();
    private String deap;
    private String collectRuleId;

    private RequestParams() {
    }

    public String getCollectRuleId() {
        return this.collectRuleId;
    }

    public void setCollectRuleId(String collectRuleId) {
        this.collectRuleId = collectRuleId;
    }

    public String getDeap() {
        return this.deap;
    }

    public void setDeap(String deap) {
        this.deap = deap;
    }

    public String getSlotId() {
        return this.slotId;
    }

    public void setSlotId(String slotId) {
        this.slotId = slotId;
    }

    public String getTransfer() {
        return this.transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public Long getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public String getCookies(String name) {
        return this.cookies.get(name);
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public static RequestParams parse(HttpServletRequest request) {
        RequestParams rp = new RequestParams();
        rp.setUserAgent(request.getHeader("User-Agent"));
        rp.setIp(RequestTool.getIpAddr((HttpServletRequest)request));
        rp.setConsumerId(RequestLocal.getCid());
        rp.setCookies1(request);
        rp.setOs(RequestTool.getOS((HttpServletRequest)request));
        rp.setTransfer(RequestParams.getTransfer(request));
        rp.setSlotId(RequestTool.getCookie((HttpServletRequest)request, (String)"_coll_slot"));
        rp.setProxy(RequestTool.isProxy((HttpServletRequest)request));
        rp.setDeap(RequestLocal.getDeap());
        rp.setCollectRuleId(request.getParameter("collectRuleId"));
        return rp;
    }

    public static void getCookiesForMap(Map<String, String> cookies, Map<String, String> exposureNew) {
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            if (!entry.getKey().startsWith("_coll_")) continue;
            exposureNew.put(entry.getKey(), entry.getValue());
        }
    }

    private void setCookies1(HttpServletRequest request) {
        Cookie[] getCookies = request.getCookies();
        if (getCookies != null) {
            for (Cookie c : getCookies) {
                this.cookies.put(c.getName(), c.getValue());
            }
        }
    }

    private static String getTransfer(HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getParameter(TRANSFER_KEY))) {
            return request.getParameter(TRANSFER_KEY);
        }
        Cookie[] cs = request.getCookies();
        if (cs != null) {
            for (Cookie c : cs) {
                if (!TRANSFER_KEY.equals(c.getName())) continue;
                return c.getValue();
            }
        }
        return null;
    }
}

