package cn.com.duiba.biz.tool.duiba.subcredits;


import cn.com.duiba.biz.tool.duiba.util.GZIPCompressUtil;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Map;

/**
 * ClassName:SubCreditsMsgDto<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 扣积分请求mq消息 
 * 不再提供  压缩和解压功能 需要请调用 wolf 包中 方法自行加密
 * 
 * @date 创建时间：2018/6/1 15:12
 * @since JDK 1.8
 **/
public class SubCreditsMsgDto implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1025203922881796932L;

	/**
	 * 请求类型:get
	 */
	public static final int HTTP_GET = 1;
	/**
	 * 请求类型:post
	 */
	public static final int HTTP_POST = 2;

	/**
	 * 兑吧sdk扣积分参数
	 */
	private CreditConsumeParams creditConsumeParams;

	/**
	 * appId
	 */
	private Long appId;
	/**
	 * consumerId
	 */
	private Long consumerId;
	/**
	 * 活动类型，SubCreditsMsg.TYPE_*
	 */
	private SubCreditsType relationType;
	/**
	 * 关联id，比如子订单id，主订单id等，方面问题定位
	 */
	private String relationId;
	/**
	 * 请求类型：默认get
	 */
	private int httpType = HTTP_GET;

	/**
	 * appSecret
	 */
	private String appSecret;

	/**
	 * 扣积分地址前缀
	 */
	private String creditsConsumeRequestUrl;

	/**
	 * 时间戳
	 */
	private Long timestamp = System.currentTimeMillis();

	/**
	 * 用于组装post请求消息体
	 */
	private Map<String, String> authParams;
	/**
	 * 扩展参数
	 */
	private Map<String, String> params;

	/**
	 * mq回调topic
	 */
	private String callbackTopic;
	/**
	 * mq回调tag
	 */
	private String callbackTag;
	/**
	 * mq回调key
	 */
	private String callbackKey;

	public CreditConsumeParams getCreditConsumeParams() {
		return creditConsumeParams;
	}

	public void setCreditConsumeParams(CreditConsumeParams creditConsumeParams) {
		this.creditConsumeParams = creditConsumeParams;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public SubCreditsType getRelationType() {
		return relationType;
	}

	public void setRelationType(SubCreditsType relationType) {
		this.relationType = relationType;
	}

	public String getRelationId() {
		return relationId;
	}

	public void setRelationId(String relationId) {
		this.relationId = relationId;
	}

	public int getHttpType() {
		return httpType;
	}

	public void setHttpType(int httpType) {
		this.httpType = httpType;
	}

	public String getAppSecret() {
		return appSecret;
	}

	public void setAppSecret(String appSecret) {
		this.appSecret = appSecret;
	}

	public String getCreditsConsumeRequestUrl() {
		return creditsConsumeRequestUrl;
	}

	public void setCreditsConsumeRequestUrl(String creditsConsumeRequestUrl) {
		this.creditsConsumeRequestUrl = creditsConsumeRequestUrl;
	}

	public Long getTimestamp() {
		return timestamp;
	}

	public void setTimestamp(Long timestamp) {
		this.timestamp = timestamp;
	}

	public Map<String, String> getAuthParams() {
		return authParams;
	}

	public void setAuthParams(Map<String, String> authParams) {
		this.authParams = authParams;
	}

	public Map<String, String> getParams() {
		return params;
	}

	public void setParams(Map<String, String> params) {
		this.params = params;
	}

	public String getCallbackTopic() {
		return callbackTopic;
	}

	public void setCallbackTopic(String callbackTopic) {
		this.callbackTopic = callbackTopic;
	}

	public String getCallbackTag() {
		return callbackTag;
	}

	public void setCallbackTag(String callbackTag) {
		this.callbackTag = callbackTag;
	}

	public String getCallbackKey() {
		return callbackKey;
	}

	public void setCallbackKey(String callbackKey) {
		this.callbackKey = callbackKey;
	}

	/**
	 * 解码消息，接收mq消息使用
	 *
	 * @param msg
	 * @return
	 */
	public static SubCreditsMsgDto decode(byte[] msg) {
		String string = GZIPCompressUtil.ungzip(msg);
		if (string == null || string.isEmpty()) {
			return null;
		}
		return JSONObject.parseObject(string, SubCreditsMsgDto.class);
	}

	/**
	 * 编码消息，发送时使用
	 *
	 * @param subCreditsMsg
	 * @return
	 */
	public static byte[] encode(SubCreditsMsgDto subCreditsMsg) {
		String string = JSONObject.toJSONString(subCreditsMsg);
		try {
			byte[] str = string.getBytes("utf-8");
			return GZIPCompressUtil.gzip(str);
		} catch (UnsupportedEncodingException e) {
			return null;
		}
	}
}
