package cn.com.duibabiz.versioncheck;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duibabiz.tools.BizToolJarVersionUtils;
import cn.com.duibaboot.ext.autoconfigure.DuibaBootVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

/**
 * Created by sunchangji on 2018/11/2.
 */
@Configuration
@ConditionalOnClass(MainContextRefreshedEvent.class)
@EnableConfigurationProperties(BizVersionCheckProperties.class)
public class JarVersionCheckConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(JarVersionCheckConfiguration.class);

    @Autowired
    private BizVersionCheckProperties bizVersionCheckProperties;

    @EventListener(MainContextRefreshedEvent.class)
    public void checkVersion() {
        //生产环境不做检测
        if (SpringEnvironmentUtils.isProdEnv()) {
            return;
        }
        String bizToolVersion = BizToolVersion.getVersion();
        if (bizToolVersion == null) {
            LOG.warn("检测到biz-tool无版本号,请联系@孙长纪");
            return;
        }
        String bizToolBaseVersion = bizVersionCheckProperties.getBiztool();
        Boolean adopt = BizToolJarVersionUtils.isJarVersionEqualOrGreaterThan(bizToolVersion, bizToolBaseVersion);
        if (adopt == null) {
            throw new BizToolRuntimeException("检测到项目当前引入biz-tool版本:" + bizToolVersion + ",版本定义不符合要求,请确保版本不低于:" + bizToolBaseVersion);
        }
        if (adopt) {
            throw new BizToolRuntimeException("检测到项目当前引入biz-tool版本:" + bizToolVersion + ",请升至:" + bizToolBaseVersion + "或以上");
        }
        String duibaExtVersion = DuibaBootVersion.getVersion();
        if (duibaExtVersion == null) {
            LOG.warn("检测到duiba-boot-ext无版本号,请联系@孙长纪");
            return;
        }
        String duibaBootBaseVersion = bizVersionCheckProperties.getDuibaext();
        adopt = BizToolJarVersionUtils.isJarVersionEqualOrGreaterThan(duibaExtVersion, duibaBootBaseVersion);
        if (adopt == null) {
            throw new BizToolRuntimeException("检测到项目当前引入duiba-boot-ext版本:" + duibaExtVersion + ",版本定义不符合要求,请确保版本不低于:" + duibaBootBaseVersion);
        }
        if (adopt) {
            throw new BizToolRuntimeException("检测到项目当前引入duiba-boot-ext版本:" + bizToolVersion + ",请升至:" + duibaBootBaseVersion + "或以上");
        }
    }
}
