package cn.com.duiba.biz.tool.duiba.addcredits;

import cn.com.duiba.biz.tool.duiba.enums.HttpRequestResultType;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.Map;

/**
 * @author zhangruofan
 * @date 2018/07/13
 */
public class AddCreditsResultMsgDto implements Serializable {
    /*
     * 透传参数的KEY
     */
    public static final String USER_IP = "ip";
    public static final String USER_ID = "uid";
    public static final String TRANSFER = "transfer";
    private static final long serialVersionUID = 2380828358205487511L;

    /**
     * 加积分业务类型
     */
    private AddCreditsType relationType;
    /**
     * 兑吧加积分关联业务ID
     */
    private String relationId;
    private String appId;
    private String consumerId;
    /**
     * 第三方服务加积分请求响应结果类型
     */
    private HttpRequestResultType callbackType;
    /**
     * 需要第三方服务请求的目标url
     */
    private String httpUrl;
    /**
     * 开发者响应信息
     */
    private String message;
    /**
     * 第三方服务透传参数
     */
    private Map<String, String> params;

    /**
     * 反序列化开发者加积分响应信息
     * @return
     */
    public AddCreditsDevMsgDto parseCreditsResponse() {
        AddCreditsDevMsgDto addCreditsResponse;
        try {
            addCreditsResponse = JSONObject.parseObject(message, AddCreditsDevMsgDto.class);
        } catch (Exception e) {
            addCreditsResponse = new AddCreditsDevMsgDto();
            addCreditsResponse.setErrorMessage("加积分响应返回值反序列化失败,message=" + message);
            return addCreditsResponse;
        }
        if(addCreditsResponse == null){
            addCreditsResponse = new AddCreditsDevMsgDto();
            addCreditsResponse.setErrorMessage("加积分响应返回值反序列化失败,message=" + message);
            return addCreditsResponse;
        }
        return addCreditsResponse;
    }

    public AddCreditsType getRelationType() {
        return relationType;
    }

    public void setRelationType(AddCreditsType relationType) {
        this.relationType = relationType;
    }

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public HttpRequestResultType getCallbackType() {
        return callbackType;
    }

    public void setCallbackType(HttpRequestResultType callbackType) {
        this.callbackType = callbackType;
    }

    public String getHttpUrl() {
        return httpUrl;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }
}
