package cn.com.duiba.biz.tool.duiba.subcredits;

import cn.com.duiba.biz.tool.duiba.enums.HttpRequestResultType;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;

/**
 * @author zhangruofan
 * @date 2018/07/13
 */
public class SubCreditsResultMsgDto implements Serializable {

    /**
     * http消息请求完成:扣积分成功
     */
    public static final int CODE_SUCCESS = 1;
    /**
     * http消息请求完成:扣积分消息解析失败
     */
    public static final int CODE_PARSE_JSON_FAIL = 2;
    /**
     * http消息请求完成:积分不够
     */
    public static final int CODE_NORMAL_FAIL = 3;
    private static final long serialVersionUID = -8106554213961142241L;

    /**
     * 回调类型
     */
    private HttpRequestResultType resultType;
    /**
     * 扣积分是否成功标志，ture表示成功，false失败
     */
    private int code;
    /**
     * 开发者id，扣积分成功后必选
     */
    private String bizId;

    /**
     * 扣积分成功后必选
     */
    private Long credits;

    /**
     * 开发者返回的扣积分失败文案
     */
    private String errorMessage;

    /**
     * 开发者响应消息，仅扣积分json解析失败时存在
     */
    private String response;

    private Long appId;
    private Long consumerId;
    private String relationId;
    private SubCreditsType relationType;
    private String httpUrl;
    private Map<String, String> params;

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    public SubCreditsType getRelationType() {
        return relationType;
    }

    public void setRelationType(SubCreditsType relationType) {
        this.relationType = relationType;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public HttpRequestResultType getResultType() {
        return resultType;
    }

    public void setResultType(HttpRequestResultType resultType) {
        this.resultType = resultType;
    }

    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String getHttpUrl() {
        return httpUrl;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getResponse() {
        return response;
    }

    public void setResponse(String response) {
        this.response = response;
    }


    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg byte数组
     * @return SubCreditsResultMsgDto
     */
    public static SubCreditsResultMsgDto decode(byte[] msg) {
        String string = new String(msg, Charset.forName("utf-8"));
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return JSONObject.parseObject(string, SubCreditsResultMsgDto.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param subCreditsResultMsg 返回的dto
     * @return byte数组
     */
    public static byte[] encode(SubCreditsResultMsgDto subCreditsResultMsg) {
        String string = JSONObject.toJSONString(subCreditsResultMsg);
        return string.getBytes(Charset.forName("utf-8"));
    }
}