/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.oss.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duibabiz.component.oss.OssClient;
import cn.com.duibabiz.component.oss.OssProperties;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OssClientImpl
implements OssClient {
    private static final Logger logger = LoggerFactory.getLogger(OssClientImpl.class);
    @Autowired
    private OssProperties ossProperties;

    @Override
    public String upload(String bucketName, String path, File file) throws BizException {
        return this.upload(bucketName, path, file, null);
    }

    @Override
    public String upload(String bucketName, String path, String base64) throws BizException {
        return this.upload(bucketName, path, null, base64);
    }

    public String upload(String bucketName, String path, File file, String base64) throws BizException {
        HttpRequest post = HttpUtil.createPost((String)this.ossProperties.getUploadUrl());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bucketName", bucketName);
        map.put("path", path);
        if (file != null) {
            post.form("file", file);
        }
        if (StringUtils.isNotBlank((CharSequence)base64)) {
            map.put("base64", base64);
        }
        post.form(map);
        post.timeout(5000);
        HttpResponse execute = post.execute();
        try {
            String result = execute.body();
            JSONObject jsonObject = JSON.parseObject((String)result);
            Boolean success = jsonObject.getBoolean("success");
            if (!success.booleanValue()) {
                throw new BizException(jsonObject.getString("message"));
            }
            return jsonObject.getString("data");
        }
        catch (Exception e) {
            logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            throw new BizException("\u7cfb\u7edf\u5f02\u5e38");
        }
    }
}

